/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.selection;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.level.handler.LittleAnimationHandler;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;

public class SelectionResult {
    public final Level level;
    private int blocks;
    private int ltBlocks = 0;
    private int ltTiles = 0;
    private LittleGrid minLtGrid = null;
    private int cbBlocks = 0;
    private int cbTiles = 0;
    private LittleGrid minCBGrid = null;
    private BlockPos.MutableBlockPos min = null;
    private BlockPos.MutableBlockPos max = null;

    public SelectionResult(Level level) {
        this.level = level;
    }

    public boolean hasBlocks() {
        return this.blocks > 0;
    }

    public List<Component> blockInfo() {
        return new TextBuilder().text(this.blocks + " ").translate("selection.blocks").build();
    }

    public boolean hasTiles() {
        return this.ltBlocks > 0;
    }

    public List<Component> ltInfo() {
        return new TextBuilder().text(this.ltBlocks + " ").translate("gui.blocks").text(", " + this.ltTiles + " ").translate("gui.tiles").text(", " + this.minLtGrid.count + " ").translate("gui.grid").build();
    }

    public boolean hasCB() {
        return this.cbBlocks > 0;
    }

    public List<Component> cbInfo() {
        return new TextBuilder().text(this.cbBlocks + " ").translate("gui.blocks").text(", " + this.cbTiles + " ").translate("gui.tiles").text(", " + this.minCBGrid.count + " ").translate("gui.grid").build();
    }

    public LittleGrid minGrid(boolean includeLT, boolean includeCB) {
        LittleGrid minRequired = LittleGrid.MIN;
        if (includeLT && this.minLtGrid != null) {
            minRequired = LittleGrid.max(minRequired, this.minLtGrid);
        }
        if (includeCB && this.minCBGrid != null) {
            minRequired = LittleGrid.max(minRequired, this.minCBGrid);
        }
        return minRequired;
    }

    private void addBlockDirectly(Level level, BlockPos pos) {
        LittleGroup specialPreviews;
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof BETiles) {
            ++this.ltBlocks;
            this.ltTiles += ((BETiles)te).tilesCount();
            this.minLtGrid = this.minLtGrid == null ? ((BETiles)te).getGrid() : LittleGrid.max(this.minLtGrid, ((BETiles)te).getGrid());
        }
        if ((specialPreviews = ChiselsAndBitsManager.getGroup(te)) != null) {
            ++this.cbBlocks;
            this.cbTiles += specialPreviews.size();
            this.minCBGrid = this.minCBGrid == null ? specialPreviews.getGrid() : LittleGrid.max(this.minCBGrid, specialPreviews.getGrid());
        }
        if (LittleAction.isBlockValid(level.getBlockState(pos))) {
            ++this.blocks;
        }
    }

    public void addBlock(BlockPos pos) {
        if (this.min == null) {
            this.min = pos.mutable();
            this.max = pos.mutable();
        } else {
            this.min.set(Math.min(this.min.getX(), pos.getX()), Math.min(this.min.getY(), pos.getY()), Math.min(this.min.getZ(), pos.getZ()));
            this.max.set(Math.max(this.max.getX(), pos.getX()), Math.max(this.max.getY(), pos.getY()), Math.max(this.max.getZ(), pos.getZ()));
        }
        this.addBlockDirectly(this.level, pos);
    }

    protected void addBlocksWorld(Level level, BlockPos pos, BlockPos pos2) {
        int minX = Math.min(pos.getX(), pos2.getX());
        int minY = Math.min(pos.getY(), pos2.getY());
        int minZ = Math.min(pos.getZ(), pos2.getZ());
        int maxX = Math.max(pos.getX(), pos2.getX());
        int maxY = Math.max(pos.getY(), pos2.getY());
        int maxZ = Math.max(pos.getZ(), pos2.getZ());
        if (this.min == null) {
            this.min = new BlockPos.MutableBlockPos(minX, minY, minZ);
            this.max = new BlockPos.MutableBlockPos(maxX, maxY, maxZ);
        } else {
            this.min.set(Math.min(this.min.getX(), minX), Math.min(this.min.getY(), minY), Math.min(this.min.getZ(), minZ));
            this.max.set(Math.max(this.max.getX(), minX), Math.max(this.max.getY(), minY), Math.max(this.max.getZ(), minZ));
        }
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    this.addBlockDirectly(level, (BlockPos)mutPos.set(posX, posY, posZ));
                }
            }
        }
    }

    public void addBlocks(BlockPos pos, BlockPos pos2) {
        int minX = Math.min(pos.getX(), pos2.getX());
        int minY = Math.min(pos.getY(), pos2.getY());
        int minZ = Math.min(pos.getZ(), pos2.getZ());
        int maxX = Math.max(pos.getX(), pos2.getX());
        int maxY = Math.max(pos.getY(), pos2.getY());
        int maxZ = Math.max(pos.getZ(), pos2.getZ());
        this.addBlocksWorld(this.level, pos, pos2);
        for (LittleEntity entity : ((LittleAnimationHandler)LittleTiles.ANIMATION_HANDLERS.get(this.level)).find(new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1)))) {
            this.addBlocksWorld((Level)entity.getSubLevel(), pos, pos2);
        }
    }

    public Vec3i getSize() {
        return new Vec3i(this.max.getX() - this.min.getX(), this.max.getY() - this.min.getY(), this.max.getZ() - this.min.getZ());
    }
}

