/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import java.util.ArrayList;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.interpolation.CubicInterpolation;
import team.creative.creativecore.common.util.math.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.interpolation.LinearInterpolation;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.VecNd;
import team.creative.creativecore.common.util.math.vec.VectorUtils;
import team.creative.littletiles.client.tool.shaper.ShapePosition;
import team.creative.littletiles.client.tool.shaper.ShapeSelection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.config.InterpolationAxisThicknessConfig;
import team.creative.littletiles.common.placement.shape.type.LittleShapeCurve;

public class LittleShapeCurveWall
extends LittleShape<InterpolationAxisThicknessConfig> {
    public LittleShapeCurveWall() {
        super(2);
    }

    @Override
    protected void build(LittleBoxes boxes, ShapeSelection selection, InterpolationAxisThicknessConfig config) {
        LittleBox overallBox = selection.getOverallBox();
        Axis axis = config.axis;
        Axis one = axis.one();
        Axis two = axis.two();
        ArrayList<Vec2d> points = new ArrayList<Vec2d>();
        double halfPixelSize = selection.grid.halfPixelLength;
        for (ShapePosition pos : selection) {
            points.add(new Vec2d(pos.getVanillaGrid(one) + halfPixelSize, pos.getVanillaGrid(two) + halfPixelSize));
        }
        int thickness = Math.max(0, config.thickness - 1);
        if (points.size() <= 1) {
            LittleBox box = selection.getOverallBox();
            box.growCentered(thickness);
            boxes.add(box);
            return;
        }
        HermiteInterpolation interpolation = switch (config.interpolation) {
            default -> throw new MatchException(null, null);
            case LittleShapeCurve.ShapeInterpolation.HERMITE -> new HermiteInterpolation((VecNd[])points.toArray(new Vec2d[0]));
            case LittleShapeCurve.ShapeInterpolation.CUBIC -> new CubicInterpolation((VecNd[])points.toArray(new Vec2d[0]));
            case LittleShapeCurve.ShapeInterpolation.LINEAR -> new LinearInterpolation((VecNd[])points.toArray(new Vec2d[0]));
        };
        Vec2d origin = new Vec2d((double)VectorUtils.get((Axis)one, (Vec3i)boxes.pos), (double)VectorUtils.get((Axis)two, (Vec3i)boxes.pos));
        double pointTime = 1.0 / (double)(points.size() - 1);
        for (int i = 0; i < points.size() - 1; ++i) {
            Vec2d before = (Vec2d)points.get(i);
            Vec2d end = (Vec2d)points.get(i + 1);
            Vec2d middle = (Vec2d)interpolation.valueAt(pointTime * ((double)i + 0.5));
            double distance = before.distance(middle) + middle.distance(end);
            int stepCount = (int)Math.ceil(distance / boxes.grid.pixelLength * 2.0);
            double stepSize = pointTime / (double)(stepCount - 1);
            for (int j = 0; j < stepCount; ++j) {
                Vec2d vec = (Vec2d)interpolation.valueAt(pointTime * (double)i + stepSize * (double)j);
                vec.sub(origin);
                LittleVec point = new LittleVec(0, 0, 0);
                point.set(one, boxes.grid.toGrid(vec.x));
                point.set(two, boxes.grid.toGrid(vec.y));
                LittleBox box = new LittleBox(point);
                box.setMin(axis, overallBox.getMin(axis));
                box.setMax(axis, overallBox.getMax(axis));
                box.growCentered(thickness);
                boxes.add(box);
            }
        }
    }

    @Override
    protected boolean requiresNoOverlap(ShapeSelection selection, InterpolationAxisThicknessConfig config) {
        return true;
    }
}

