/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.StackIngredient;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;

public abstract class LittleStructurePremade
extends LittleStructure {
    public LittleStructurePremade(LittlePremadeType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public ItemStack getStructureDrop() throws CorruptedConnectionException, NotYetConnectedException {
        ItemStack stack = LittlePremadeRegistry.createStack(this.type.id);
        this.checkConnections();
        BlockPos.MutableBlockPos pos = this.getMinPos(this.getStructurePos().mutable());
        CompoundTag structureNBT = new CompoundTag();
        this.savePreview(structureNBT, (HolderLookup.Provider)this.getStructureLevel().registryAccess(), (BlockPos)pos);
        CompoundTag data = ILittleTool.getData(stack);
        data.put("s", (Tag)structureNBT);
        ILittleTool.setData(stack, data);
        if (this.name != null) {
            stack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)this.name));
        }
        return stack;
    }

    public static class LittlePremadeType
    extends LittleStructureType {
        public final String path;
        public final String modid;
        public boolean showInCreativeTab = true;
        public boolean snapToGrid = true;

        public <T extends LittleStructurePremade> LittlePremadeType(String id, String path, Class<T> structureClass, BiFunction<? extends LittlePremadeType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid) {
            super(id, structureClass, factory, attribute.premade());
            this.modid = modid;
            this.path = path;
        }

        public <T extends LittleStructurePremade> LittlePremadeType(String id, Class<T> structureClass, BiFunction<? extends LittlePremadeType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid) {
            this(id, "", structureClass, factory, attribute, modid);
        }

        public boolean hasCustomTab() {
            return false;
        }

        public ItemStack createItemStackEmpty() {
            return new ItemStack((ItemLike)LittleTilesRegistry.PREMADE.value());
        }

        public ItemStack createItemStack() {
            ItemStack stack = this.createItemStackEmpty();
            CompoundTag structureNBT = new CompoundTag();
            structureNBT.putString("id", this.id);
            CompoundTag stackNBT = new CompoundTag();
            stackNBT.put("s", (Tag)structureNBT);
            ILittleTool.setData(stack, stackNBT);
            return stack;
        }

        public LittlePremadeType setNotShowCreativeTab() {
            this.showInCreativeTab = false;
            return this;
        }

        public LittlePremadeType setNotSnapToGrid() {
            this.snapToGrid = false;
            return this;
        }

        @Override
        public boolean canOnlyBePlacedByItemStack() {
            return true;
        }

        public boolean canSnapToGrid() {
            return true;
        }

        @Override
        public boolean tilesCountAsIngredient() {
            return false;
        }

        @Override
        public void addIngredients(HolderLookup.Provider provider, LittleGroup group, LittleIngredients ingredients) {
            super.addIngredients(provider, group, ingredients);
            ingredients.add(new StackIngredient(this.createItemStack()));
        }
    }
}

