/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.packet.update.NeighborUpdate;

public class NeighborUpdateOrganizer {
    private HashMapList<Level, BlockPos> positions = new HashMapList();

    public NeighborUpdateOrganizer() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void add(Level level, BlockPos pos) {
        if (level instanceof IOrientatedLevel) {
            return;
        }
        if (!this.positions.contains((Object)level, (Object)pos)) {
            this.positions.add((Object)level, (Object)pos);
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Pre event) {
        for (Map.Entry entry : this.positions.entrySet()) {
            Level level = (Level)entry.getKey();
            if (level instanceof ServerLevel) {
                HashMapList chunks = new HashMapList();
                for (BlockPos pos : (ArrayList)entry.getValue()) {
                    chunks.add((Object)new ChunkPos(pos), (Object)pos);
                }
                for (Player player : level.players()) {
                    ArrayList<BlockPos> collected = new ArrayList<BlockPos>();
                    for (Map.Entry chunk : chunks.entrySet()) {
                        if (NeighborUpdateOrganizer.checkerboardDistance((ChunkPos)chunk.getKey(), (ServerPlayer)player, true) > player.getServer().getPlayerList().getViewDistance()) continue;
                        collected.addAll((Collection)chunk.getValue());
                    }
                    if (collected.isEmpty()) continue;
                    LittleTiles.NETWORK.sendToClient((CreativePacket)new NeighborUpdate(level, collected), (ServerPlayer)player);
                }
                continue;
            }
            if (!(level instanceof ISubLevel)) continue;
            ISubLevel sub = (ISubLevel)level;
            LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new NeighborUpdate(level, (List)entry.getValue()), sub.getHolder());
        }
        this.positions.clear();
    }

    private static int checkerboardDistance(ChunkPos pos, ServerPlayer player, boolean p_140341_) {
        int j;
        int i;
        if (p_140341_) {
            SectionPos sectionpos = player.getLastSectionPos();
            i = sectionpos.x();
            j = sectionpos.z();
        } else {
            i = SectionPos.blockToSectionCoord((int)player.getBlockX());
            j = SectionPos.blockToSectionCoord((int)player.getBlockZ());
        }
        return NeighborUpdateOrganizer.checkerboardDistance(pos, i, j);
    }

    private static int checkerboardDistance(ChunkPos pos, int x, int z) {
        return Math.max(Math.abs(pos.x - x), Math.abs(pos.z - z));
    }

    @SubscribeEvent
    public void unload(LevelEvent.Unload event) {
        this.positions.removeKey((Object)((Level)event.getLevel()));
    }
}

