/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.face.RenderBoxFace;
import team.creative.creativecore.client.render.face.RenderBoxFaceSpecial;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.littletiles.client.render.cache.AdditionalBufferReceiver;
import team.creative.littletiles.client.render.cache.BlockBufferCache;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingBlockContext;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleFaceState;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

@OnlyIn(value=Dist.CLIENT)
public class BERenderManager {
    private BETiles be;
    private volatile AtomicInteger blocked = new AtomicInteger(0);
    private volatile byte requestedIndex = (byte)-1;
    private int renderState = -1;
    private boolean queued = false;
    private boolean eraseBoxCache = false;
    public boolean hasLightChanged = false;
    private boolean neighbourChanged = false;
    private double cachedRenderDistance = 0.0;
    private AABB cachedRenderBoundingBox = null;
    private boolean requireRenderingBoundingBoxUpdate = false;
    private final BlockBufferCache bufferCache = new BlockBufferCache();
    private Int2ObjectMap<ChunkLayerMapList<LittleRenderBox>> boxCache = null;

    public BERenderManager(BETiles be) {
        this.be = be;
    }

    public void setBe(BETiles be) {
        this.be = be;
    }

    public boolean isInQueue() {
        return this.queued;
    }

    public boolean isInQueueOrBeforeBuilding() {
        return this.queued || this.renderState == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sectionUpdate(long pos) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            boolean doesNeedUpdate;
            boolean bl = doesNeedUpdate = this.neighbourChanged || this.hasLightChanged || this.requestedIndex == -1 || this.bufferCache.hasInvalidBuffers();
            if (this.renderState != RenderingThread.CURRENT_RENDERING_INDEX) {
                this.eraseBoxCache = true;
                doesNeedUpdate = true;
                this.setBuffersEmpty();
            }
            this.hasLightChanged = false;
            this.neighbourChanged = false;
            if (doesNeedUpdate) {
                this.queue(this.eraseBoxCache, true, pos);
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked.get() > 0;
    }

    public boolean getAndSetBlocked() {
        return this.blocked.getAndIncrement() > 0;
    }

    public void unsetBlocked() {
        this.blocked.decrementAndGet();
    }

    public void tilesChanged() {
        this.requireRenderingBoundingBoxUpdate = true;
        this.cachedRenderDistance = 0.0;
        this.queue(true, false, 0L);
    }

    public void markRenderBoundingBoxDirty() {
        this.requireRenderingBoundingBoxUpdate = true;
    }

    public double getMaxRenderDistance() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 64.0;
            for (LittleStructure structure : this.be.rendering()) {
                renderDistance = Math.max(renderDistance, structure.getMaxRenderDistance());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public AABB getRenderBoundingBox() {
        if (this.requireRenderingBoundingBoxUpdate || this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            boolean found = false;
            for (LittleStructure structure : this.be.rendering()) {
                AABB box = structure.getRenderBoundingBox();
                if (box == null) continue;
                box = box.move(this.be.getBlockPos());
                minX = Math.min(box.minX, minX);
                minY = Math.min(box.minY, minY);
                minZ = Math.min(box.minZ, minZ);
                maxX = Math.max(box.maxX, maxX);
                maxY = Math.max(box.maxY, maxY);
                maxZ = Math.max(box.maxZ, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AABB(minX, minY, minZ, maxX, maxY, maxZ) : new AABB(this.be.getBlockPos());
            this.requireRenderingBoundingBoxUpdate = false;
        }
        return this.cachedRenderBoundingBox;
    }

    public void onNeighbourChanged() {
        this.neighbourChanged = true;
        this.queue(false, false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(boolean eraseBoxCache, boolean hasPos, long pos) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            this.requestedIndex = (byte)(this.requestedIndex + 1);
            this.eraseBoxCache |= eraseBoxCache;
            if (!this.queued && RenderingThread.queue(this.be, hasPos, pos)) {
                this.queued = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startBuildingCache() {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            if (this.eraseBoxCache) {
                this.boxCache = null;
                this.eraseBoxCache = false;
            }
            this.blocked.incrementAndGet();
            return this.requestedIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finishBuildingCache(int index, ChunkLayerMap<BufferCache> buffers, int renderState, boolean force) {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            boolean done;
            this.renderState = renderState;
            boolean bl = done = force || index == this.requestedIndex && this.renderState == renderState;
            if (done) {
                this.queued = false;
            }
            this.hasLightChanged = false;
            this.bufferCache.setBuffers(buffers);
            return done;
        }
    }

    public void resetRenderingState() {
        this.queued = false;
        this.requestedIndex = (byte)-1;
    }

    public void eraseBoxCache() {
        this.boxCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chunkUnload() {
        BERenderManager bERenderManager = this;
        synchronized (bERenderManager) {
            this.bufferCache.setEmpty();
            this.boxCache = null;
            this.cachedRenderBoundingBox = null;
        }
    }

    public IBlockBufferCache buffers() {
        return this.bufferCache;
    }

    public void additionalBuffers(Consumer<AdditionalBufferReceiver> consumer) {
        this.bufferCache.executeAdditional(consumer);
    }

    public void setBuffersEmpty() {
        this.bufferCache.setEmpty();
    }

    public boolean hasAdditionalBuffers() {
        return this.bufferCache.hasAdditional();
    }

    public void beforeBuilding(RenderingBlockContext context) {
        if (this.neighbourChanged) {
            this.neighbourChanged = false;
            if (this.boxCache != null) {
                for (ChunkLayerMapList map : this.boxCache.values()) {
                    for (LittleRenderBox cube : map) {
                        for (int k = 0; k < Facing.VALUES.length; ++k) {
                            LittleFaceState state;
                            Facing facing = Facing.VALUES[k];
                            if (cube.box == null || !(state = cube.box.getFaceState(facing)).outside()) continue;
                            this.calculateFaces(facing, state, context, (LittleTile)cube.customData, cube.box, cube);
                        }
                    }
                }
            }
        }
    }

    private void calculateFaces(Facing facing, LittleFaceState state, RenderingBlockContext context, @Nullable LittleTile tile, LittleBox box, LittleRenderBox cube) {
        if (state.coveredFully()) {
            cube.setFace(facing, RenderBoxFace.NOT_RENDER);
            return;
        }
        if (tile != null && tile.isTranslucent() && state.partially()) {
            LittleFace face = cube.box.generateFace(this.be.getGrid(), facing);
            if (face == null) {
                cube.setFace(facing, RenderBoxFace.NOT_RENDER);
            } else {
                BETiles toCheck = this.be;
                if (state.outside()) {
                    toCheck = context.getNeighbour(facing);
                    face.move(facing);
                }
                if (toCheck.shouldFaceBeRendered(face, tile)) {
                    cube.setFace(facing, (RenderBoxFace)new RenderBoxFaceSpecial(face.generateFans(), (float)face.grid.pixelLength));
                } else {
                    cube.setFace(facing, RenderBoxFace.NOT_RENDER);
                }
            }
            cube.customData = tile;
        } else {
            cube.setFace(facing, RenderBoxFace.RENDER);
        }
    }

    public Int2ObjectMap<ChunkLayerMapList<LittleRenderBox>> cachedBoxes() {
        return this.boxCache;
    }

    public Int2ObjectMap<ChunkLayerMapList<LittleRenderBox>> getRenderingBoxes(RenderingBlockContext context) {
        if (this.boxCache != null) {
            return this.boxCache;
        }
        this.boxCache = new Int2ObjectArrayMap();
        LittleServerFace serverFace = new LittleServerFace(this.be);
        for (IParentCollection parent : this.be.groups()) {
            int n;
            ChunkLayerMapList boxes = new ChunkLayerMapList();
            boxes.consumeEachLayer((layer, list) -> {
                for (LittleTile tile : parent) {
                    if (!tile.canRenderInLayer((RenderType)layer)) continue;
                    for (LittleBox box : tile) {
                        box.hasOrCreateFaceState(parent, tile, serverFace);
                        LittleRenderBox cube = parent.getRenderingBox(tile, box, (RenderType)layer);
                        if (cube == null) continue;
                        for (int k = 0; k < Facing.VALUES.length; ++k) {
                            this.calculateFaces(Facing.VALUES[k], cube.box.getFaceState(Facing.VALUES[k]), context, tile, box, cube);
                        }
                        list.add(cube);
                    }
                }
            });
            if (LittleStructureAttribute.extraRendering(parent.getAttribute())) {
                try {
                    LittleStructure structure = parent.getStructure();
                    structure.checkConnections();
                    structure.getRenderingBoxes(this.be.getBlockPos(), (ChunkLayerMapList<LittleRenderBox>)boxes);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structure) {
                    // empty catch block
                }
            }
            if (boxes.isEmpty()) continue;
            if (parent instanceof IStructureParentCollection) {
                IStructureParentCollection s = (IStructureParentCollection)parent;
                n = s.getIndex();
            } else {
                n = -1;
            }
            this.boxCache.put(n, (Object)boxes);
        }
        return this.boxCache;
    }
}

