/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.client.render.cache.build.RenderingThread;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;

public class RenderingBlockContext {
    public final BETiles be;
    public final BlockState state;
    private final long pos;
    private final RenderingLevelHandler handler;
    public int index;
    public boolean proccessed = false;
    public HashMap<Facing, BETiles> neighboursBEs;

    public RenderingBlockContext(BETiles be, boolean hasPos, long pos, RenderingLevelHandler handler) {
        this.be = be;
        this.state = be.getBlockState();
        if (!hasPos) {
            pos = handler.sectionPos(be);
        }
        this.pos = pos;
        this.handler = handler;
    }

    public void checkRemoved() throws RenderingThread.RemovedBlockEntityException {
        if (this.be.isRemoved()) {
            throw new RenderingThread.RemovedBlockEntityException(String.valueOf(this.be.getBlockPos()));
        }
    }

    public void checkLoaded() throws RenderingThread.RenderingException {
        if (this.be.getLevel() == null || !this.be.hasLoaded()) {
            throw new RenderingThread.RenderingException("BlockEntity is not loaded yet");
        }
        if (this.be.render.isBlocked()) {
            throw new RenderingThread.RenderingBlockedException();
        }
    }

    public void beforeBuilding() {
        this.be.render.beforeBuilding(this);
    }

    public void clearQuadBuilding() {
        this.neighboursBEs = null;
    }

    public BETiles getNeighbour(Facing facing) {
        if (this.neighboursBEs == null) {
            this.neighboursBEs = new HashMap();
        } else if (this.neighboursBEs.containsKey(facing)) {
            return this.neighboursBEs.get(facing);
        }
        BlockEntity be = this.be.getLevel().getBlockEntity(this.be.getBlockPos().relative(facing.toVanilla()));
        BETiles result = be instanceof BETiles ? (BETiles)be : null;
        this.neighboursBEs.put(facing, result);
        return result;
    }

    public void unsetBlocked() {
        this.be.render.unsetBlocked();
    }

    public Level getLevel() {
        return this.be.getLevel();
    }

    public RenderChunkExtender getRenderChunk() {
        return this.handler.getRenderChunk(this.getLevel(), this.pos);
    }

    public void prepareModelOffset(BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
        this.handler.prepareModelOffset(this.getLevel(), modelOffset, pos);
    }

    public LittleRenderPipelineType getPipeline() {
        return this.handler.getPipeline();
    }

    public int sectionIndex() {
        return this.handler.sectionIndex(this.getLevel(), this.pos);
    }

    public long queuedSection() {
        return this.handler.prepareQueue(this.pos);
    }
}

