/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.build;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.littletiles.client.level.little.FakeClientLevel;
import team.creative.littletiles.client.mod.sodium.SodiumManager;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.ViewAreaExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.mixin.client.render.LevelRendererAccessor;

public abstract class RenderingLevelHandler {
    public static final RenderingLevelHandler VANILLA = new RenderingLevelHandler(){

        @Override
        public LittleRenderPipelineType getPipeline() {
            return LittleRenderPipelineType.FORGE;
        }

        @Override
        public RenderChunkExtender getRenderChunk(Level level, long pos) {
            return (RenderChunkExtender)((ViewAreaExtender)((LevelRendererAccessor)Minecraft.getInstance().levelRenderer).getViewArea()).getSection(pos);
        }

        @Override
        public BlockPos standardOffset(Level level, SectionPos pos) {
            return pos.origin();
        }
    };
    public static final RenderingLevelHandler ENTITY = new RenderingLevelHandler(){

        @Override
        public LittleRenderPipelineType getPipeline() {
            return LittleRenderPipelineType.FORGE;
        }

        @Override
        public RenderChunkExtender getRenderChunk(Level level, long pos) {
            return ((LittleLevel)level).getRenderManager().getRenderChunk(pos);
        }

        @Override
        public BlockPos standardOffset(Level level, SectionPos pos) {
            return pos.origin();
        }
    };
    public static final RenderingLevelHandler ANIMATION = new RenderingLevelHandler(){

        @Override
        public LittleRenderPipelineType getPipeline() {
            return LittleRenderPipelineType.FORGE;
        }

        @Override
        public void prepareModelOffset(Level level, BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
            BlockPos chunkOffset = ((LittleAnimationEntity)((LittleLevel)level).getHolder()).getCenter().chunkOrigin;
            modelOffset.set(pos.getX() - chunkOffset.getX(), pos.getY() - chunkOffset.getY(), pos.getZ() - chunkOffset.getZ());
        }

        @Override
        public RenderChunkExtender getRenderChunk(Level level, long pos) {
            return ((LittleLevel)level).getRenderManager().getRenderChunk(pos);
        }

        @Override
        public long sectionPos(BETiles be) {
            return ((LittleAnimationEntity)((LittleLevel)be.getLevel()).getHolder()).getCenter().chunkOffset.asLong();
        }

        @Override
        public BlockPos standardOffset(Level level, SectionPos pos) {
            return ((LittleAnimationEntity)((LittleLevel)level).getHolder()).getCenter().chunkOrigin;
        }

        @Override
        public long prepareQueue(long pos) {
            return 0L;
        }
    };

    public static Vec3 offsetCorrection(Vec3i to, Vec3i from) {
        if (to == from || to.equals((Object)from)) {
            return null;
        }
        return new Vec3((double)(from.getX() - to.getX()), (double)(from.getY() - to.getY()), (double)(from.getZ() - to.getZ()));
    }

    public static Vec3 offsetCorrection(Vec3i to, int x, int y, int z) {
        if (to.getX() == x && to.getY() == y && to.getZ() == z) {
            return null;
        }
        return new Vec3((double)(x - to.getX()), (double)(y - to.getY()), (double)(z - to.getZ()));
    }

    public static Vec3 offsetCorrection(RenderingLevelHandler target, Level targetLevel, RenderingLevelHandler origin, Level originLevel, SectionPos pos) {
        BlockPos targetOffset = target.standardOffset(targetLevel, pos);
        BlockPos originOffset = origin.standardOffset(originLevel, pos);
        if (targetOffset != null && originOffset != null) {
            return RenderingLevelHandler.offsetCorrection((Vec3i)targetOffset, (Vec3i)originOffset);
        }
        return null;
    }

    public static RenderingLevelHandler of(Level level) {
        if (SodiumManager.installed()) {
            LittleLevel l;
            if (level instanceof LittleLevel && (l = (LittleLevel)level).getRenderManager().isSmall()) {
                ISubLevel s;
                if (l instanceof ISubLevel && (s = (ISubLevel)l).getParent() instanceof FakeClientLevel) {
                    return ANIMATION;
                }
                return SodiumManager.RENDERING_ANIMATION;
            }
            return SodiumManager.RENDERING_LEVEL;
        }
        if (level instanceof LittleLevel) {
            LittleLevel l = (LittleLevel)level;
            return l.getRenderManager().isSmall() ? ANIMATION : ENTITY;
        }
        return VANILLA;
    }

    public abstract LittleRenderPipelineType getPipeline();

    public void prepareModelOffset(Level level, BlockPos.MutableBlockPos modelOffset, BlockPos pos) {
        modelOffset.set(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
    }

    public long sectionPos(BETiles be) {
        return SectionPos.asLong((BlockPos)be.getBlockPos());
    }

    public long prepareQueue(long pos) {
        return pos;
    }

    public abstract RenderChunkExtender getRenderChunk(Level var1, long var2);

    public int sectionIndex(Level level, long pos) {
        return -1;
    }

    public abstract BlockPos standardOffset(Level var1, SectionPos var2);
}

