/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.model.CreativeItemModel;

@OnlyIn(value=Dist.CLIENT)
public class LittleModelItemBackground
extends CreativeItemModel {
    private final Function<ItemStack, ItemStack> top;

    public LittleModelItemBackground(ModelResourceLocation location, Function<ItemStack, ItemStack> top) {
        super(location);
        this.top = top;
    }

    protected ItemStack getFakeStack(ItemStack current) {
        return this.top.apply(current);
    }

    public void applyCustomOpenGLHackery(PoseStack pose, ItemStack stack, ItemDisplayContext cameraTransformType) {
        if (cameraTransformType == ItemDisplayContext.GUI) {
            ItemStack toFake = this.getFakeStack(stack);
            if (toFake.isEmpty()) {
                return;
            }
            pose.pushPose();
            Minecraft mc = Minecraft.getInstance();
            BakedModel model = mc.getItemRenderer().getModel(toFake, null, null, 0);
            this.prepareRenderer(cameraTransformType, pose);
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
            mc.getItemRenderer().render(toFake, cameraTransformType, false, pose, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            multibuffersource$buffersource.endBatch();
            pose.popPose();
        }
    }

    public void prepareRenderer(ItemDisplayContext context, PoseStack pose) {
        if (context == ItemDisplayContext.GUI) {
            pose.translate(0.0f, 0.0f, 1.0f);
        }
    }
}

