/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.level;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.AdditionalBuffers;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.build.RenderingLevelHandler;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;

public class RenderAdditional {
    public final Level targetLevel;
    public final RenderingLevelHandler target;
    private final Long2ObjectMap<SectionAdditional> sections = new Long2ObjectOpenHashMap();
    private int waitTill;

    public RenderAdditional(Level level) {
        this.targetLevel = level;
        this.target = RenderingLevelHandler.of(level);
    }

    private SectionAdditional getOrCreateSection(RenderingLevelHandler origin, Level originLevel, BlockPos pos) {
        long section = SectionPos.asLong((BlockPos)pos);
        SectionAdditional s = (SectionAdditional)this.sections.get(section);
        if (s == null) {
            origin.getRenderChunk(originLevel, section).backToRAM();
            s = new SectionAdditional(this.target.getRenderChunk(this.targetLevel, section), SectionPos.of((BlockPos)pos));
            this.sections.put(section, (Object)s);
        }
        return s;
    }

    public boolean queue(UUID uuid, Level originLevel, Iterable<BETiles> blocks) {
        RenderingLevelHandler origin = RenderingLevelHandler.of(originLevel);
        for (BETiles be : blocks) {
            this.getOrCreateSection(origin, originLevel, be.getBlockPos()).queueNew(uuid, origin, originLevel, be);
        }
        this.waitTill = LittleTilesClient.ANIMATION_HANDLER.longTickIndex + 2;
        ObjectIterator iterator = this.sections.long2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            if (!((SectionAdditional)((Long2ObjectMap.Entry)iterator.next()).getValue()).finishInitial()) continue;
            iterator.remove();
        }
        return this.sections.isEmpty();
    }

    public boolean isEmpty() {
        return this.sections.isEmpty();
    }

    public boolean notifyReceiveClientUpdate(BETiles be) {
        long pos = SectionPos.asLong((BlockPos)be.getBlockPos());
        SectionAdditional s = (SectionAdditional)this.sections.get(pos);
        if (s != null && s.notifyReceiveClientUpdate(be)) {
            this.sections.remove(pos);
        }
        return this.sections.isEmpty();
    }

    public boolean longTick(int index) {
        return index >= this.waitTill;
    }

    public class SectionAdditional {
        public final RenderChunkExtender section;
        public final SectionPos pos;
        private final HashMap<BlockPos, BlockAdditional> entries = new HashMap();

        public SectionAdditional(RenderChunkExtender section, SectionPos pos) {
            this.section = section;
            this.pos = pos;
            this.section.backToRAM();
            this.section.setAdditional(this);
        }

        private BlockAdditional getOrCreateBlock(BlockPos pos) {
            BlockAdditional data = this.entries.get(pos);
            if (data == null) {
                data = new BlockAdditional();
                this.entries.put(pos, data);
            }
            return data;
        }

        public void queueNew(UUID uuid, RenderingLevelHandler origin, Level originLevel, BETiles be) {
            this.getOrCreateBlock(be.getBlockPos()).queueNew(uuid, origin, originLevel, be, this.pos);
        }

        public void appendRenderData(boolean markUpdateOtherwise) {
            ArrayList<LayeredBufferCache> buffers = new ArrayList<LayeredBufferCache>();
            for (BlockAdditional d : this.entries.values()) {
                for (LayeredBufferCache b : d.additionals()) {
                    buffers.add(b);
                }
            }
            if (!this.section.appendRenderData(buffers) && markUpdateOtherwise) {
                this.markReadyForUpdate();
            }
        }

        public void onSectionUploads() {
            if (this.deleteAndRemoveIfEmpty()) {
                RenderAdditional.this.sections.remove(this.pos.asLong());
            } else {
                this.appendRenderData(false);
            }
        }

        public void markReadyForUpdate() {
            this.section.markReadyForUpdate(false);
        }

        private boolean deleteAndRemoveIfEmpty() {
            Iterator<Map.Entry<BlockPos, BlockAdditional>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().isDone()) continue;
                iterator.remove();
            }
            return this.removeIfEmpty();
        }

        public boolean finishInitial() {
            if (LittleTiles.CONFIG.rendering.uploadToVBODirectly) {
                this.appendRenderData(true);
            } else {
                this.markReadyForUpdate();
            }
            return false;
        }

        public boolean notifyReceiveClientUpdate(BETiles be) {
            BlockAdditional data = this.entries.get(be.getBlockPos());
            if (data != null) {
                data.receiveUpdate(be);
            }
            return false;
        }

        public boolean removeIfEmpty() {
            if (this.entries.isEmpty()) {
                this.section.setAdditional(null);
                return true;
            }
            return false;
        }
    }

    private class BlockAdditional
    extends AdditionalBuffers {
        private boolean done;

        private BlockAdditional() {
        }

        public void queueNew(UUID uuid, RenderingLevelHandler origin, Level originLevel, BETiles be, SectionPos pos) {
            IBlockBufferCache cache = be.render.buffers();
            Vec3 vec = RenderingLevelHandler.offsetCorrection(RenderAdditional.this.target, RenderAdditional.this.targetLevel, origin, originLevel, pos);
            int sectionIndex = RenderAdditional.this.target.sectionIndex(RenderAdditional.this.targetLevel, pos.asLong());
            LayeredBufferCache layers = new LayeredBufferCache();
            for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
                BufferCache holder = cache.getIncludingAdditional(layer);
                if (holder == null || !holder.isAvailable()) continue;
                if (vec != null) {
                    holder.applyOffset(vec, sectionIndex);
                }
                layers.put(layer, holder);
            }
            this.additional(uuid, layers);
            BETiles target = BlockTile.loadBE((BlockGetter)RenderAdditional.this.targetLevel, be.getBlockPos());
            if (target != null) {
                target.render.additionalBuffers(x -> x.additional(this, () -> {
                    this.done = true;
                }));
            }
        }

        public boolean isDone() {
            return this.done;
        }

        public void receiveUpdate(BETiles be) {
            be.render.additionalBuffers(x -> x.additional(this, () -> {
                this.done = true;
            }));
        }
    }
}

