/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.mc.LevelUtils;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionDestroyBoxes;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.action.LittleActionInteract;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class LittleActionDestroy
extends LittleActionInteract<Boolean> {
    public transient LittleGroupAbsolute destroyedTiles;
    public transient StructurePreview structurePreview;

    public LittleActionDestroy(Level level, BlockPos blockPos, Player player) {
        super(level, blockPos, player);
    }

    public LittleActionDestroy() {
    }

    @Override
    public boolean canBeReverted() {
        return this.destroyedTiles != null || this.structurePreview != null;
    }

    @Override
    public LittleAction revert(Player player) {
        if (this.structurePreview != null) {
            return this.structurePreview.getPlaceAction();
        }
        this.destroyedTiles.convertToSmallest();
        return new LittleActionPlace(LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.load(this.uuid, PlacementMode.FILL, this.destroyedTiles));
    }

    @Override
    protected boolean requiresBreakEvent() {
        return true;
    }

    @Override
    protected Boolean action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult hit, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (context.parent.isStructure()) {
            try {
                LittleStructure structure = context.parent.getStructure();
                structure.checkConnections();
                this.structurePreview = new StructurePreview(structure);
                if (LittleActionDestroy.needIngredients(player) && !player.level().isClientSide) {
                    LevelUtils.dropItem((Level)level, (ItemStack)structure.getStructureDrop(), (BlockPos)pos);
                }
                structure.tileDestroyed();
            }
            catch (CorruptedConnectionException | NotYetConnectedException e) {
                if (player.getMainHandItem().getItem() instanceof ItemLittleWrench) {
                    ((StructureParentCollection)context.parent).remove();
                    be.updateTiles();
                }
                throw new LittleActionException.StructureNotLoadedException();
            }
        } else {
            LittleInventory inventory = new LittleInventory(player);
            this.destroyedTiles = new LittleGroupAbsolute(pos);
            if (BlockTile.selectEntireBlock(player, secondMode)) {
                for (LittleTile toDestroy : context.parent) {
                    this.destroyedTiles.add(context.parent, toDestroy);
                }
                LittleActionDestroy.checkAndGive(player, inventory, LittleActionDestroy.getIngredients((HolderLookup.Provider)player.registryAccess(), this.destroyedTiles));
                be.updateTiles(x -> x.noneStructureTiles().clear());
            } else {
                this.destroyedTiles.add(context.parent, (LittleElement)context.tile, context.box);
                LittleActionDestroy.checkAndGive(player, inventory, LittleActionDestroy.getIngredients((HolderLookup.Provider)player.registryAccess(), this.destroyedTiles));
                be.updateTiles(x -> x.get(context.parent).remove(context.tile, context.box));
            }
        }
        level.playSound((Player)null, pos, context.tile.getSound().getBreakSound(), SoundSource.BLOCKS, (context.tile.getSound().getVolume() + 1.0f) / 2.0f, context.tile.getSound().getPitch() * 0.8f);
        return true;
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    public LittleAction mirror(Axis axis, LittleBoxAbsolute box) {
        LittleBoxesSimple boxes;
        if (this.structurePreview != null) {
            boxes = new LittleBoxesSimple(this.structurePreview.previews.pos, this.structurePreview.previews.getGrid());
            for (LittleBox destroyedBox : this.structurePreview.previews.group.allBoxes()) {
                ((LittleBoxes)boxes).add(destroyedBox);
            }
        } else if (this.destroyedTiles != null) {
            this.destroyedTiles.convertToSmallest();
            boxes = new LittleBoxesSimple(this.destroyedTiles.pos, this.destroyedTiles.getGrid());
            for (LittleBox destroyedBox : this.destroyedTiles.group.allBoxes()) {
                ((LittleBoxes)boxes).add(destroyedBox);
            }
        } else {
            return null;
        }
        ((LittleBoxes)boxes).mirror(axis, box);
        return new LittleActionDestroyBoxes(this.uuid, (LittleBoxes)boxes);
    }

    @Override
    public Boolean failed() {
        return false;
    }

    @Override
    protected Boolean ignored() {
        return false;
    }

    @Override
    public boolean wasSuccessful(Boolean result) {
        return result;
    }

    public static class StructurePreview {
        public LittleGroupAbsolute previews;
        public boolean requiresItemStack;
        public LittleStructure structure;

        public StructurePreview(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
            structure = structure.findTopStructure();
            structure.checkConnections();
            this.previews = structure.getAbsolutePreviews(structure.getStructurePos());
            this.requiresItemStack = this.previews.getStructureType().canOnlyBePlacedByItemStack();
            this.structure = structure;
        }

        public LittleAction getPlaceAction() {
            return new LittleActionPlace(this.requiresItemStack ? LittleActionPlace.PlaceAction.PREMADE : LittleActionPlace.PlaceAction.ABSOLUTE, PlacementPreview.absolute(this.structure.getStructureLevel(), PlacementMode.ALL, this.previews));
        }

        public int hashCode() {
            return this.previews.getStructureTag().hashCode();
        }

        public boolean equals(Object paramObject) {
            if (paramObject instanceof StructurePreview) {
                StructurePreview s = (StructurePreview)paramObject;
                return this.structure == s.structure;
            }
            if (paramObject instanceof LittleStructure) {
                return this.structure == paramObject;
            }
            return false;
        }
    }
}

