/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.event.EventHooks;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.block.LittlePhysicBlock;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleActionActivated;
import team.creative.littletiles.common.action.LittleActionDestroy;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.entity.BETilesRendered;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.item.ItemLittlePaintBrush;
import team.creative.littletiles.common.item.ItemLittleSaw;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.server.LittleTilesServer;

public class BlockTile
extends BaseEntityBlock
implements LittlePhysicBlock,
SimpleWaterloggedBlock {
    public static final SoundType SILENT = new DeferredSoundType(-1.0f, 1.0f, () -> SoundEvents.STONE_BREAK, () -> SoundEvents.STONE_STEP, () -> SoundEvents.STONE_PLACE, () -> SoundEvents.STONE_HIT, () -> SoundEvents.STONE_FALL);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public final boolean ticking;
    public final boolean rendered;

    public static BETiles loadBE(BlockGetter level, BlockPos pos) {
        if (level == null) {
            return null;
        }
        BlockEntity be = null;
        try {
            be = level.getBlockEntity(pos);
        }
        catch (Exception e) {
            return null;
        }
        if (be instanceof BETiles && ((BETiles)be).hasLoaded()) {
            return (BETiles)be;
        }
        return null;
    }

    public static boolean selectEntireBlock(Player player, boolean secondMode) {
        return secondMode && !(player.getMainHandItem().getItem() instanceof ItemLittleSaw) && !(player.getMainHandItem().getItem() instanceof ItemLittlePaintBrush);
    }

    public static BlockState getStateByAttribute(Level level, BlockPos pos, int attribute) {
        BlockState state = BlockTile.getState(LittleStructureAttribute.ticking(attribute), LittleStructureAttribute.tickRendering(attribute));
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        return state;
    }

    public static BlockState getState(boolean ticking, boolean rendered) {
        return rendered ? (ticking ? ((Block)LittleTilesRegistry.BLOCK_TILES_TICKING_RENDERED.value()).defaultBlockState() : ((Block)LittleTilesRegistry.BLOCK_TILES_RENDERED.value()).defaultBlockState()) : (ticking ? ((Block)LittleTilesRegistry.BLOCK_TILES_TICKING.value()).defaultBlockState() : ((Block)LittleTilesRegistry.BLOCK_TILES.value()).defaultBlockState());
    }

    public static BlockState getState(BlockState previous, boolean ticking, boolean rendered) {
        return (BlockState)BlockTile.getState(ticking, rendered).setValue((Property)WATERLOGGED, (Comparable)((Boolean)previous.getValue((Property)WATERLOGGED)));
    }

    public static BlockState getState(BETiles te) {
        return BlockTile.getState(te.isTicking(), te.isRendered());
    }

    public static boolean isTicking(BlockState state) {
        return state.getBlock() == LittleTilesRegistry.BLOCK_TILES_TICKING.value() || state.getBlock() == LittleTilesRegistry.BLOCK_TILES_TICKING_RENDERED.value();
    }

    public static BlockState getState(List<StructureParentCollection> structures) {
        boolean ticking = false;
        boolean rendered = false;
        for (StructureParentCollection structure : structures) {
            if (LittleStructureAttribute.ticking(structure.getAttribute())) {
                ticking = true;
            }
            if (LittleStructureAttribute.tickRendering(structure.getAttribute())) {
                rendered = true;
            }
            if (!ticking || !rendered) continue;
            break;
        }
        return BlockTile.getState(ticking, rendered);
    }

    public BlockTile(boolean ticking, boolean rendered) {
        super(BlockBehaviour.Properties.of().destroyTime(1.0f).explosionResistance(3.0f).sound(SILENT).dynamicShape().noOcclusion().isValidSpawn((a, b, c, d) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.ticking = ticking;
        this.rendered = rendered;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public boolean canBeReplaced(BlockState p_60535_, Fluid p_60536_) {
        return p_60535_.canBeReplaced() || !p_60535_.isSolid();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState oldState, LevelAccessor level, BlockPos pos, BlockPos neighbor) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> definition) {
        definition.add(new Property[]{WATERLOGGED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BETiles be = BlockTile.loadBE(level, pos);
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                if (list.isStructure() && LittleStructureAttribute.extraCollision(list.getAttribute())) {
                    try {
                        list.getStructure().collectExtraBoxes(state, level, pos, context, boxes);
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
                for (LittleTile tile : list) {
                    if (tile.getBlock().noCollision()) continue;
                    tile.collectBoxes(list, boxes);
                }
            }
        }
        return BoxesVoxelShape.create(boxes);
    }

    @Deprecated
    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.isCollisionFullBlock() ? 0.2f : 1.0f;
        }
        return 1.0f;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.getYAxis().doesBlockLight();
        }
        return true;
    }

    public boolean skipRendering(BlockState state, BlockState state2, Direction direction) {
        return false;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            return be.sideCache.isCollisionFullBlock();
        }
        return false;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getCollisionShape(state, level, pos, context);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (((IParentCollection)pair.key).isStructure() && LittleStructureAttribute.lightEmitter(((IParentCollection)pair.key).getAttribute()) || ((LittleTile)pair.value).getBlock().isTranslucent()) continue;
                ((LittleTile)pair.value).collectBoxes((IParentCollection)pair.key, boxes);
            }
        }
        return BoxesVoxelShape.create(boxes);
    }

    @Deprecated
    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCollisionShape(state, level, pos, CollisionContext.empty());
    }

    @OnlyIn(value=Dist.CLIENT)
    public VoxelShape getSelectionShape(BlockGetter level, BlockPos pos) {
        LittleTileContext tileContext = LittleTileContext.selectFocused(level, pos, (Player)Minecraft.getInstance().player);
        if (tileContext.isComplete()) {
            if (BlockTile.selectEntireBlock((Player)Minecraft.getInstance().player, LittleActionHandlerClient.isUsingSecondMode())) {
                return tileContext.parent.getBE().getBlockShape();
            }
            if (LittleTiles.CONFIG.rendering.highlightStructureBox && tileContext.parent.isStructure()) {
                try {
                    return tileContext.parent.getStructure().getSurroundingBox().getShape(pos);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return tileContext.box.getShape(tileContext.parent.getGrid());
        }
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BETiles be = BlockTile.loadBE(level, pos);
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> tile : be.allTiles()) {
                ((LittleTile)tile.value).collectBoxes((IParentCollection)tile.key, boxes);
            }
        }
        return BoxesVoxelShape.create(boxes);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return super.isPathfindable(state, type);
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.BLOCKED;
    }

    public void setBedOccupied(BlockState state, Level world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
    }

    public boolean isBed(BlockState state, BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return this.getBed(level, pos, (Entity)sleeper) != null;
    }

    public LittleStructure getBed(BlockGetter level, BlockPos pos, @Nullable Entity entity) {
        if (entity != null && !(entity instanceof Player)) {
            return null;
        }
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            for (LittleStructure structure : be.loadedStructures()) {
                if (entity != null && structure != ((ILittleBedPlayerExtension)entity).getBed()) continue;
                return structure;
            }
        }
        return null;
    }

    public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return Direction.SOUTH;
    }

    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader level, BlockPos pos, float orientation) {
        LittleStructure bed = this.getBed((BlockGetter)level, pos, null);
        if (bed != null && level instanceof Level && level.dimensionType().bedWorks()) {
            return BedBlock.findStandUpPosition(type, (CollisionGetter)level, (BlockPos)pos, (Direction)bed.getBedDirection(), (float)orientation).map(x -> ServerPlayer.RespawnPosAngle.of((Vec3)x, (BlockPos)pos));
        }
        return Optional.empty();
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null && entity != null && entity.getBoundingBox() != null) {
            AABB bb = entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())).inflate(0.001);
            for (IStructureParentCollection structure : be.structures()) {
                if (!LittleStructureAttribute.ladder(structure.getAttribute())) continue;
                for (LittleTile tile : structure) {
                    if (!tile.intersectsWith(bb, structure)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!player.level().isClientSide) {
            return super.getDestroyProgress(state, player, level, pos);
        }
        LittleTileContext context = LittleTileContext.selectFocused(level, pos, player);
        if (context.isComplete()) {
            state = context.tile.getState();
            float f = state.getDestroySpeed(level, pos);
            if (f == -1.0f) {
                return 0.0f;
            }
            int i = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos) ? 30 : 100;
            return player.getDigSpeed(state, pos) / f / (float)i;
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        level.levelEvent(player, 2001, pos, BlockTile.getId((BlockState)state));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.spawnDestroyParticles(level, player, pos, state);
        if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        return state;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, BlockState plantState) {
        BETiles be = BlockTile.loadBE(level, pos);
        boolean isDefault = false;
        if (be != null && be.sideCache.get(Facing.get((Direction)facing)).doesBlockCollision()) {
            LittleBox box = new LittleBox(0, be.getGrid().count - 1, 0, be.getGrid().count, be.getGrid().count, be.getGrid().count);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(box)) continue;
                BlockState toCheck = ((LittleTile)pair.value).getState();
                if (toCheck.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    toCheck = (BlockState)toCheck.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                switch (toCheck.canSustainPlant(level, pos, facing, plantState)) {
                    case TRUE: {
                        return TriState.TRUE;
                    }
                    case DEFAULT: {
                        isDefault = true;
                    }
                }
            }
        }
        return isDefault ? TriState.DEFAULT : TriState.FALSE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BETiles be;
        if (LittleTiles.CONFIG.rendering.enableRandomDisplayTick && (be = BlockTile.loadBE((BlockGetter)level, pos)) != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                ((LittleTile)pair.value).randomDisplayTick((IParentCollection)pair.key, rand);
            }
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return this.useClient(state, level, pos, player, result);
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResult useClient(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        InteractionResult inter;
        LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, pos, player);
        if (context.isComplete() && !(player.getMainHandItem().getItem() instanceof ItemLittleWrench) && LittleTilesClient.INTERACTION.can() && (inter = LittleTilesClient.ACTION_HANDLER.execute(new LittleActionActivated(level, pos, player))) != InteractionResult.PASS && LittleTilesClient.INTERACTION.start(true)) {
            return inter;
        }
        return InteractionResult.PASS;
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        float slipperiness = 1.0f;
        boolean found = false;
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null && entity != null && entity.getBoundingBox() != null) {
            AABB bb = entity.getBoundingBox().move(0.0, -0.001, 0.0);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(bb, (IParentCollection)pair.key)) continue;
                slipperiness = Math.min(slipperiness, ((LittleTile)pair.value).getFriction((IParentCollection)pair.key, entity));
                found = true;
            }
        }
        if (found) {
            return slipperiness;
        }
        return super.getFriction(state, level, pos, entity);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            double biggest = 0.0;
            LittleElement tile = null;
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                double tempVolume = ((LittleTile)pair.value).getVolume();
                if (!(tempVolume > biggest)) continue;
                biggest = tempVolume;
                tile = (LittleTile)pair.value;
            }
            if (tile != null) {
                return tile.getState().getMapColor(level, pos);
            }
        }
        return super.getMapColor(state, level, pos, defaultColor);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager aux = level.getAuxLightManager(pos);
        if (aux != null) {
            return aux.getLightAt(pos);
        }
        return 0;
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (level.isClientSide) {
            return this.removedByPlayerClient(state, level, pos, player, willHarvest, fluid);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean removedByPlayerClient(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)level, pos, player, TickUtils.getFrameTime((LevelAccessor)level));
        if (result.isComplete()) {
            return LittleTilesClient.ACTION_HANDLER.execute(new LittleActionDestroy(level, pos, player));
        }
        return false;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        BETiles be = BlockTile.loadBE((BlockGetter)context.getLevel(), context.getClickedPos());
        if (be != null) {
            return be.isEmpty();
        }
        return true;
    }

    public BlockState getStateAtViewpoint(BlockState state, BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null) {
            int x = be.getGrid().toGrid(viewpoint.x);
            int y = be.getGrid().toGrid(viewpoint.y);
            int z = be.getGrid().toGrid(viewpoint.z);
            LittleBox box = new LittleBox(x, y, z, x + 1, y + 1, z + 1);
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (!((LittleTile)pair.value).intersectsWith(box)) continue;
                return ((LittleTile)pair.value).getBlock().getState();
            }
        }
        return state;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            return ItemStack.EMPTY;
        }
        LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)level, pos, player);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock(player, LittleActionHandlerClient.isUsingSecondMode())) {
                ItemStack drop = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.value());
                LittleGroup group = new LittleGroup();
                for (LittleTile tile : result.parent) {
                    group.add(result.parent.getGrid(), (LittleElement)tile, tile.copy());
                }
                ILittleTool.setData(drop, LittleGroup.save(group));
                return drop;
            }
            if (result.parent.isStructure()) {
                try {
                    return result.parent.getStructure().getStructureDrop();
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return ItemMultiTiles.of(result.tile, result.parent.getGrid(), result.box.copy());
        }
        return ItemStack.EMPTY;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int heighest = 0;
            LittleElement heighestTile = null;
            for (IParentCollection list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            if (heighestTile != null) {
                level.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, heighestTile.getState()).setPos(pos), entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int heighest = 0;
            LittleElement heighestTile = null;
            for (IParentCollection list : te.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            Random random = new Random();
            if (heighestTile != null) {
                Vec3 vec3 = entity.getDeltaMovement();
                level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, heighestTile.getState()).setPos(pos), entity.getX() + (random.nextDouble() - 0.5) * (double)entity.getDimensions(entity.getPose()).width(), entity.getY() + 0.1, entity.getZ() + (random.nextDouble() - 0.5) * (double)entity.getDimensions(entity.getPose()).width(), vec3.x * -4.0, 1.5, vec3.z * -4.0);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public SoundType getSoundTypeClient(BlockState state, LevelReader level, BlockPos pos) {
        LittleTileContext result = LittleTileContext.selectFocused((BlockGetter)level, pos, (Player)Minecraft.getInstance().player);
        if (result.isComplete()) {
            return result.tile.getSound();
        }
        return null;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BETiles be;
        if (entity == null) {
            return SILENT;
        }
        SoundType sound = null;
        if (entity instanceof Player && level.isClientSide()) {
            sound = this.getSoundTypeClient(state, level, pos);
        }
        if (sound == null && (be = BlockTile.loadBE((BlockGetter)level, pos)) != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (IParentCollection list : be.groups()) {
                if (list.isStructure() && LittleStructureAttribute.noCollision(list.getAttribute())) continue;
                for (LittleTile tile : list) {
                    for (LittleBox box : tile) {
                        if (box == null || box.maxY <= heighest) continue;
                        heighest = box.maxY;
                        heighestTile = tile;
                    }
                }
            }
            if (heighestTile != null) {
                return heighestTile.getSound();
            }
        }
        if (sound == null) {
            sound = SoundType.STONE;
        }
        return sound;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        float bonus = 0.0f;
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                bonus += ((LittleTile)pair.value).getEnchantPowerBonus((IParentCollection)pair.key);
            }
        }
        return bonus;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos origin, boolean p_60514_) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            te.onNeighbourChanged(origin.equals((Object)pos) ? null : Facing.direction((Vec3i)origin, (Vec3i)pos));
            if (!level.isClientSide) {
                LittleTilesServer.NEIGHBOR.add(level, pos);
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            te.onNeighbourChanged(Facing.direction((Vec3i)pos, (Vec3i)neighbor));
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null && te.shouldCheckForCollision()) {
            for (IStructureParentCollection iStructureParentCollection : te.structures()) {
                if (!LittleStructureAttribute.collisionListener(iStructureParentCollection.getAttribute())) continue;
                try {
                    iStructureParentCollection.getStructure().onEntityCollidedWithBlock(level, iStructureParentCollection, pos, entity);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {}
            }
            for (Pair pair : te.allTiles()) {
                if (!((LittleTile)pair.value).checkEntityCollision()) continue;
                ((LittleTile)pair.value).entityCollided((IParentCollection)pair.key, entity);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this.rendered) {
            return new BETilesRendered(pos, state);
        }
        return new BETiles(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (this.ticking) {
            return BETiles::tick;
        }
        return null;
    }

    public boolean dropFromExplosion(Explosion p_49826_) {
        return false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        BETiles be = BlockTile.loadBE(level, pos);
        float calculatedResistance = 0.0f;
        float structureResistance = 0.0f;
        if (be != null) {
            for (IParentCollection list : be.groups()) {
                try {
                    if (list.isStructure() && list.getStructure().getExplosionResistance() > 0.0f) {
                        structureResistance = Math.max(structureResistance, list.getStructure().getExplosionResistance());
                        continue;
                    }
                    for (LittleTile tile : list) {
                        calculatedResistance += tile.getExplosionResistance();
                    }
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                }
            }
        }
        if (calculatedResistance > structureResistance) {
            return calculatedResistance;
        }
        return structureResistance;
    }

    public boolean isFaceSturdy(BlockGetter level, BlockPos pos, Direction diretion, SupportType support) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be == null) {
            return false;
        }
        Facing facing = Facing.get((Direction)diretion);
        if (be.sideCache.get(facing).doesBlockCollision()) {
            return true;
        }
        if (support == SupportType.FULL) {
            return false;
        }
        LittleBox box = new LittleBox(0, 0, 0, 0, 0, 0);
        if (facing.positive) {
            box.setMinMax(facing.axis, be.getGrid().count - 1, be.getGrid().count);
        } else {
            box.setMinMax(facing.axis, 0, 1);
        }
        double minPrecise = 0.0;
        double maxPrecise = 1.0;
        if (support == SupportType.CENTER) {
            minPrecise = 0.4375;
            maxPrecise = 0.5625;
        } else if (support == SupportType.RIGID) {
            minPrecise = 0.125;
            maxPrecise = 0.875;
        }
        int min = be.getGrid().toGrid(minPrecise);
        int max = be.getGrid().toGridUp(maxPrecise);
        box.setMinMax(facing.axis.one(), min, max, facing.axis.two(), min, max);
        return be.sideCache.calculateState(facing, box).doesBlockCollision();
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            be.updateTiles(x -> {
                ParentCollection parent = x.noneStructureTiles();
                for (LittleTile tile : parent) {
                    tile.onTileExplodes(parent, explosion);
                }
                parent.clear();
                for (StructureParentCollection list : x.structures()) {
                    try {
                        list.getStructure().tileDestroyed();
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    @Override
    public double bound(LittleLevel level, BlockPos pos, Facing facing) {
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te != null) {
            int value = facing.positive ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            for (Pair<IParentCollection, LittleTile> pair : te.allTiles()) {
                for (LittleBox box : (LittleTile)pair.value) {
                    value = facing.positive ? Math.max(value, box.get(facing)) : Math.min(value, box.get(facing));
                }
                if (!(facing.positive ? te.getGrid().count == value : value == 0)) continue;
                break;
            }
            return (double)pos.get(facing.axis.toVanilla()) + te.getGrid().toVanillaGrid(value);
        }
        return (facing.positive ? 0 : 1) + pos.get(facing.axis.toVanilla());
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        BETiles be = BlockTile.loadBE(level, pos);
        if (be != null && be.sideCache.get(Facing.get((Direction)dir)).doesBlockLight()) {
            return neighborState.isSolidRender(level, pos);
        }
        return false;
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @org.jetbrains.annotations.Nullable BlockState queryState, @org.jetbrains.annotations.Nullable BlockPos queryPos) {
        if (queryState == null || queryPos == null || Facing.direction((Vec3i)queryPos, (Vec3i)pos).toVanilla() == side) {
            return state;
        }
        BETiles be = BlockTile.loadBE((BlockGetter)level, pos);
        if (be != null) {
            for (Pair<IParentCollection, LittleTile> pair : be.allTiles()) {
                if (((LittleTile)pair.value).getState().getBlock() != queryState.getBlock()) continue;
                return queryState;
            }
        }
        return state;
    }
}

