/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.convertion;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.animation.PhysicalPart;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.animation.curve.ValueCurveInterpolation;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.animation.event.PlaySoundEvent;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class OldLittleTilesDataParser {
    private static boolean LOADED_BLOCK_MAP = false;
    public static final HashMap<String, String> BLOCK_MAP = new HashMap();

    public static boolean isOld(CompoundTag nbt) {
        return nbt.contains("tiles", 9);
    }

    public static LittleTile createTile(CompoundTag nbt) {
        if (!LOADED_BLOCK_MAP) {
            try {
                char splitter = '\u00a7';
                try (BufferedReader br = new BufferedReader(new InputStreamReader(LittleStructurePremade.class.getClassLoader().getResourceAsStream("1.12.2.txt"), Charsets.UTF_8));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        String[] data = line.split("" + splitter);
                        if (data.length != 2) continue;
                        BLOCK_MAP.put(data[0], data[1]);
                    }
                }
                LittleTiles.LOGGER.info("Loaded {} entries of block conversions", (Object)BLOCK_MAP.size());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LOADED_BLOCK_MAP = true;
        }
        Object name = nbt.getString("block");
        if (nbt.contains("meta") && nbt.getInt("meta") != 0) {
            name = (String)name + ":" + nbt.getInt("meta");
        }
        int color = -1;
        if (nbt.contains("color")) {
            color = nbt.getInt("color");
        }
        return new LittleTile(BLOCK_MAP.getOrDefault(name, (String)name), color, (List<LittleBox>)Collections.EMPTY_LIST);
    }

    public static LittleGroup load(CompoundTag nbt) throws LittleConvertException {
        LittleGrid grid;
        try {
            grid = LittleGrid.getOrThrow(nbt);
        }
        catch (RuntimeException e) {
            throw new LittleMissingGridException("Invalid grid size " + nbt.getInt("grid"));
        }
        return OldLittleTilesDataParser.loadGroup(nbt, grid);
    }

    public static void collect(ListTag tiles, Consumer<LittleTile> consumer) {
        for (int i = 0; i < tiles.size(); ++i) {
            CompoundTag tileNbt = tiles.getCompound(i);
            LittleTile tile = tileNbt.contains("tile") ? OldLittleTilesDataParser.createTile(tileNbt.getCompound("tile")) : OldLittleTilesDataParser.createTile(tileNbt);
            if (tileNbt.contains("boxes")) {
                ListTag boxes = tileNbt.getList("boxes", 11);
                for (int j = 0; j < boxes.size(); ++j) {
                    tile.add(LittleBox.create(boxes.getIntArray(j)));
                }
            } else if (tileNbt.contains("bBox")) {
                tile.add(LittleBox.create(tileNbt.getIntArray("bBox")));
            } else if (tileNbt.contains("box")) {
                tile.add(LittleBox.create(tileNbt.getIntArray("box")));
            }
            consumer.accept(tile);
        }
    }

    public static LittleGroup loadGroup(CompoundTag nbt, LittleGrid grid) throws LittleConvertException {
        ArrayList<LittleGroup> children = Collections.EMPTY_LIST;
        if (nbt.contains("children")) {
            ListTag list = nbt.getList("children", 10);
            children = new ArrayList<LittleGroup>();
            for (int i = 0; i < list.size(); ++i) {
                children.add(OldLittleTilesDataParser.loadGroup(list.getCompound(i), grid));
            }
        }
        LittleGroup group = new LittleGroup(OldLittleTilesDataParser.convertStructureData(nbt.contains("structure") ? nbt.getCompound("structure") : null), children);
        OldLittleTilesDataParser.collect(nbt.getList("tiles", 10), x -> group.addTileFast(grid, (LittleTile)x));
        return group;
    }

    private static void convertDoorBaseData(CompoundTag oldData, CompoundTag newData) {
        OldLittleTilesDataParser.convertStructureDataBase(oldData, newData);
        Tag state = oldData.get("state");
        if (state != null) {
            newData.put("state", state);
        }
        newData.putBoolean("actP", oldData.getBoolean("activateParent"));
        newData.putBoolean("hand", !oldData.getBoolean("disableRightClick"));
        newData.putBoolean("stay", oldData.getBoolean("stayAnimated"));
        newData.putBoolean("sound", oldData.contains("sounds") ? oldData.getBoolean("sounds") : true);
        newData.putBoolean("noClip", oldData.getBoolean("noClip"));
        newData.putInt("du", oldData.getInt("duration"));
        newData.putInt("in", oldData.getInt("interpolation"));
        if (oldData.contains("axisCenter")) {
            newData.putIntArray("center", oldData.getIntArray("axisCenter"));
        }
        newData.putInt("aS", -1);
    }

    private static List<AnimationTimeline.AnimationEventEntry> collectEvents(CompoundTag nbt, boolean opening) {
        ListTag list = nbt.getList("events", 10);
        ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        for (int i = 0; i < list.size(); ++i) {
            ChildDoorEvent event;
            CompoundTag eventTag = list.getCompound(i);
            switch (eventTag.getString("id")) {
                case "sound-event": {
                    AnimationEvent animationEvent;
                    if (eventTag.getBoolean("opening") == opening) {
                        animationEvent = new PlaySoundEvent(PlaySoundEvent.get(ResourceLocation.parse((String)eventTag.getString("sound"))), eventTag.getFloat("volume"), eventTag.getFloat("pitch"));
                        break;
                    }
                    animationEvent = null;
                    break;
                }
                case "child": {
                    AnimationEvent animationEvent = new ChildDoorEvent(eventTag.getInt("childId"));
                    break;
                }
                default: {
                    AnimationEvent animationEvent = event = null;
                }
            }
            if (event == null) continue;
            events.add(new AnimationTimeline.AnimationEventEntry(eventTag.getInt("tick"), event));
        }
        return events;
    }

    private static void saveDoor(CompoundTag nbt, PhysicalState start, PhysicalState end, AnimationTimeline opening, AnimationTimeline closing) {
        ArrayList<AnimationState> states = new ArrayList<AnimationState>();
        states.add(new AnimationState("closed", start, !nbt.getBoolean("stay")));
        states.add(new AnimationState("opened", end, !nbt.getBoolean("stay")));
        ListTag stateList = new ListTag();
        for (int i = 0; i < states.size(); ++i) {
            stateList.add((Object)((AnimationState)states.get(i)).save());
        }
        nbt.put("s", (Tag)stateList);
        ArrayList<AnimationTransition> transitions = new ArrayList<AnimationTransition>();
        if (opening != null) {
            transitions.add(new AnimationTransition("opening", 0, 1, opening));
        }
        if (closing != null) {
            transitions.add(new AnimationTransition("closing", 1, 0, closing));
        }
        ListTag transitionList = new ListTag();
        for (int i = 0; i < transitions.size(); ++i) {
            transitionList.add((Object)((AnimationTransition)transitions.get(i)).save());
        }
        nbt.put("t", (Tag)transitionList);
    }

    private static ValueCurveInterpolation<Vec1d> loadValueTimelineAndPrepare(PhysicalPart part, int[] data, PhysicalState start, PhysicalState end, LittleGrid grid, int duration) {
        if (data.length == 0) {
            return null;
        }
        ValueCurveInterpolation.CosineCurve<Vec1d> curve = switch (data[0]) {
            case 1 -> new ValueCurveInterpolation.CosineCurve();
            case 2 -> new ValueCurveInterpolation.CubicCurve();
            case 3 -> new ValueCurveInterpolation.HermiteCurve();
            default -> new ValueCurveInterpolation.LinearCurve();
        };
        for (int i = 0; i < data[1]; ++i) {
            double value = Double.longBitsToDouble((long)data[3 + i * 3] << 32 | (long)data[4 + i * 3] & 0xFFFFFFFFL);
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            curve.add(data[2 + i * 3], new Vec1d(value));
        }
        return OldLittleTilesDataParser.prepareValueCurve(part, curve, start, end, grid, duration);
    }

    private static ValueCurveInterpolation<Vec1d> prepareValueCurve(PhysicalPart part, ValueCurveInterpolation<Vec1d> curve, PhysicalState start, PhysicalState end, LittleGrid grid, int duration) {
        if (curve == null || curve.isEmpty()) {
            return null;
        }
        if (curve.size() == 1) {
            start.set(part, curve.getFirst().x);
            end.set(part, curve.getFirst().x);
            return null;
        }
        Pair<Integer, Vec1d> first = curve.getFirstPair();
        if (part.offset) {
            ((Vec1d)first.value).x = grid.toVanillaGrid(((Vec1d)first.value).x);
        }
        start.set(part, ((Vec1d)first.value).x);
        if ((Integer)first.key == 0) {
            curve.remove(0);
        }
        Pair<Integer, Vec1d> last = curve.getLastPair();
        if (part.offset) {
            ((Vec1d)last.value).x = grid.toVanillaGrid(((Vec1d)last.value).x);
        }
        end.set(part, ((Vec1d)last.value).x);
        if ((Integer)last.key == duration) {
            curve.remove(curve.size() - 1);
        }
        if (curve.isEmpty()) {
            return null;
        }
        return curve;
    }

    public static CompoundTag convertStructureDataBase(CompoundTag oldData, CompoundTag newData) {
        if (oldData.contains("signal")) {
            Tag signal = oldData.get("signal");
            oldData.remove("signal");
            newData.put("ex", signal);
        }
        if (oldData.contains("name")) {
            String name = oldData.getString("name");
            oldData.remove("name");
            newData.putString("n", name);
        }
        if (oldData.contains("blocks")) {
            int[] array = oldData.getIntArray("blocks");
            oldData.remove("blocks");
            newData.putIntArray("b", array);
        }
        if (oldData.contains("parent")) {
            CompoundTag parent = oldData.getCompound("parent");
            oldData.remove("parent");
            newData.put("k", (Tag)parent);
        }
        if (oldData.contains("children")) {
            ListTag children = oldData.getList("children", 10);
            oldData.remove("children");
            newData.put("c", (Tag)children);
        }
        return newData;
    }

    public static CompoundTag convertStructureData(CompoundTag nbt) throws LittleConvertException {
        if (nbt == null) {
            return null;
        }
        return switch (nbt.getString("id")) {
            case "workbench", "importer", "exporter", "blankomatic", "particle_emitter", "signal_display", "structure_builder", "fixed", "ladder", "bed", "chair", "storage", "noclip", "message", "item_holder" -> OldLittleTilesDataParser.convertStructureDataBase(nbt, nbt);
            case "single_cable1", "single_cable4", "single_cable16", "single_input1", "single_input4", "single_input16", "single_output1", "single_output4", "single_output16" -> OldLittleTilesDataParser.convertStructureDataBase(nbt, nbt);
            case "light" -> {
                OldLittleTilesDataParser.convertStructureDataBase(nbt, nbt);
                nbt.putBoolean("right", !nbt.getBoolean("disableRightClick"));
                nbt.remove("disableRightClick");
                yield nbt;
            }
            case "door" -> {
                List<AnimationTimeline.AnimationEventEntry> closingEvents;
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                CompoundTag rotation = new CompoundTag();
                Axis axis = Axis.values()[nbt.getInt("axis")];
                rotation.putInt("a", axis.ordinal());
                PhysicalState end = new PhysicalState();
                if (nbt.getInt("rot-type") == 1) {
                    double degree = nbt.getDouble("degree");
                    rotation.putDouble("d", degree);
                    end.rot(axis, degree);
                } else {
                    boolean clockwise = nbt.getBoolean("clockwise");
                    rotation.putBoolean("c", clockwise);
                    end.rot(axis, clockwise ? 90.0 : -90.0);
                }
                converted.put("rotation", (Tag)rotation);
                List<AnimationTimeline.AnimationEventEntry> openingEvents = OldLittleTilesDataParser.collectEvents(nbt, true);
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (openingEvents != null) {
                    opening = new AnimationTimeline(nbt.getInt("duration"), openingEvents);
                }
                if ((closingEvents = OldLittleTilesDataParser.collectEvents(nbt, false)) != null) {
                    closing = new AnimationTimeline(nbt.getInt("duration"), closingEvents);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), end, opening, closing);
                converted.putString("id", "axis");
                yield converted;
            }
            case "slidingDoor" -> {
                List<AnimationTimeline.AnimationEventEntry> closingEvents;
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                PhysicalState end = new PhysicalState();
                Facing direction = Facing.VALUES[nbt.getInt("direction")];
                converted.putInt("direction", direction.ordinal());
                int distance = nbt.getInt("distance");
                converted.putInt("dis", distance);
                LittleGrid grid = LittleGrid.get(nbt);
                converted.putInt("disG", grid.count);
                end.off(direction, grid.toVanillaGrid(distance));
                List<AnimationTimeline.AnimationEventEntry> openingEvents = OldLittleTilesDataParser.collectEvents(nbt, true);
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (openingEvents != null) {
                    opening = new AnimationTimeline(nbt.getInt("duration"), openingEvents);
                }
                if ((closingEvents = OldLittleTilesDataParser.collectEvents(nbt, false)) != null) {
                    closing = new AnimationTimeline(nbt.getInt("duration"), closingEvents);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), end, opening, closing);
                converted.putString("id", "sliding");
                yield converted;
            }
            case "doorActivator" -> {
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                int duration = 1;
                converted.putInt("du", duration);
                int[] toActivate = nbt.getIntArray("activate");
                converted.putIntArray("act", toActivate);
                ArrayList<AnimationTimeline.AnimationEventEntry> events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
                for (int i = 0; i < toActivate.length; ++i) {
                    events.add(new AnimationTimeline.AnimationEventEntry(0, new ChildDoorEvent(toActivate[i])));
                }
                AnimationTimeline opening = null;
                AnimationTimeline closing = null;
                if (events != null) {
                    opening = new AnimationTimeline(duration, events);
                    closing = new AnimationTimeline(duration, events);
                }
                OldLittleTilesDataParser.saveDoor(converted, new PhysicalState(), new PhysicalState(), opening, closing);
                converted.putString("id", "activator");
                yield converted;
            }
            case "advancedDoor" -> {
                CompoundTag converted = new CompoundTag();
                OldLittleTilesDataParser.convertDoorBaseData(nbt, converted);
                int duration = nbt.getInt("duration");
                CompoundTag animation = nbt.getCompound("animation");
                PhysicalState start = new PhysicalState();
                PhysicalState end = new PhysicalState();
                LittleGrid grid = LittleGrid.get(animation.getInt("offGrid"));
                HashMap<PhysicalPart, ValueCurveInterpolation<Vec1d>> curves = new HashMap<PhysicalPart, ValueCurveInterpolation<Vec1d>>();
                for (PhysicalPart part : PhysicalPart.values()) {
                    curves.put(part, OldLittleTilesDataParser.loadValueTimelineAndPrepare(part, animation.getIntArray(part.oldKey), start, end, grid, duration));
                }
                AnimationTimeline opening = new AnimationTimeline(duration, OldLittleTilesDataParser.collectEvents(nbt, true));
                AnimationTimeline closing = new AnimationTimeline(duration, OldLittleTilesDataParser.collectEvents(nbt, false));
                for (Map.Entry entry : curves.entrySet()) {
                    if (entry.getValue() == null) continue;
                    opening.set((PhysicalPart)((Object)entry.getKey()), (ValueCurve)entry.getValue());
                    closing.set((PhysicalPart)((Object)entry.getKey()), (ValueCurve)entry.getValue());
                }
                OldLittleTilesDataParser.saveDoor(converted, start, end, opening, closing);
                converted.putString("id", "door");
                yield converted;
            }
            default -> throw new LittleMissingStructureException("Cannot convert " + nbt.getString("id") + " yet");
        };
    }

    public static CompoundTag convert(CompoundTag nbt) throws LittleConvertException {
        return LittleGroup.save(OldLittleTilesDataParser.load(nbt));
    }

    public static class LittleMissingGridException
    extends LittleConvertException {
        public LittleMissingGridException(String name) {
            super(name);
        }

        @Override
        public Component translatable() {
            return Component.translatable((String)"gui.error.convert.structure", (Object[])new Object[]{this.getMessage()});
        }
    }

    public static class LittleMissingStructureException
    extends LittleConvertException {
        public LittleMissingStructureException(String name) {
            super(name);
        }
    }

    public static class LittleConvertException
    extends Exception {
        public LittleConvertException(String name) {
            super(name);
        }

        public Component translatable() {
            return Component.translatable((String)"gui.error.convert.structure", (Object[])new Object[]{this.getMessage()});
        }
    }
}

