/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import java.util.HashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;

public class LittleAnimationChunkCache
extends ChunkSource {
    private final LittleAnimationLevel level;
    private HashMap<Long, LevelChunk> chunks;
    private LevelLightEngine lightEngine;

    public LittleAnimationChunkCache(LittleAnimationLevel level) {
        this.level = level;
        this.chunks = new HashMap();
        this.lightEngine = new LevelLightEngine((LightChunkGetter)this, false, false);
    }

    public void addLoadedChunk(LevelChunk chunk) {
        this.chunks.put(chunk.getPos().toLong(), chunk);
    }

    public Iterable<LevelChunk> all() {
        return this.chunks.values();
    }

    @Nullable
    public LevelChunk getChunk(int x, int z, ChunkStatus status, boolean create) {
        LevelChunk chunk = this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (chunk == null && create) {
            chunk = new LevelChunk((Level)this.level, new ChunkPos(x, z));
            chunk.setLoaded(true);
            this.chunks.put(ChunkPos.asLong((int)x, (int)z), chunk);
        }
        return chunk;
    }

    public LittleAnimationLevel getLevel() {
        return this.level;
    }

    public void tick(BooleanSupplier running, boolean chunks) {
    }

    public String gatherStats() {
        return "" + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.chunks.size();
    }

    public void onLightUpdate(LightLayer layer, SectionPos pos) {
        this.getLevel().renderManager.setSectionDirty(pos.x(), pos.y(), pos.z());
    }

    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }
}

