/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.LittleEntityPhysic;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.level.little.LittleSubLevel;

public class LittleAnimationEntityPhysic
extends LittleEntityPhysic<LittleAnimationEntity> {
    private boolean blocksChanged = true;

    public LittleAnimationEntityPhysic(LittleAnimationEntity parent) {
        super(parent);
    }

    @Override
    public void setSubLevel(LittleSubLevel level) {
        level.registerBlockChangeListener((pos, state) -> {
            this.blocksChanged = true;
        });
    }

    protected boolean isWithinBoundsNoEdge(BlockPos pos) {
        return Math.floor(this.minX) < (double)pos.getX() && this.maxX > (double)pos.getX() && Math.floor(this.minY) < (double)pos.getY() && this.maxY > (double)pos.getY() && Math.floor(this.minZ) < (double)pos.getZ() && this.maxZ > (double)pos.getZ();
    }

    @Override
    public void tick() {
        if (this.blocksChanged) {
            this.minX = Double.MAX_VALUE;
            this.minY = Double.MAX_VALUE;
            this.minZ = Double.MAX_VALUE;
            this.maxX = -1.7976931348623157E308;
            this.maxY = -1.7976931348623157E308;
            this.maxZ = -1.7976931348623157E308;
            boolean found = false;
            for (BETiles block : ((LittleAnimationEntity)this.parent).getSubLevel()) {
                if (block.isEmpty() || this.isWithinBoundsNoEdge(block.getBlockPos())) continue;
                AABB bb = block.getBlockBBWithOffset();
                this.minX = Math.min(this.minX, bb.minX);
                this.minY = Math.min(this.minY, bb.minY);
                this.minZ = Math.min(this.minZ, bb.minZ);
                this.maxX = Math.max(this.maxX, bb.maxX);
                this.maxY = Math.max(this.maxY, bb.maxY);
                this.maxZ = Math.max(this.maxZ, bb.maxZ);
                found = true;
            }
            if (found) {
                this.setBB(new ABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ));
                this.blocksChanged = false;
            }
        }
    }

    @Override
    public void loadExtra(CompoundTag nbt) {
    }

    @Override
    protected void saveExtra(CompoundTag nbt) {
    }
}

