/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.joml.Vector3d;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.matrix.ChildVecOrigin;
import team.creative.creativecore.common.util.math.matrix.IVecOrigin;
import team.creative.creativecore.common.util.math.matrix.VecOrigin;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.NestedFunctionIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.BlockStatePredictionHandlerExtender;
import team.creative.littletiles.client.level.ClientLevelExtender;
import team.creative.littletiles.client.level.little.LittleAnimationLevelClientCallback;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationChunkCache;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevelEntities;
import team.creative.littletiles.common.level.little.LevelBlockChangeListener;
import team.creative.littletiles.common.level.little.LittleAnimationLevelCallback;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationBlocksPacket;
import team.creative.littletiles.server.level.little.LittleAnimationLevelServerCallback;

public class LittleAnimationLevel
extends Level
implements LittleSubLevel,
Iterable<BETiles>,
ClientLevelExtender {
    private Level parentLevel;
    public final LittleAnimationLevelCallback entityCallback;
    private final LittleAnimationLevelEntities entities;
    public Entity holder;
    public IVecOrigin origin;
    public LittleAnimationChunkCache chunks;
    private final List<LevelBlockChangeListener> blockChangeListeners = new ArrayList<LevelBlockChangeListener>();
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager renderManager;
    private HashSet<BlockPos> trackedChanges;
    @OnlyIn(value=Dist.CLIENT)
    private BlockStatePredictionHandler blockStatePredictionHandler;

    public LittleAnimationLevel(Level level) {
        super((WritableLevelData)level.getLevelData(), level.dimension(), level.registryAccess(), (Holder)level.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(LittleTilesRegistry.FAKE_DIMENSION), level.getProfilerSupplier(), level.isClientSide, level.isDebug(), 0L, 1000000);
        this.parentLevel = level;
        this.chunks = new LittleAnimationChunkCache(this);
        if (this.isClientSide) {
            this.blockStatePredictionHandler = new BlockStatePredictionHandler();
            this.entityCallback = new LittleAnimationLevelClientCallback(this);
        } else {
            this.trackedChanges = new HashSet();
            this.entityCallback = new LittleAnimationLevelServerCallback(this);
        }
        this.entities = new LittleAnimationLevelEntities(this.entityCallback);
    }

    @Override
    public LevelEntityGetter<Entity> getEntityGetter() {
        return this.entities;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return this.renderManager;
    }

    public MinecraftServer getServer() {
        return this.parentLevel.getServer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleBlockChangedAckExtender(int sequence) {
        ((BlockStatePredictionHandlerExtender)this.blockStatePredictionHandler).setLevel(this);
        this.blockStatePredictionHandler.endPredictionsUpTo(sequence, null);
        ((BlockStatePredictionHandlerExtender)this.blockStatePredictionHandler).setLevel(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setServerVerifiedBlockStateExtender(BlockPos pos, BlockState state, int p_233656_) {
        if (!this.blockStatePredictionHandler.updateKnownServerState(pos, state)) {
            super.setBlock(pos, state, p_233656_, 512);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void syncBlockStateExtender(BlockPos pos, BlockState state, Vec3 vec) {
        BlockState blockstate = this.getBlockState(pos);
        if (blockstate != state) {
            this.setBlock(pos, state, 19);
            LocalPlayer player = Minecraft.getInstance().player;
            if (player.isColliding(pos, state)) {
                player.absMoveTo(vec.x, vec.y, vec.z);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockStatePredictionHandler blockStatePredictionHandler() {
        return this.blockStatePredictionHandler;
    }

    @Override
    public TransientEntitySectionManager getEntityStorage() {
        return null;
    }

    @Override
    public boolean allowPlacement() {
        return false;
    }

    public Level getParent() {
        return this.parentLevel;
    }

    public Level getRealLevel() {
        Level level = this.parentLevel;
        if (level instanceof LittleSubLevel) {
            LittleSubLevel sub = (LittleSubLevel)level;
            return sub.getRealLevel();
        }
        return this.parentLevel;
    }

    @Override
    public void setParent(Level level) {
        this.parentLevel = level;
    }

    @Override
    public UUID key() {
        return this.getHolder().getUUID();
    }

    public IVecOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vec3d center) {
        this.origin = this.parentLevel instanceof IOrientatedLevel ? new ChildVecOrigin(((IOrientatedLevel)this.parentLevel).getOrigin(), center) : new VecOrigin(center);
    }

    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public LittleAnimationChunkCache getChunkSource() {
        return this.chunks;
    }

    public void gameEvent(Holder<GameEvent> event, Vec3 vec, GameEvent.Context context) {
        this.getRealLevel().gameEvent(event, vec, context);
    }

    public List<? extends Player> players() {
        return Collections.EMPTY_LIST;
    }

    public RegistryAccess registryAccess() {
        Level level = this.getRealLevel();
        if (level == null) {
            return RegistryAccess.EMPTY;
        }
        return level.registryAccess();
    }

    @Override
    public Entity getHolder() {
        return this.holder;
    }

    @Override
    public void setHolder(Entity entity) {
        this.holder = entity;
    }

    @Override
    public void unload(LevelChunk chunk) {
        chunk.clearAllBlockEntities();
        this.getChunkSource().getLightEngine().setLightEnabled(chunk.getPos(), false);
    }

    @Override
    public void unload() {
        this.entities.removeAll();
        if (this.isClientSide && this.renderManager != null) {
            this.renderManager.unload();
        }
    }

    @Override
    public Iterable<Entity> entities() {
        return this.entities.getAll();
    }

    public Iterable<LevelChunk> chunks() {
        return this.chunks.all();
    }

    public void initialTick() {
        this.tickBlockEntities();
    }

    @Override
    public void tick() {
        if (!this.isClientSide && !this.trackedChanges.isEmpty()) {
            LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleAnimationBlocksPacket((LittleAnimationEntity)this.holder, this.trackedChanges), this.holder);
            this.trackedChanges.clear();
        }
        this.tickBlockEntities();
        this.entityCallback.tick();
    }

    @Override
    public void registerBlockChangeListener(LevelBlockChangeListener listener) {
        this.blockChangeListeners.add(listener);
    }

    public void sendBlockUpdated(BlockPos pos, BlockState actualState, BlockState setState, int p_104688_) {
        if (this.isClientSide) {
            this.renderManager.blockChanged((BlockGetter)this, pos, actualState, setState, p_104688_);
        } else {
            this.trackedChanges.add(pos);
        }
    }

    public void setBlocksDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        if (this.isClientSide) {
            this.renderManager.setBlockDirty(pos, actualState, setState);
        }
        this.blockChangeListeners.forEach(x -> x.blockChanged(pos, setState));
    }

    public String gatherChunkSourceStats() {
        return "";
    }

    public Entity getEntity(int id) {
        return this.entities.get(id);
    }

    public MapItemSavedData getMapData(MapId key) {
        return this.getRealLevel().getMapData(key);
    }

    public void setMapData(MapId key, MapItemSavedData data) {
        this.getRealLevel().setMapData(key, data);
    }

    public MapId getFreeMapId() {
        return this.getRealLevel().getFreeMapId();
    }

    public void destroyBlockProgress(int id, BlockPos pos, int progress) {
        if (this.isClientSide) {
            this.renderManager.destroyBlockProgress(id, pos, progress);
        }
    }

    @Override
    public Iterator<BETiles> iterator() {
        return new NestedFunctionIterator(this.chunks(), x -> () -> new FilterIterator(x.getBlockEntities().values(), BETiles.class));
    }

    protected LevelEntityGetter<Entity> getEntities() {
        return this.entities;
    }

    public void playSound(@Nullable Player p_184133_1_, BlockPos pos, SoundEvent p_184133_3_, SoundSource p_184133_4_, float p_184133_5_, float p_184133_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        this.getRealLevel().playSound(p_184133_1_, this.transformToRealWorld(pos), p_184133_3_, p_184133_4_, p_184133_5_, p_184133_6_);
    }

    public void playSound(@Nullable Player p_184148_1_, double x, double y, double z, SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealLevel().playSound(p_184148_1_, vec.x, vec.y, vec.z, p_184148_8_, p_184148_9_, p_184148_10_, p_184148_11_);
    }

    public void playSound(@Nullable Player p_217384_1_, Entity entity, SoundEvent p_217384_3_, SoundSource p_217384_4_, float p_217384_5_, float p_217384_6_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(entity.getPosition(1.0f));
        this.getRealLevel().playSound(p_217384_1_, vec.x, vec.y, vec.z, p_217384_3_, p_217384_4_, p_217384_5_, p_217384_6_);
    }

    public void playLocalSound(double x, double y, double z, SoundEvent p_184134_7_, SoundSource p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().playLocalSound(vec.x, vec.y, vec.z, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_11_);
    }

    public void playSeededSound(Player p_262953_, double x, double y, double z, Holder<SoundEvent> p_263359_, SoundSource p_263020_, float p_263055_, float p_262914_, long p_262991_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = new Vector3d(x, y, z);
        this.getOrigin().transformPointToWorld(vec);
        this.getRealLevel().playSeededSound(p_262953_, vec.x, vec.y, vec.z, p_263359_, p_263020_, p_263055_, p_262914_, p_262991_);
    }

    public void playSeededSound(Player player, double x, double y, double z, SoundEvent event, SoundSource source, float p_220369_, float p_220370_, long p_220371_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(new Vec3(x, y, z));
        this.getRealLevel().playSeededSound(player, vec.x, vec.y, vec.z, event, source, p_220369_, p_220370_, p_220371_);
    }

    public void playSeededSound(Player player, Entity entity, Holder<SoundEvent> event, SoundSource source, float p_220376_, float p_220377_, long p_220378_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vec3 vec = this.getOrigin().transformPointToWorld(entity.getEyePosition());
        this.getRealLevel().playSeededSound(player, vec.x, vec.y, vec.z, event, source, p_220376_, p_220377_, p_220378_);
    }

    public void addParticle(ParticleOptions p_195594_1_, double x, double y, double z, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().addParticle(p_195594_1_, vec.x, vec.y, vec.z, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(ParticleOptions p_195590_1_, boolean p_195590_2_, double x, double y, double z, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().addParticle(p_195590_1_, p_195590_2_, vec.x, vec.y, vec.z, p_195590_9_, p_195590_11_, p_195590_13_);
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_195589_1_, double x, double y, double z, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().addAlwaysVisibleParticle(p_195589_1_, vec.x, vec.y, vec.z, p_195589_8_, p_195589_10_, p_195589_12_);
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_217404_1_, boolean p_217404_2_, double x, double y, double z, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        if (this.getOrigin() == null) {
            return;
        }
        Vector3d vec = this.getOrigin().transformPointToWorld(new Vector3d(x, y, z));
        this.getRealLevel().addAlwaysVisibleParticle(p_217404_1_, p_217404_2_, vec.x, vec.y, vec.z, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public Holder<Biome> getUncachedNoiseBiome(int p_225604_1_, int p_225604_2_, int p_225604_3_) {
        return this.getRealLevel().getUncachedNoiseBiome(p_225604_1_, p_225604_2_, p_225604_3_);
    }

    public float getShade(Direction direction, boolean p_230487_2_) {
        return this.getRealLevel().getShade(direction, p_230487_2_);
    }

    public Scoreboard getScoreboard() {
        return this.getRealLevel().getScoreboard();
    }

    public RecipeManager getRecipeManager() {
        return this.getRealLevel().getRecipeManager();
    }

    public void levelEvent(Player player, int p_217378_2_, BlockPos pos, int p_217378_4_) {
        this.getRealLevel().levelEvent(player, p_217378_2_, pos, p_217378_4_);
    }

    public void gameEvent(Entity p_151549_, Holder<GameEvent> p_151550_, BlockPos p_151551_) {
        this.getRealLevel().gameEvent(p_151549_, p_151550_, p_151551_);
    }

    public String toString() {
        return "SubAnimationLevel[" + this.holder.getStringUUID() + "]";
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.getParent().enabledFeatures();
    }

    @Override
    public boolean shouldUseLightingForRenderig() {
        return false;
    }

    public boolean isEmpty() {
        for (LevelChunk chunk : this.chunks()) {
            if (chunk.getBlockEntities().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addFreshEntityFromPacket(Entity entity) {
        if (((EntityJoinLevelEvent)NeoForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, (Level)this))).isCanceled()) {
            return;
        }
        this.removeEntityById(entity.getId(), Entity.RemovalReason.DISCARDED);
        this.entities.addNewEntityWithoutEvent(entity);
        entity.onAddedToLevel();
    }

    @Override
    public void removeEntityById(int id, Entity.RemovalReason reason) {
        Entity entity = (Entity)this.getEntities().get(id);
        if (entity != null) {
            entity.setRemoved(reason);
            if (LittleTilesClient.ANIMATION_HANDLER.checkInTransition(entity)) {
                return;
            }
            entity.onClientRemoval();
        }
    }

    public void clearTrackingChanges() {
        if (this.trackedChanges != null) {
            this.trackedChanges.clear();
        }
    }

    public boolean addFreshEntity(Entity entity) {
        if (this.isClientSide || entity.isRemoved()) {
            return false;
        }
        if (this.entities.addNewEntity(entity)) {
            entity.onAddedToLevel();
            return true;
        }
        return false;
    }

    public TickRateManager tickRateManager() {
        return this.parentLevel.tickRateManager();
    }

    public PotionBrewing potionBrewing() {
        return this.parentLevel.potionBrewing();
    }

    public void setDayTimeFraction(float dayTimeFraction) {
        this.parentLevel.setDayTimeFraction(dayTimeFraction);
    }

    public float getDayTimeFraction() {
        return this.parentLevel.getDayTimeFraction();
    }

    public float getDayTimePerTick() {
        return this.parentLevel.getDayTimePerTick();
    }

    public void setDayTimePerTick(float dayTimePerTick) {
        this.parentLevel.setDayTimePerTick(dayTimePerTick);
    }

    public int getMinBuildHeight() {
        return this.parentLevel.getMinBuildHeight();
    }

    public int getHeight() {
        return this.parentLevel.getHeight();
    }
}

