/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntityPhysic;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.type.LittleFixedStructure;

public class AnimationPreview {
    public final LittleAnimationEntity animation;
    public final LittleGroup previews;
    public final LittleBox entireBox;
    public final LittleGrid grid;
    public final AABB box;

    public AnimationPreview(LittleLevel fakeLevel, LittleStructure structure, LittleGroup previews, HolderLookup.Provider provider) throws LittleActionException {
        StructureAbsolute absolute;
        this.previews = previews;
        this.grid = previews.getGrid();
        BlockPos pos = new BlockPos(0, 0, 0);
        fakeLevel.setOrigin(new Vec3d());
        LittleAnimationLevel subLevel = new LittleAnimationLevel((Level)fakeLevel);
        if (!previews.hasStructure()) {
            CompoundTag nbt = new CompoundTag();
            new LittleFixedStructure((LittleStructureType)LittleStructureRegistry.REGISTRY.get("fixed"), null).save(nbt, provider);
            ArrayList<LittleGroup> newChildren = new ArrayList<LittleGroup>();
            for (LittleGroup group : previews.children.children()) {
                newChildren.add(group.copy());
            }
            LittleGroup group = new LittleGroup(nbt, newChildren);
            LittleGroup oldPreviews = previews;
            group.addAll(this.grid, (Iterable<LittleTile>)new FunctionIterator((Iterable)((Object)oldPreviews), x -> x.copy()));
            previews = group;
        }
        this.entireBox = previews.getSurroundingBox();
        this.box = this.entireBox.getBB(this.grid);
        StructureAbsolute structureAbsolute = absolute = structure != null ? structure.createAnimationCenter(pos, this.grid) : null;
        if (absolute == null) {
            absolute = new StructureAbsolute(pos, this.entireBox, previews.getGrid());
        }
        Placement placement = new Placement(null, subLevel, PlacementPreview.load(null, PlacementMode.ALL, new LittleGroupAbsolute(pos, previews)));
        this.animation = new LittleAnimationEntity((Level)fakeLevel, subLevel, absolute, placement);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setupRendering(PoseStack pose) {
        this.animation.getOrigin().setupRendering(pose, 0.0, 0.0, 0.0, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
    }

    public void unload() {
        this.animation.destroyAnimation();
    }

    public void set(PhysicalState state) {
        ((LittleAnimationEntityPhysic)this.animation.physic).set(state);
    }

    public void tick() {
        this.animation.getOrigin().tick();
    }

    public void setCenter(StructureAbsolute center) {
        this.animation.setCenter(center);
    }
}

