/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.math.vec.SmoothValue;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationViewerStorage;

public class GuiAnimationViewer
extends GuiControl {
    public SmoothValue offX = new SmoothValue(200L);
    public SmoothValue offY = new SmoothValue(200L);
    public SmoothValue offZ = new SmoothValue(200L);
    public SmoothValue rotX = new SmoothValue(200L);
    public SmoothValue rotY = new SmoothValue(200L);
    public SmoothValue rotZ = new SmoothValue(200L);
    public SmoothValue distance = new SmoothValue(200L);
    public ViewerDragMode grabMode = ViewerDragMode.NONE;
    private ProjectionMode projection = ProjectionMode.SHOWCASE;
    public double grabX;
    public double grabY;
    public GuiAnimationViewerStorage storage;
    private boolean initialized = false;
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private boolean up;
    private boolean down;

    public GuiAnimationViewer(String name, GuiAnimationViewerStorage storage) {
        super(name);
        this.storage = storage;
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public void mouseMoved(double x, double y) {
        super.mouseMoved(x, y);
        if (this.grabMode == ViewerDragMode.NONE) {
            return;
        }
        switch (this.grabMode.ordinal()) {
            case 1: {
                int scale = Math.min(this.rect.getWidth(), this.rect.getHeight());
                this.rotY.setStart(this.rotY.aimed() + (x - this.grabX) / (double)scale * 180.0);
                this.rotX.setStart(this.rotX.aimed() + (y - this.grabY) / (double)scale * 180.0);
                break;
            }
            default: {
                this.projection.dragMouse(this, x - this.grabX, y - this.grabY);
            }
        }
        this.grabX = x;
        this.grabY = y;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.grabMode == ViewerDragMode.NONE) {
            this.grabMode = ViewerDragMode.of(button);
            this.grabX = x;
            this.grabY = y;
            return true;
        }
        return false;
    }

    public void mouseReleased(double x, double y, int button) {
        if (button == this.grabMode.ordinal() - 1) {
            this.grabMode = ViewerDragMode.NONE;
        }
    }

    public boolean mouseScrolled(double x, double y, double delta) {
        this.distance.set(Math.max(this.distance.aimed() + delta * (double)(-(Screen.hasControlDown() ? 5 : 1)), 0.0));
        return true;
    }

    public void nextProjection() {
        this.setProjection(this.projection.next());
    }

    public void setProjection(ProjectionMode mode) {
        this.projection = mode;
        this.initialized = false;
    }

    public static Matrix4f getProjectionMatrix(Minecraft mc, double fov, float width, float height) {
        return new Matrix4f().perspective((float)(fov * Math.PI / 180.0), width / height, 0.05f, mc.gameRenderer.getDepthFar());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Options options = Minecraft.getInstance().options;
        if (options.keyUp.matches(keyCode, scanCode)) {
            this.forward = true;
        }
        if (options.keyDown.matches(keyCode, scanCode)) {
            this.backward = true;
        }
        if (options.keyRight.matches(keyCode, scanCode)) {
            this.left = true;
        }
        if (options.keyLeft.matches(keyCode, scanCode)) {
            this.right = true;
        }
        if (options.keyJump.matches(keyCode, scanCode)) {
            this.up = true;
        }
        if (options.keyShift.matches(keyCode, scanCode)) {
            this.down = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        Options options = Minecraft.getInstance().options;
        if (options.keyUp.matches(keyCode, scanCode)) {
            this.forward = false;
        }
        if (options.keyDown.matches(keyCode, scanCode)) {
            this.backward = false;
        }
        if (options.keyRight.matches(keyCode, scanCode)) {
            this.left = false;
        }
        if (options.keyLeft.matches(keyCode, scanCode)) {
            this.right = false;
        }
        if (options.keyJump.matches(keyCode, scanCode)) {
            this.up = false;
        }
        if (options.keyShift.matches(keyCode, scanCode)) {
            this.down = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void resetView() {
        this.offX.set(0.0);
        this.offY.set(0.0);
        this.offZ.set(0.0);
        this.rotX.set(0.0);
        this.rotY.set(0.0);
        this.rotZ.set(0.0);
        this.initialized = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, Rect controlRect, Rect realRect, double controlScale, int mouseX, int mouseY) {
        if (!this.storage.isReady()) {
            return;
        }
        if (!this.initialized) {
            this.resetView();
            this.projection.init(this);
            this.initialized = true;
        }
        Minecraft mc = Minecraft.getInstance();
        Window window = mc.getWindow();
        this.rotX.tick();
        this.rotY.tick();
        this.rotZ.tick();
        this.distance.tick();
        this.offX.tick();
        this.offY.tick();
        this.offZ.tick();
        float amount = mc.getTimer().getGameTimeDeltaTicks() * 2.0f;
        if (Screen.hasControlDown()) {
            amount *= 4.0f;
        }
        if (this.forward) {
            this.projection.forward(amount, this);
        }
        if (this.backward) {
            this.projection.forward(-amount, this);
        }
        if (this.left) {
            this.projection.lateral(amount, this);
        }
        if (this.right) {
            this.projection.lateral(-amount, this);
        }
        if (this.up) {
            this.projection.up(amount, this);
        }
        if (this.down) {
            this.projection.up(-amount, this);
        }
        Matrix4fStack view = RenderSystem.getModelViewStack();
        view.pushMatrix();
        view.identity();
        RenderSystem.applyModelViewMatrix();
        PoseStack pose = new PoseStack();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        double scale = window.getGuiScale();
        int height = (int)(realRect.getHeight() * scale);
        RenderSystem.viewport((int)((int)(realRect.minX * scale)), (int)((int)((double)window.getHeight() - realRect.minY * scale - (double)height)), (int)((int)(realRect.getWidth() * scale)), (int)height);
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        Matrix4f projection = GuiAnimationViewer.getProjectionMatrix(mc, 70.0, this.rect.getContentWidth(), this.rect.getContentHeight());
        RenderSystem.setProjectionMatrix((Matrix4f)projection, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        RenderSystem.enableDepthTest();
        Vec3d center = this.storage.center();
        this.projection.prepareRendering(pose, center, this);
        this.storage.renderAll(pose, projection, mc);
        RenderSystem.viewport((int)0, (int)0, (int)window.getWidth(), (int)window.getHeight());
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().ortho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, ClientHooks.getGuiFarPlane()), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Lighting.setupFor3DItems();
        RenderSystem.disableDepthTest();
        view.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    public void closed() {
    }

    public void init() {
    }

    public void tick() {
    }

    public void flowX(int width, int preferred) {
    }

    public void flowY(int width, int height, int preferred) {
    }

    protected int preferredWidth(int availableWidth) {
        return 10;
    }

    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }

    protected static enum ViewerDragMode {
        NONE,
        LEFT,
        RIGHT,
        MIDDLE;


        public static ViewerDragMode of(int button) {
            return switch (button) {
                case 0 -> LEFT;
                case 1 -> RIGHT;
                case 2 -> MIDDLE;
                default -> NONE;
            };
        }
    }

    public static enum ProjectionMode {
        SHOWCASE{

            @Override
            public void init(GuiAnimationViewer viewer) {
                viewer.distance.set(viewer.storage.longestSide() / 2.0 + 2.0);
            }

            @Override
            public void dragMouse(GuiAnimationViewer viewer, double x, double y) {
                double grabOffset = 0.01;
                switch (viewer.grabMode) {
                    case RIGHT: {
                        Vector3f offset = new Vector3f((float)(x * grabOffset), 0.0f, (float)(y * grabOffset));
                        this.apply(offset, viewer);
                        break;
                    }
                    case MIDDLE: {
                        Vector3f offset = new Vector3f((float)(x * grabOffset), (float)(y * -grabOffset), 0.0f);
                        this.apply(offset, viewer);
                    }
                }
            }

            @Override
            public void forward(float amount, GuiAnimationViewer viewer) {
                viewer.rotX.add((double)amount);
            }

            @Override
            public void lateral(float amount, GuiAnimationViewer viewer) {
                viewer.rotY.add((double)(-amount));
            }

            public void apply(Vector3f vec, GuiAnimationViewer viewer) {
                vec.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)viewer.rotX.current()));
                vec.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)viewer.rotY.current()));
                vec.rotate((Quaternionfc)Axis.ZP.rotationDegrees((float)viewer.rotZ.current()));
                viewer.offX.set(viewer.offX.aimed() + (double)vec.x);
                viewer.offY.set(viewer.offY.aimed() + (double)vec.y);
                viewer.offZ.set(viewer.offZ.aimed() + (double)vec.z);
            }

            @Override
            public void prepareRendering(PoseStack pose, Vec3d center, GuiAnimationViewer viewer) {
                pose.translate(viewer.offX.current(), viewer.offY.current(), viewer.offZ.current() - viewer.distance.current());
                pose.mulPose(Axis.XP.rotationDegrees((float)viewer.rotX.current()));
                pose.mulPose(Axis.YP.rotationDegrees((float)viewer.rotY.current()));
                pose.mulPose(Axis.ZP.rotationDegrees((float)viewer.rotZ.current()));
                pose.translate(-center.x, -center.y, -center.z);
            }

            @Override
            public ProjectionMode next() {
                return PLAYER;
            }

            @Override
            public void up(float amount, GuiAnimationViewer viewer) {
                viewer.offZ.add((double)(amount * 0.05f));
            }
        }
        ,
        PLAYER{

            @Override
            public void init(GuiAnimationViewer viewer) {
                viewer.offZ.set(viewer.storage.longestSide() / 2.0);
                viewer.offY.set(-viewer.storage.overall().getSize());
                viewer.rotX.set(45.0);
                viewer.rotY.set(180.0);
            }

            @Override
            public void dragMouse(GuiAnimationViewer viewer, double x, double y) {
            }

            @Override
            public void forward(float amount, GuiAnimationViewer viewer) {
                amount = (float)((double)amount * 0.1);
                viewer.offX.add((double)amount * Math.sin(-viewer.rotY.aimed() * Math.PI / 180.0));
                viewer.offZ.add((double)amount * Math.cos(viewer.rotY.aimed() * Math.PI / 180.0));
            }

            @Override
            public void lateral(float amount, GuiAnimationViewer viewer) {
                amount = (float)((double)amount * -0.1);
                viewer.offX.add((double)amount * Math.cos(-viewer.rotY.aimed() * Math.PI / 180.0));
                viewer.offZ.add((double)amount * Math.sin(viewer.rotY.aimed() * Math.PI / 180.0));
            }

            @Override
            public void prepareRendering(PoseStack pose, Vec3d center, GuiAnimationViewer viewer) {
                pose.mulPose(Axis.XP.rotationDegrees((float)viewer.rotX.current()));
                pose.mulPose(Axis.YP.rotationDegrees((float)viewer.rotY.current()));
                pose.mulPose(Axis.ZP.rotationDegrees((float)viewer.rotZ.current()));
                pose.translate(viewer.offX.current(), viewer.offY.current(), viewer.offZ.current());
                pose.translate(-center.x, -center.y, -center.z);
            }

            @Override
            public ProjectionMode next() {
                return SHOWCASE;
            }

            @Override
            public void up(float amount, GuiAnimationViewer viewer) {
                viewer.offY.add((double)amount * -0.1);
            }
        };


        public abstract ProjectionMode next();

        public abstract void init(GuiAnimationViewer var1);

        public abstract void prepareRendering(PoseStack var1, Vec3d var2, GuiAnimationViewer var3);

        public abstract void dragMouse(GuiAnimationViewer var1, double var2, double var4);

        public abstract void forward(float var1, GuiAnimationViewer var2);

        public abstract void lateral(float var1, GuiAnimationViewer var2);

        public abstract void up(float var1, GuiAnimationViewer var2);
    }
}

