/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiSlider;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineKey;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.common.gui.control.animation.GuiTimelinePanel;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationHandler;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;
import team.creative.littletiles.common.structure.animation.event.PlaySoundEvent;

public class GuiSoundEventPanel
extends GuiTimelinePanel {
    protected List<GuiSoundTimelineChannel> bothChannels;
    protected List<GuiSoundTimelineChannel> closingChannels;
    protected List<GuiSoundTimelineChannel> openingChannels;
    public GuiTimelineKey<PlaySoundEvent> edited;

    public GuiSoundEventPanel(GuiRecipeAnimationHandler handler, AnimationTimeline opening, AnimationTimeline closing, int duration) {
        super(handler, duration);
        List<AnimationTimeline.AnimationEventEntry> openingEvents = GuiSoundEventPanel.extract(opening, PlaySoundEvent.class);
        List<AnimationTimeline.AnimationEventEntry> closingEvents = GuiSoundEventPanel.extract(closing, PlaySoundEvent.class);
        ArrayList<AnimationTimeline.AnimationEventEntry> bothEvents = new ArrayList<AnimationTimeline.AnimationEventEntry>();
        Iterator<AnimationTimeline.AnimationEventEntry> openingItr = openingEvents.iterator();
        block0: while (openingItr.hasNext()) {
            AnimationTimeline.AnimationEventEntry oEvent = openingItr.next();
            Iterator<AnimationTimeline.AnimationEventEntry> closingItr = closingEvents.iterator();
            while (closingItr.hasNext()) {
                AnimationTimeline.AnimationEventEntry cEvent = closingItr.next();
                if (oEvent.start == cEvent.start) {
                    if (!oEvent.getEvent().equals(cEvent.getEvent())) continue;
                    openingItr.remove();
                    closingItr.remove();
                    bothEvents.add(oEvent);
                    continue block0;
                }
                if (oEvent.start >= cEvent.start) continue;
                continue block0;
            }
        }
        this.createChannels(bothEvents, AnimationDirection.BOTH);
        this.createChannels(openingEvents, AnimationDirection.OPENING);
        this.createChannels(closingEvents, AnimationDirection.CLOSING);
        GuiParent channelControl = new GuiParent();
        this.add((GuiControl)channelControl);
        GuiComboBox soundDirection = new GuiComboBox("sound_direction", (IComponentMap)new TextMapBuilder().addComponent((Object[])AnimationDirection.values(), x -> x.title()));
        channelControl.add((GuiControl)soundDirection);
        channelControl.add((GuiControl)new GuiButton("add", x -> this.createChannel((AnimationDirection)((Object)((Object)soundDirection.selected())))).setTranslate("gui.add"));
        channelControl.add((GuiControl)new GuiButton("removed_unused", x -> {
            GuiSoundEventPanel.clearUnusedChannel(this.bothChannels);
            GuiSoundEventPanel.clearUnusedChannel(this.openingChannels);
            GuiSoundEventPanel.clearUnusedChannel(this.closingChannels);
            this.reflow();
        }).setTranslate("gui.door.clean.channel"));
        GuiParent editKey = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        this.add(editKey.setExpandableX());
        this.registerEvent(GuiTimeline.KeySelectedEvent.class, x -> {
            editKey.clear();
            if (((GuiTimelineKey)x.control).channel instanceof GuiSoundTimelineChannel) {
                PlaySoundEvent value = (PlaySoundEvent)((GuiTimelineKey)x.control).value;
                GuiComboBox box = new GuiComboBox("sound", (IComponentMap)new TextMapBuilder().addComponent((Iterable)BuiltInRegistries.SOUND_EVENT.keySet(), y -> {
                    if (y.getNamespace().equals("minecraft")) {
                        return Component.literal((String)y.getPath());
                    }
                    return Component.literal((String)y.toString());
                })).setSearchbar(true);
                box.select((Object)value.sound.getLocation());
                editKey.add((GuiControl)box);
                GuiParent other = new GuiParent().setVAlign(VAlign.CENTER);
                other.add((GuiControl)new GuiLabeledControl((Component)GuiControl.translatable((String)"gui.volume").append(":"), new GuiSlider("volume", (double)value.volume, 0.0, 1.0).setDim(40, 10)));
                other.add((GuiControl)new GuiLabeledControl((Component)GuiControl.translatable((String)"gui.pitch").append(":"), new GuiSlider("pitch", (double)value.pitch, 0.5, 2.0).setDim(40, 10)));
                other.add((GuiControl)new GuiButtonIcon("play", Icon.PLAY, y -> {
                    GuiSlider volume = (GuiSlider)other.get("volume");
                    GuiSlider pitch = (GuiSlider)other.get("pitch");
                    GuiControl.playSound((SoundEvent)PlaySoundEvent.get((ResourceLocation)box.selected()), (float)((float)volume.getValue()), (float)((float)pitch.getValue()));
                }));
                editKey.add((GuiControl)other);
                this.edited = (GuiTimelineKey)x.control;
                this.reflow();
            }
        });
        this.registerEvent(GuiTimeline.NoKeySelectedEvent.class, x -> {
            editKey.clear();
            this.edited = null;
        });
        editKey.registerEventChanged(x -> {
            GuiControl patt2$temp;
            GuiControl patt1$temp;
            GuiControl patt0$temp;
            PlaySoundEvent value = (PlaySoundEvent)this.edited.value;
            if (x.control.is("sound") && (patt0$temp = x.control) instanceof GuiComboBox) {
                GuiComboBox box = (GuiComboBox)patt0$temp;
                value.sound = PlaySoundEvent.get((ResourceLocation)box.selected());
            } else if (x.control.is("volume") && (patt1$temp = x.control) instanceof GuiSlider) {
                GuiSlider slider = (GuiSlider)patt1$temp;
                value.volume = (float)slider.getValue();
            } else if (x.control.is("pitch") && (patt2$temp = x.control) instanceof GuiSlider) {
                GuiSlider slider = (GuiSlider)patt2$temp;
                value.pitch = (float)slider.getValue();
            }
            this.time.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)this.time));
        });
    }

    @Override
    protected void addBefore() {
        this.add((GuiControl)new GuiLabel("soundLabel").setTitle((Component)GuiSoundEventPanel.translatable((String)"gui.door.sound").append(":")));
    }

    public boolean isSoundEmpty() {
        for (GuiSoundTimelineChannel channel : this.bothChannels) {
            if (channel.isChannelEmpty()) continue;
            return false;
        }
        for (GuiSoundTimelineChannel channel : this.openingChannels) {
            if (channel.isChannelEmpty()) continue;
            return false;
        }
        for (GuiSoundTimelineChannel channel : this.closingChannels) {
            if (channel.isChannelEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void collectEvents(int duration, List<AnimationTimeline.AnimationEventEntry> events, List<GuiSoundTimelineChannel> channels) {
        for (GuiSoundTimelineChannel channel : channels) {
            for (GuiTimelineKey key : channel.keys()) {
                if (key.tick > duration) continue;
                events.add(new AnimationTimeline.AnimationEventEntry(key.tick, (AnimationEvent)key.value));
            }
        }
    }

    public void collectEvents(int duration, List<AnimationTimeline.AnimationEventEntry> events, boolean opening) {
        this.collectEvents(duration, events, this.bothChannels);
        this.collectEvents(duration, events, opening ? this.openingChannels : this.closingChannels);
    }

    protected void createChannel(AnimationDirection direction) {
        GuiSoundTimelineChannel channel = new GuiSoundTimelineChannel(this.time);
        List<GuiSoundTimelineChannel> channels = switch (direction.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.bothChannels;
            case 1 -> this.openingChannels;
            case 2 -> this.closingChannels;
        };
        this.time.addGuiTimelineChannel(direction.title().append("" + channels.size()), (GuiTimelineChannel)channel);
        channels.add(channel);
        this.reflow();
    }

    protected void createChannels(List<AnimationTimeline.AnimationEventEntry> events, AnimationDirection direction) {
        ArrayList<GuiSoundTimelineChannel> channels = new ArrayList<GuiSoundTimelineChannel>();
        for (int i = 0; i < events.size(); ++i) {
            AnimationTimeline.AnimationEventEntry entry = events.get(i);
            int id = 0;
            while (true) {
                if (id >= channels.size()) {
                    GuiSoundTimelineChannel channel = new GuiSoundTimelineChannel(this.time);
                    channels.add(channel);
                    this.time.addGuiTimelineChannel(direction.title().append("" + id), (GuiTimelineChannel)channel);
                    continue;
                }
                if (((GuiSoundTimelineChannel)((Object)channels.get(id))).isSpaceFor(null, entry.start)) break;
                ++id;
            }
            ((GuiSoundTimelineChannel)((Object)channels.get(id))).addKey(entry.start, (PlaySoundEvent)entry.getEvent());
        }
        switch (direction.ordinal()) {
            case 0: {
                this.bothChannels = channels;
                break;
            }
            case 1: {
                this.openingChannels = channels;
                break;
            }
            case 2: {
                this.closingChannels = channels;
            }
        }
    }

    public static enum AnimationDirection {
        BOTH,
        OPENING,
        CLOSING;


        public MutableComponent title() {
            return GuiControl.translatable((String)("gui.door.direction." + this.name().toLowerCase()));
        }
    }

    public static class GuiSoundTimelineChannel
    extends GuiTimelineChannel<PlaySoundEvent> {
        public GuiSoundTimelineChannel(GuiTimeline timeline) {
            super(timeline);
        }

        protected PlaySoundEvent getValueAt(int time) {
            return new PlaySoundEvent((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
        }
    }
}

