/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiLabeledControl;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.parent.GuiTable;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCounter;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiStateButton;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.config.LittleBuildingConfig;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.structure.type.premade.LittleStructureBuilder;

public class GuiBuilder
extends GuiLayer {
    public LittleStructureBuilder builder;
    public final GuiSyncLocal<CompoundTag> CRAFT = this.getSyncHolder().register("craft", nbt -> {
        if (this.getPlayer().isCreative() && this.builder.inventory.getItem(0).isEmpty() || this.builder.inventory.getItem(0).getItem() instanceof ItemLittleBlueprint) {
            int width = nbt.getInt("width");
            int height = nbt.getInt("height");
            int thickness = nbt.getInt("thickness");
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)nbt.getString("block")));
            LittleGrid grid = LittleGrid.get(nbt.getInt("grid"));
            this.builder.lastBlockState = block.defaultBlockState();
            this.builder.lastSizeX = width;
            this.builder.lastSizeY = height;
            this.builder.lastThickness = thickness;
            this.builder.lastGrid = grid.count;
            this.builder.lastStructureType = nbt.getString("type");
            this.builder.updateStructure();
            LittleStructureBuilder.LittleStructureBuilderType type = (LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType);
            if (type != null) {
                Item patt0$temp;
                ItemStack stack = this.builder.inventory.getItem(0);
                if (!LittleAction.needIngredients(this.getPlayer()) && stack.isEmpty()) {
                    stack = new ItemStack((ItemLike)LittleTilesRegistry.BLUEPRINT.value());
                    this.builder.inventory.setItem(0, stack);
                }
                if ((patt0$temp = stack.getItem()) instanceof ItemLittleBlueprint) {
                    ItemLittleBlueprint blue = (ItemLittleBlueprint)patt0$temp;
                    blue.saveTiles(stack, type.construct(grid, width, height, thickness, block.defaultBlockState()));
                }
            }
        }
    });

    public GuiBuilder(LittleStructureBuilder builder) {
        super("structure_builder", 200, 200);
        this.builder = builder;
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        GuiTable table = new GuiTable();
        this.add(table.setExpandableX());
        GuiRow row = new GuiRow();
        table.addRow(row);
        GuiColumn col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.width", (GuiControl)new GuiCounter("width", this.builder.lastSizeX, 1, Integer.MAX_VALUE)));
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.height", (GuiControl)new GuiCounter("height", this.builder.lastSizeX, 1, Integer.MAX_VALUE)));
        row = new GuiRow();
        table.addRow(row);
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.structure_builder.thickness", (GuiControl)new GuiCounter("thickness", this.builder.lastThickness, 1, Integer.MAX_VALUE)));
        GuiStateButton gridSelect = new GuiStateButton("grid", LittleGrid.mapBuilder());
        gridSelect.select((Object)((LittleBuildingConfig)LittleTiles.CONFIG.build.get(this.getPlayer())).defaultGrid());
        col = new GuiColumn();
        row.addColumn(col);
        col.add((GuiControl)new GuiLabeledControl("gui.grid", (GuiControl)gridSelect));
        GuiComboBox box = new GuiComboBox("type", (IComponentMap)new TextMapBuilder().addEntrySet(LittleStructureBuilder.REGISTRY.entrySet(), x -> Component.translatable((String)("structure." + (String)x.getKey()))));
        box.select((Object)((LittleStructureBuilder.LittleStructureBuilderType)LittleStructureBuilder.REGISTRY.get(this.builder.lastStructureType)));
        this.add(box.setExpandableX());
        GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(new ItemStack((ItemLike)this.builder.lastBlockState.getBlock()));
        this.add(selector.setExpandableX());
        this.add((GuiControl)new GuiLeftRightBox().addLeft(new GuiLabel("failed").setTranslate("gui.structure_builder.failed").setVisible(false)).addRight((GuiControl)new GuiButton("craft", x -> {
            if (this.getPlayer().isCreative() && this.builder.inventory.getItem(0).isEmpty() || this.builder.inventory.getItem(0).getItem() instanceof ItemLittleBlueprint) {
                this.get((String)"failed").visible = false;
                CompoundTag nbt = new CompoundTag();
                GuiCounter width = (GuiCounter)this.get("width");
                nbt.putInt("width", width.getValue());
                GuiCounter height = (GuiCounter)this.get("height");
                nbt.putInt("height", height.getValue());
                GuiCounter thickness = (GuiCounter)this.get("thickness");
                nbt.putInt("thickness", thickness.getValue());
                GuiComboBox type = (GuiComboBox)this.get("type");
                nbt.putString("type", ((LittleStructureBuilder.LittleStructureBuilderType)type.selected()).type.id);
                GuiStateButton gridButton = (GuiStateButton)this.get("grid");
                LittleGrid grid = (LittleGrid)gridButton.selected();
                nbt.putInt("grid", grid.count);
                ItemStack stack = selector.getSelected();
                Block block = Block.byItem((Item)stack.getItem());
                nbt.putString("block", block.builtInRegistryHolder().key().location().toString());
                this.CRAFT.send((Tag)nbt);
            } else {
                this.get((String)"failed").visible = true;
            }
        }).setTranslate("gui.structure_builder.craft")));
        this.add((GuiControl)new GuiInventoryGrid("builder", (Container)this.builder.inventory));
        this.add((GuiControl)new GuiPlayerInventoryGrid(this.getPlayer()));
    }
}

