/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.core.ICreativeRegistry;
import team.creative.creativecore.common.config.gui.GuiConfigSubControlNested;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.type.list.SortingList;
import team.creative.littletiles.common.structure.type.LittleItemHolder;

public class GuiItemHolder
extends GuiLayer {
    public LittleItemHolder holder;
    public final GuiSyncLocal<CompoundTag> SAVE = this.getSyncHolder().register("save", x -> {
        this.holder.loadSettings((CompoundTag)x, this.provider());
        this.holder.updateStructure();
        this.closeThisLayer();
    });
    public GuiCheckBox locked;
    public GuiConfigSubControlNested sortingControl;

    public GuiItemHolder(LittleItemHolder holder) {
        super("item_holder", 200, 230);
        this.holder = holder;
        this.flow = GuiFlow.STACK_Y;
    }

    public void create() {
        this.locked = new GuiCheckBox("locked", this.holder.locked).setTranslate("gui.structure.locked");
        this.add((GuiControl)this.locked);
        SortingList sortingList = new SortingList(this.holder.whitelist);
        if (this.holder.filter != null) {
            sortingList.entries.addAll(this.holder.filter);
        }
        ConfigHolderObject holder = ConfigHolderObject.createUnrelated((ICreativeRegistry)CreativeConfigRegistry.ROOT, (Side)Side.SERVER, (Object)sortingList, (Object)new SortingList());
        this.sortingControl = new GuiConfigSubControlNested("filter", ConfigTypeConveration.FAKE_PARENT, null, Side.SERVER, null, true);
        this.add((GuiControl)this.sortingControl);
        this.sortingControl.load((ICreativeConfigHolder)holder, (Object)sortingList);
        this.sortingControl.createControls();
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("locked", this.locked.value);
            this.sortingControl.save();
            SortingList sorting = (SortingList)this.sortingControl.value;
            nbt.putBoolean("f_white", sorting.isWhitelist);
            if (!sorting.entries.isEmpty()) {
                ListTag list = new ListTag();
                for (int i = 0; i < sorting.entries.size(); ++i) {
                    list.add((Object)((CreativeIngredient)sorting.entries.get(i)).save(this.provider()));
                }
                nbt.put("filter", (Tag)list);
            }
            this.SAVE.send((Tag)nbt);
            this.closeThisLayer();
        }).setTranslate("gui.save"));
    }
}

