/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeOverlapTest;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeSignalEquationTest;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestModule;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestResults;

public class RecipeTest {
    public static final RecipeOverlapTest OVERLAP_TEST = new RecipeOverlapTest();
    public static final RecipeSignalEquationTest SIGNAL_TEST = new RecipeSignalEquationTest();
    public static final RecipeTest STANDARD = new RecipeTest(Arrays.asList(OVERLAP_TEST, SIGNAL_TEST));
    private final List<RecipeTestModule> modules;

    public static RecipeTestResults testModule(GuiRecipe recipe, RecipeTestModule module) {
        RecipeTest.resetBeforeTest(recipe);
        RecipeTestResults results = new RecipeTestResults();
        module.startTest(recipe, results);
        for (GuiTreeItem child : recipe.tree.root().items()) {
            RecipeTest.testStructure(module, (GuiTreeItemStructure)child, results);
        }
        module.endTest(recipe, results);
        return results;
    }

    protected static void testStructure(RecipeTestModule module, GuiTreeItemStructure item, RecipeTestResults results) {
        module.test(item, results);
        for (GuiTreeItem child : item.items()) {
            RecipeTest.testStructure(module, (GuiTreeItemStructure)child, results);
        }
    }

    public static void resetBeforeTest(GuiRecipe recipe) {
        recipe.storage.resetOverlap();
    }

    public RecipeTest(List<RecipeTestModule> modules) {
        this.modules = new ArrayList<RecipeTestModule>(modules);
    }

    public void addModule(RecipeTestModule module) {
        this.modules.add(module);
    }

    public RecipeTestResults test(GuiRecipe recipe) {
        RecipeTest.resetBeforeTest(recipe);
        RecipeTestResults results = new RecipeTestResults();
        for (RecipeTestModule module : this.modules) {
            module.startTest(recipe, results);
        }
        for (GuiTreeItem child : recipe.tree.root().items()) {
            this.testStructure((GuiTreeItemStructure)child, results);
        }
        for (RecipeTestModule module : this.modules) {
            module.endTest(recipe, results);
        }
        return results;
    }

    protected void testStructure(GuiTreeItemStructure item, RecipeTestResults results) {
        for (RecipeTestModule module : this.modules) {
            module.test(item, results);
        }
        for (GuiTreeItem child : item.items()) {
            this.testStructure((GuiTreeItemStructure)child, results);
        }
    }
}

