/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.ingredient.ILittleIngredientInventory;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;

public class ItemColorIngredient
extends Item
implements ILittleIngredientInventory {
    public ColorIngredientType type;

    public ItemColorIngredient(ColorIngredientType type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
    }

    public static ItemStack generateItemStack(ColorIngredientType type, int value) {
        ItemStack stack = switch (type.ordinal()) {
            case 0 -> new ItemStack((ItemLike)LittleTilesRegistry.BLACK_COLOR.value());
            case 1 -> new ItemStack((ItemLike)LittleTilesRegistry.CYAN_COLOR.value());
            case 2 -> new ItemStack((ItemLike)LittleTilesRegistry.MAGENTA_COLOR.value());
            case 3 -> new ItemStack((ItemLike)LittleTilesRegistry.YELLOW_COLOR.value());
            default -> ItemStack.EMPTY;
        };
        if (!stack.isEmpty()) {
            ColorIngredient color = new ColorIngredient();
            type.setIngredient(color, value);
            ((ItemColorIngredient)stack.getItem()).setInventory(stack, new LittleIngredients(color), null);
        }
        return stack;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack me, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess otherSlot) {
        return false;
    }

    public ColorIngredient loadIngredient(ItemStack stack) {
        if (stack.has(LittleTilesRegistry.COLOR_AMOUNT)) {
            ColorIngredient ingredient = new ColorIngredient();
            this.type.setIngredient(ingredient, (Integer)stack.get(LittleTilesRegistry.COLOR_AMOUNT));
            switch (this.type.ordinal()) {
                case 0: {
                    ingredient.setLimit(262144, 0, 0, 0);
                    break;
                }
                case 1: {
                    ingredient.setLimit(0, 262144, 0, 0);
                    break;
                }
                case 2: {
                    ingredient.setLimit(0, 0, 262144, 0);
                    break;
                }
                case 3: {
                    ingredient.setLimit(0, 0, 0, 262144);
                    break;
                }
            }
            return ingredient;
        }
        return null;
    }

    public int getColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(LittleTilesRegistry.COLOR_AMOUNT, (Object)0);
    }

    public void saveIngredient(ItemStack stack, ColorIngredient color) {
        stack.set(LittleTilesRegistry.COLOR_AMOUNT, (Object)this.type.getIngredient(color));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        ColorIngredient entry = this.loadIngredient(stack);
        if (entry != null) {
            tooltip.add(this.type.print(entry));
        }
    }

    @Override
    public LittleIngredients getInventory(ItemStack stack) {
        ColorIngredient color = this.loadIngredient(stack);
        if (color != null) {
            return new LittleIngredients(this, new LittleIngredient[]{color}){

                @Override
                protected boolean canAddNewIngredients() {
                    return false;
                }

                @Override
                protected boolean removeEmptyIngredients() {
                    return false;
                }
            };
        }
        return null;
    }

    @Override
    public void setInventory(ItemStack stack, LittleIngredients ingredients, LittleInventory inventory) {
        ColorIngredient color = ingredients.get(ColorIngredient.class);
        if (color != null && this.type.getIngredient(color) > 0) {
            this.saveIngredient(stack, color);
            return;
        }
        stack.remove(LittleTilesRegistry.COLOR_AMOUNT);
        stack.setCount(0);
    }

    @Override
    public boolean shouldBeMerged() {
        return true;
    }

    public static enum ColorIngredientType {
        black{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.black;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.black = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.literal((String)ingredient.getBlackDescription());
            }
        }
        ,
        cyan{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.cyan;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.cyan = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.literal((String)ingredient.getCyanDescription());
            }
        }
        ,
        magenta{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.magenta;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.magenta = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.literal((String)ingredient.getMagentaDescription());
            }
        }
        ,
        yellow{

            @Override
            public int getIngredient(ColorIngredient ingredient) {
                return ingredient.yellow;
            }

            @Override
            public void setIngredient(ColorIngredient ingredient, int value) {
                ingredient.yellow = value;
            }

            @Override
            public Component print(ColorIngredient ingredient) {
                return Component.literal((String)ingredient.getYellowDescription());
            }
        };


        public abstract int getIngredient(ColorIngredient var1);

        public abstract void setIngredient(ColorIngredient var1, int var2);

        public abstract Component print(ColorIngredient var1);

        public static ColorIngredientType getType(String type) {
            switch (type.toLowerCase()) {
                case "black": {
                    return black;
                }
                case "cyan": {
                    return cyan;
                }
                case "magenta": {
                    return magenta;
                }
                case "yellow": {
                    return yellow;
                }
            }
            return null;
        }
    }
}

