/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;

public class TileFilterComponent {
    public static final Codec<TileFilterComponent> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.BOOL.fieldOf("active").forGetter(e -> e.active), (App)CompoundTag.CODEC.fieldOf("filter").forGetter(e -> e.nbt)).apply((Applicative)x, TileFilterComponent::new));
    public static final StreamCodec<FriendlyByteBuf, TileFilterComponent> STREAM_CODEC = StreamCodec.of((buffer, i) -> {
        buffer.writeBoolean(i.active);
        buffer.writeNbt((Tag)i.nbt);
    }, buffer -> new TileFilterComponent(buffer.readBoolean(), buffer.readNbt()));
    private final boolean active;
    private final CompoundTag nbt;

    public static TileFilterComponent of(boolean active, BiFilter<IParentCollection, LittleTile> filter) {
        try {
            return new TileFilterComponent(active, BiFilter.SERIALIZER.write(filter));
        }
        catch (RegistryException e) {
            return new TileFilterComponent(false, new CompoundTag());
        }
    }

    public static TileFilterComponent getOrCreate(ItemStack stack) {
        TileFilterComponent filter = (TileFilterComponent)stack.get(LittleTilesRegistry.FILTER);
        if (filter != null) {
            return filter;
        }
        return new TileFilterComponent(false, new CompoundTag());
    }

    private TileFilterComponent(boolean active, CompoundTag nbt) {
        this.active = active;
        this.nbt = nbt;
    }

    public boolean hasFilter() {
        return this.active;
    }

    public BiFilter<IParentCollection, LittleTile> getFilter() {
        try {
            if (this.nbt.isEmpty()) {
                return null;
            }
            return BiFilter.SERIALIZER.read(this.nbt);
        }
        catch (RegistryException e) {
            return null;
        }
    }

    public int hashCode() {
        return this.nbt.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TileFilterComponent) {
            TileFilterComponent t = (TileFilterComponent)obj;
            return t.active == this.active && this.nbt.equals((Object)t.nbt);
        }
        return false;
    }
}

