/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.math.Maths;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.math.box.BoxUtils;
import team.creative.creativecore.common.util.math.geo.NormalPlaneD;
import team.creative.creativecore.common.util.math.geo.VectorFan;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleTransformableBox;

public class TransformableABB
extends ABB {
    private LittleGrid grid;
    private LittleTransformableBox box;

    public TransformableABB(ABB bb, LittleGrid grid, LittleTransformableBox box) {
        super(bb);
        this.grid = grid;
        this.box = box;
    }

    public TransformableABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, LittleGrid grid, LittleTransformableBox box) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.grid = grid;
        this.box = box;
    }

    public LittleTransformableBox.VectorFanFaceCache getFaceCache(Facing facing) {
        LittleTransformableBox.VectorFanCache cache = this.box.requestCache();
        if (cache != null) {
            return cache.get(facing);
        }
        return null;
    }

    public double calculateAxisOffset(Axis axis, Axis one, Axis two, AABB other, double offset) {
        if (offset == 0.0) {
            return offset;
        }
        if (Math.abs(offset) < 1.0E-7) {
            return offset;
        }
        boolean positive = offset > 0.0;
        Facing direction = Facing.get((Axis)axis, (boolean)positive);
        double minOne = BoxUtils.min((AABB)other, (Axis)one);
        minOne -= Math.floor(this.min(one));
        minOne *= (double)this.grid.count;
        double minTwo = BoxUtils.min((AABB)other, (Axis)two);
        minTwo -= Math.floor(this.min(two));
        minTwo *= (double)this.grid.count;
        double maxOne = BoxUtils.max((AABB)other, (Axis)one);
        maxOne -= Math.floor(this.min(one));
        maxOne *= (double)this.grid.count;
        double maxTwo = BoxUtils.max((AABB)other, (Axis)two);
        maxTwo -= Math.floor(this.min(two));
        double otherAxis = offset > 0.0 ? BoxUtils.max((AABB)other, (Axis)axis) : BoxUtils.min((AABB)other, (Axis)axis);
        otherAxis -= Math.floor(this.min(axis));
        otherAxis *= (double)this.grid.count;
        NormalPlaneD[] cuttingPlanes = new NormalPlaneD[]{new NormalPlaneD(one, minOne, Facing.get((Axis)one, (boolean)false)), new NormalPlaneD(two, minTwo, Facing.get((Axis)two, (boolean)false)), new NormalPlaneD(one, maxOne, Facing.get((Axis)one, (boolean)true)), new NormalPlaneD(two, maxTwo *= (double)this.grid.count, Facing.get((Axis)two, (boolean)true))};
        VectorFan tempFan = new VectorFan(null);
        LittleTransformableBox.VectorFanFaceCache front = this.getFaceCache(direction.opposite());
        if (front.hasAxisStrip()) {
            for (VectorFan vectorFan : front.axisStrips) {
                double d0;
                tempFan.set(vectorFan);
                if (!tempFan.cutWithoutCopy(cuttingPlanes)) continue;
                if (offset > 0.0 && BoxUtils.max((AABB)other, (Axis)axis) <= this.min(axis)) {
                    double d1 = this.min(axis) - BoxUtils.max((AABB)other, (Axis)axis);
                    if (d1 < offset) {
                        return d1;
                    }
                } else if (offset < 0.0 && BoxUtils.min((AABB)other, (Axis)axis) >= this.max(axis) && (d0 = this.max(axis) - BoxUtils.min((AABB)other, (Axis)axis)) > offset) {
                    return d0;
                }
                return offset;
            }
        }
        double distance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < Facing.values().length; ++i) {
            LittleTransformableBox.VectorFanFaceCache face;
            Facing facing = Facing.values()[i];
            if (facing == direction || !(face = this.getFaceCache(facing)).hasTiltedStrip()) continue;
            for (VectorFan vectorFan : face.tilted()) {
                tempFan.set(vectorFan);
                tempFan.cutWithoutCopy(cuttingPlanes);
                if (tempFan.isEmpty()) continue;
                for (int j = 0; j < tempFan.count(); ++j) {
                    double tempDistance;
                    Vec3f vec = tempFan.get(j);
                    double d = tempDistance = positive ? (double)vec.get(axis) - otherAxis : otherAxis - (double)vec.get(axis);
                    if (tempDistance < 0.0 && !Maths.equals((double)tempDistance, (double)0.0)) {
                        return offset;
                    }
                    if (!(tempDistance < distance)) continue;
                    distance = tempDistance;
                }
            }
        }
        if (Double.isInfinite(distance)) {
            return offset;
        }
        distance *= this.grid.pixelLength;
        if (offset > 0.0) {
            if (distance < offset) {
                return distance;
            }
            return offset;
        }
        if (offset < 0.0) {
            if (-distance > offset) {
                return -distance;
            }
            return offset;
        }
        return offset;
    }

    public boolean intersectsPrecise(AABB bb) {
        Vec3d offset = new Vec3d(Math.floor(this.minX), Math.floor(this.minY), Math.floor(this.minZ));
        Vec3d[] corners = BoxUtils.getCorners((AABB)bb);
        for (int i = 0; i < corners.length; ++i) {
            corners[i].sub(offset);
            corners[i].scale((double)this.grid.count);
        }
        LittleTransformableBox.VectorFanCache cache = new LittleTransformableBox.VectorFanCache();
        for (int i = 0; i < cache.faces.length; ++i) {
            LittleTransformableBox.VectorFanFaceCache face = new LittleTransformableBox.VectorFanFaceCache();
            BoxFace boxFace = BoxFace.values()[i];
            Vec3f[] coords = new Vec3f[boxFace.corners.length];
            for (int j = 0; j < coords.length; ++j) {
                coords[j] = new Vec3f(corners[boxFace.corners[j].ordinal()]);
            }
            face.axisStrips.add(new VectorFan(coords));
            cache.faces[i] = face;
        }
        return this.box.requestCache().intersectsWith((Object2FloatFunction<Facing>)((Object2FloatFunction)x -> (float)this.grid.count * (float)(this.get((Facing)x) - offset.get(((Facing)x).axis))), cache) && cache.intersectsWith((Object2FloatFunction<Facing>)((Object2FloatFunction)x -> this.box.get((Facing)x)), this.box.requestCache());
    }

    public BlockHitResult rayTrace(Vec3 pos, Vec3 look, BlockPos blockPos) {
        return this.box.rayTrace(this.grid, blockPos, pos, look);
    }

    public TransformableABB copy() {
        return new TransformableABB(this, this.grid, this.box);
    }
}

