/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.location;

import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.exception.MissingAnimationException;

public class TileLocation {
    public final BlockPos pos;
    public final boolean isStructure;
    public final int index;
    public final LittleBox box;
    public final UUID levelUUID;

    public TileLocation(BlockPos pos, boolean isStructure, int index, LittleBox box, UUID world) {
        this.pos = pos;
        this.isStructure = isStructure;
        this.index = index;
        this.box = box;
        this.levelUUID = world;
    }

    public TileLocation(LittleTileContext context) {
        if (context.parent.isStructure()) {
            this.isStructure = true;
            this.index = ((StructureParentCollection)context.parent).getIndex();
        } else {
            this.isStructure = false;
            this.index = -1;
        }
        this.pos = context.parent.getPos();
        this.box = context.box.copy();
        Level level = context.parent.getLevel();
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            this.levelUUID = sub.getHolder().getUUID();
        } else {
            this.levelUUID = null;
        }
    }

    public TileLocation(CompoundTag nbt) {
        int[] posArray = nbt.getIntArray("pos");
        if (posArray.length != 3) {
            throw new IllegalArgumentException("Invalid pos array length " + Arrays.toString(posArray));
        }
        this.pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        this.isStructure = nbt.contains("index");
        this.index = nbt.getInt("index");
        this.box = LittleBox.create(nbt.getIntArray("box"));
        this.levelUUID = nbt.contains("world") ? UUID.fromString(nbt.getString("world")) : null;
    }

    public CompoundTag write(CompoundTag nbt) {
        nbt.putIntArray("pos", new int[]{this.pos.getX(), this.pos.getY(), this.pos.getZ()});
        if (this.isStructure) {
            nbt.putInt("index", this.index);
        }
        nbt.putIntArray("box", this.box.getArray());
        if (this.levelUUID != null) {
            nbt.putString("world", this.levelUUID.toString());
        }
        return nbt;
    }

    public LittleTileContext find(LevelAccessor level) throws LittleActionException {
        BlockEntity be;
        if (this.levelUUID != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(level.isClientSide(), this.levelUUID);
            if (entity == null) {
                throw new MissingAnimationException(this.levelUUID);
            }
            level = entity.getSubLevel();
        }
        if ((be = level.getBlockEntity(this.pos)) instanceof BETiles) {
            IParentCollection list = ((BETiles)be).noneStructureTiles();
            if (this.isStructure) {
                list = ((BETiles)be).getStructure(this.index);
            }
            for (LittleTile tile : list) {
                if (!tile.contains(this.box)) continue;
                return new LittleTileContext(list, tile, this.box);
            }
            throw new LittleActionException.TileNotFoundException();
        }
        throw new LittleActionException.BlockEntityNotFoundException();
    }
}

