/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class PlacementPosition
extends LittleVecAbsolute {
    public final Facing facing;

    public PlacementPosition(PlacementPosition position) {
        super(position.pos, position.gridVec);
        this.facing = position.facing;
    }

    public PlacementPosition(BlockPos pos, LittleVecGrid vec, Facing facing) {
        super(pos, vec);
        this.facing = facing;
    }

    public PlacementPosition(BlockPos pos, LittleGrid context, LittleVec vec, Facing facing) {
        super(pos, context, vec);
        this.facing = facing;
    }

    public PlacementPosition(BlockHitResult result, LittleGrid context) {
        super((HitResult)result, context);
        this.facing = Facing.get((Direction)result.getDirection());
    }

    public void assign(LittleVecAbsolute pos) {
        this.pos = pos.getPos();
        this.gridVec = pos.getVecGrid();
    }

    public void subVec(LittleVec vec) {
        this.getVec().add(vec);
        this.removeInternalBlockOffset();
    }

    public void addVec(LittleVec vec) {
        this.getVec().sub(vec);
        this.removeInternalBlockOffset();
    }

    @Override
    public PlacementPosition copy() {
        return new PlacementPosition(this.pos, this.gridVec.copy(), this.facing);
    }

    public void mirror(Axis axis, LittleBoxAbsolute box) {
        box.sameGrid((IGridBased)this.gridVec, () -> {
            LittleVec doubledCenter = box.getDoubledCenter(this.pos);
            long temp = this.gridVec.getVec().get(axis) * 2 - doubledCenter.get(axis);
            this.gridVec.getVec().set(axis, (int)(((long)doubledCenter.get(axis) - temp) / 2L));
        });
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof PlacementPosition) {
                PlacementPosition p = (PlacementPosition)obj;
                return p.facing == this.facing;
            }
            return true;
        }
        return false;
    }
}

