/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.exception.MissingAnimationException;

public class PlacementPreview {
    public final LittleGroup previews;
    public final PlacementMode mode;
    public final PlacementPosition position;
    public final UUID levelUUID;

    public static PlacementPreview load(UUID levelUUID, LittleGroup previews, PlacementMode mode, PlacementPosition position) {
        return new PlacementPreview(levelUUID, previews, mode, position);
    }

    public static PlacementPreview load(UUID levelUUID, PlacementMode mode, LittleGroupAbsolute previews) {
        return new PlacementPreview(levelUUID, previews, mode, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlacementPreview absolute(Level level, PlacementMode mode, LittleGroupAbsolute previews) {
        return new PlacementPreview(level, previews, mode, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlacementPreview relative(Level level, LittleGroup previews, PlacementMode mode, PlacementPosition position) {
        return new PlacementPreview(level, previews, mode, position);
    }

    PlacementPreview(Level level, LittleGroup previews, PlacementMode mode, PlacementPosition position) {
        UUID uUID;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            uUID = sub.getHolder().getUUID();
        } else {
            uUID = null;
        }
        this(uUID, previews, mode, position);
    }

    PlacementPreview(UUID levelUUID, LittleGroup previews, PlacementMode mode, PlacementPosition position) {
        this.levelUUID = levelUUID;
        this.previews = previews;
        if (previews.hasStructureIncludeChildren() && !mode.canPlaceStructures()) {
            mode = PlacementMode.getStructureDefault();
        }
        this.mode = mode;
        this.position = position;
    }

    PlacementPreview(Level level, LittleGroupAbsolute previews, PlacementMode mode, Facing facing) {
        UUID uUID;
        if (level instanceof ISubLevel) {
            ISubLevel sub = (ISubLevel)level;
            uUID = sub.getHolder().getUUID();
        } else {
            uUID = null;
        }
        this(uUID, previews, mode, facing);
    }

    PlacementPreview(UUID levelUUID, LittleGroupAbsolute previews, PlacementMode mode, Facing facing) {
        this.levelUUID = levelUUID;
        this.previews = previews.group;
        if (this.previews.hasStructureIncludeChildren() && !mode.canPlaceStructures()) {
            mode = PlacementMode.getStructureDefault();
        }
        this.mode = mode;
        this.position = new PlacementPosition(previews.pos, new LittleVecGrid(), facing);
    }

    public Level getLevel(Entity entity) throws MissingAnimationException {
        Level level = entity.level();
        if (this.levelUUID != null) {
            LittleEntity levelEntity = LittleTiles.ANIMATION_HANDLERS.find(level.isClientSide, this.levelUUID);
            if (levelEntity == null) {
                throw new MissingAnimationException(this.levelUUID);
            }
            level = (Level)levelEntity.getSubLevel();
        }
        return level;
    }

    public Set<BlockPos> getPositions() {
        return this.previews.getPositions(this.position.getPos());
    }

    public PlacementPreview copy() {
        return new PlacementPreview(this.levelUUID, this.previews.copy(), this.mode, this.position.copy());
    }

    public void mirror(Axis axis, LittleBoxAbsolute box) {
        this.position.mirror(axis, box);
        this.previews.transform(axis.getMatrix(), box.getDoubledCenter(this.position.getPos()));
    }

    public LittleIngredients getBeforePlaceIngredients(HolderLookup.Provider provider) {
        return this.mode.getBeforePlaceIngredients(provider, this.previews);
    }
}

