/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.output;

import net.minecraft.nbt.CompoundTag;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;

public abstract class SignalOutputHandler {
    public final ISignalComponent component;
    public final int delay;
    public SignalState lastReacted;

    public SignalOutputHandler(ISignalComponent component, int delay, CompoundTag nbt) {
        this.component = component;
        this.delay = delay;
    }

    public abstract SignalMode getMode();

    public void schedule(SignalState state) {
        try {
            int bandwidth = this.getBandwidth();
            if (this.lastReacted != null && this.lastReacted.equals(bandwidth, state)) {
                return;
            }
            this.queue(state);
            if (this.lastReacted == null) {
                this.lastReacted = SignalState.create(bandwidth);
            }
            this.lastReacted = this.lastReacted.overwrite(state);
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public abstract void queue(SignalState var1);

    public void performStateChange(SignalState state) {
        this.component.updateState(state);
    }

    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
        return this.component.getBandwidth();
    }

    public abstract void write(boolean var1, CompoundTag var2);

    public static SignalOutputHandler create(ISignalComponent component, SignalMode mode, int delay, CompoundTag nbt, LittleStructure structure) {
        return mode.create(component, delay, nbt, structure != null && structure.isClient());
    }

    public boolean isStillAvailable() {
        return this.component.getStructure().isStillAvailable();
    }

    public String toString() {
        return this.component.toString();
    }
}

