/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittleNoClipStructure
extends LittleStructure {
    public HashSet<Entity> entities = new HashSet();
    public boolean web = true;

    public LittleNoClipStructure(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.web = nbt.getBoolean("web");
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putBoolean("web", this.web);
    }

    @Override
    public void onEntityCollidedWithBlock(Level level, IStructureParentCollection parent, BlockPos pos, Entity entityIn) {
        if (this.web) {
            entityIn.makeStuckInBlock(Blocks.COBWEB.defaultBlockState(), new Vec3(0.25, (double)0.05f, 0.25));
        }
        if (level.isClientSide) {
            return;
        }
        boolean intersected = false;
        block0: for (LittleTile tile : parent) {
            for (LittleBox box : tile) {
                if (!box.getBB(parent.getGrid(), pos).intersects(entityIn.getBoundingBox())) continue;
                intersected = true;
                continue block0;
            }
        }
        if (intersected) {
            this.entities.add(entityIn);
        }
        this.queueForNextTick();
    }

    @Override
    public boolean queuedTick() {
        int players = 0;
        for (Entity entity : this.entities) {
            if (!(entity instanceof Player)) continue;
            ++players;
        }
        this.getInput(0).updateState(SignalState.of(players));
        this.getInput(1).updateState(SignalState.of(this.entities.size()));
        boolean wasEmpty = this.entities.isEmpty();
        this.entities.clear();
        return !wasEmpty;
    }
}

