/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client.render;

import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.littletiles.client.render.mc.RenderChunkRegionExtender;

@Mixin(value={RenderChunkRegion.class})
public class RenderChunkRegionMixin
implements RenderChunkRegionExtender {
    @Unique
    private boolean fake;
    @Mutable
    @Shadow
    protected Level level;

    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void getBlockState(BlockPos pos, CallbackInfoReturnable<BlockState> info) {
        if (this.fake) {
            info.setReturnValue((Object)this.level.getBlockState(pos));
        }
    }

    @Inject(method={"getFluidState"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void getFluidState(BlockPos pos, CallbackInfoReturnable<FluidState> info) {
        if (this.fake) {
            info.setReturnValue((Object)this.level.getFluidState(pos));
        }
    }

    @Inject(method={"getBlockEntity"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void getBlockEntity(BlockPos pos, CallbackInfoReturnable<BlockEntity> info) {
        if (this.fake) {
            info.setReturnValue((Object)this.level.getBlockEntity(pos));
        }
    }

    @Inject(method={"getModelData"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void getModelData(BlockPos pos, CallbackInfoReturnable<ModelData> info) {
        if (this.fake) {
            info.setReturnValue((Object)this.level.getModelData(pos));
        }
    }

    @Inject(method={"getAuxLightManager"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    public void getAuxLightManager(ChunkPos pos, CallbackInfoReturnable<AuxiliaryLightManager> info) {
        if (this.fake) {
            info.setReturnValue((Object)this.level.getAuxLightManager(pos));
        }
    }

    @Override
    public void setFake(Level level) {
        this.fake = true;
        this.level = level;
    }
}

