/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.collision;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.CommonHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import team.creative.littletiles.common.block.mc.BlockTile;

@Mixin(value={CommonHooks.class})
public class CommonHooksMixin {
    @Inject(method={"isLivingOnLadder"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void isLivingOnLadder(BlockState state, Level level, BlockPos pos, LivingEntity entity, CallbackInfoReturnable<Optional<BlockPos>> info) {
        if (((Optional)info.getReturnValue()).isPresent()) {
            return;
        }
        BlockPos.MutableBlockPos tmp = new BlockPos.MutableBlockPos();
        AABB bb = entity.getBoundingBox();
        bb = entity.getBoundingBox().inflate(1.0E-4);
        int mX = Mth.floor((double)bb.minX);
        int mY = Mth.floor((double)bb.minY);
        int mZ = Mth.floor((double)bb.minZ);
        int y2 = mY;
        while ((double)y2 < bb.maxY) {
            int x2 = mX;
            while ((double)x2 < bb.maxX) {
                int z2 = mZ;
                while ((double)z2 < bb.maxZ) {
                    tmp.set(x2, y2, z2);
                    state = level.getBlockState((BlockPos)tmp);
                    if (state.getBlock() instanceof BlockTile && state.getBlock().isLadder(state, (LevelReader)level, (BlockPos)tmp, entity)) {
                        info.setReturnValue(Optional.of(tmp.immutable()));
                        return;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
    }
}

