/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.little.LittleChunkSerializer;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.server.level.little.LittleChunkHolder;
import team.creative.littletiles.server.level.little.LittleDistanceManager;
import team.creative.littletiles.server.level.little.LittleServerChunkCache;

public class LittleChunkMap
extends ChunkMap {
    private LittleServerChunkCache chunkCache;
    private ChunkScanAccess fakeAccess;
    private DistanceManager distanceManager;
    private ThreadedLevelLightEngine lightEngine;
    private ChunkTaskPriorityQueueSorter queueSorter;

    public LittleChunkMap(ServerLevel level, LevelStorageSource.LevelStorageAccess access, DataFixer fixer, StructureTemplateManager templateManager, Executor exe, BlockableEventLoop<Runnable> loop, LightChunkGetter lightGetter, ChunkGenerator generator, ChunkProgressListener progress, ChunkStatusUpdateListener status, Supplier<DimensionDataStorage> supplier, int viewDistance, boolean sync) {
        super(level, access, fixer, templateManager, exe, loop, lightGetter, generator, progress, status, supplier, viewDistance, sync);
    }

    public void init(ServerLevel level, LittleServerChunkCache chunkCache, LightChunkGetter lightGetter, Executor exe) {
        this.chunkCache = chunkCache;
        this.fakeAccess = (pos, visitor) -> CompletableFuture.runAsync(() -> {});
        ProcessorMailbox mailLight = ProcessorMailbox.create((Executor)exe, (String)"light");
        this.queueSorter = new ChunkTaskPriorityQueueSorter((List)ImmutableList.of((Object)mailLight), exe, Integer.MAX_VALUE);
        this.lightEngine = new ThreadedLevelLightEngine(lightGetter, (ChunkMap)this, level.dimensionType().hasSkyLight(), mailLight, this.queueSorter.getProcessor((ProcessorHandle)mailLight, false));
        this.distanceManager = (DistanceManager)CreativeHackery.allocateInstance(LittleDistanceManager.class);
    }

    public LittleChunkHolder addChunkLevel(LittleChunkHolder holder) {
        holder.chunk.setLoaded(true);
        holder.chunk.registerAllBlockEntitiesAfterLevelLoad();
        holder.chunk.registerTickContainerInLevel(this.chunkCache.level);
        return holder;
    }

    public LittleChunkHolder createHolder(ChunkPos pos) {
        return this.addChunkLevel(new LittleChunkHolder(this.chunkCache.level, pos, (LevelLightEngine)this.lightEngine));
    }

    public LittleChunkHolder createHolder(ChunkPos pos, CompoundTag nbt) {
        return this.addChunkLevel(new LittleChunkHolder(LittleChunkSerializer.read((LittleLevel)this.chunkCache.level, nbt), (LevelLightEngine)this.lightEngine));
    }

    public ClientboundLevelChunkWithLightPacket createPacket(LevelChunk chunk) {
        return new ClientboundLevelChunkWithLightPacket(chunk, (LevelLightEngine)this.lightEngine, (BitSet)null, (BitSet)null);
    }

    protected ChunkHolder getUpdatingChunkIfPresent(long pos) {
        throw new UnsupportedOperationException();
    }

    public ChunkHolder getVisibleChunkIfPresent(long pos) {
        throw new UnsupportedOperationException();
    }

    protected IntSupplier getChunkQueueLevel(long pos) {
        return () -> ChunkTaskPriorityQueue.PRIORITY_LEVEL_COUNT - 1;
    }

    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    public String getChunkDebugData(ChunkPos pos) {
        return "";
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException exception, String message) {
        CrashReport crashreport = CrashReport.forThrowable((Throwable)exception, (String)"Chunk loading");
        CrashReportCategory crashreportcategory = crashreport.addCategory("Chunk loading");
        crashreportcategory.setDetail("Details", (Object)message);
        return new ReportedException(crashreport);
    }

    public void close() throws IOException {
    }

    public boolean hasWork() {
        return false;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder holder) {
        return null;
    }

    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder holder, ChunkStep step, StaticCache2D<GenerationChunkHolder> cache) {
        return null;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        return null;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder p_143110_) {
        return null;
    }

    public int getTickingGenerated() {
        return 0;
    }

    public int size() {
        return this.chunkCache.getLoadedChunksCount();
    }

    public DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos pos) {
        return Collections.EMPTY_LIST;
    }

    public void move(ServerPlayer player) {
    }

    public List<ServerPlayer> getPlayers(ChunkPos pos, boolean all) {
        return Collections.EMPTY_LIST;
    }

    public String getStorageName() {
        return "";
    }

    public boolean isOldChunkAround(ChunkPos pos, int range) {
        return false;
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        return null;
    }

    public CompletableFuture<Void> write(ChunkPos pos, CompoundTag tag) {
        return null;
    }

    public void flushWorker() {
    }

    public ChunkScanAccess chunkScanner() {
        return this.fakeAccess;
    }

    public void tick() {
    }

    public void removeEntity(Entity entity) {
    }

    public void addEntity(Entity entity) {
    }

    protected void broadcastAndSend(Entity entity, Packet<?> packet) {
        LittleLevel level = (LittleLevel)this.chunkCache.getLevel();
        LittleTiles.NETWORK.sendToClientTrackingAndSelf((CreativePacket)new LittleVanillaPacket(level, packet), level.getHolder());
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        LittleLevel level = (LittleLevel)this.chunkCache.getLevel();
        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new LittleVanillaPacket(level, packet), level.getHolder());
    }
}

