/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import com.mojang.datafixers.DataFixer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.mixin.server.level.ServerChunkCacheAccessor;
import team.creative.littletiles.server.level.little.LittleChunkHolder;
import team.creative.littletiles.server.level.little.LittleChunkMap;
import team.creative.littletiles.server.level.little.LittleDistanceManager;
import team.creative.littletiles.server.level.little.LittleServerLevel;

public class LittleServerChunkCache
extends ServerChunkCache
implements Iterable<LevelChunk> {
    private final HashMap<Long, LittleChunkHolder> chunks = new HashMap();
    private final MainThreadExecutor mainThreadProcessor;

    public LittleServerChunkCache(LittleServerLevel level, LevelStorageSource.LevelStorageAccess storageAccess, DataFixer dataFixer, StructureTemplateManager structureTemplate, Executor exe, ChunkGenerator generator, int viewDistance, int simulationDistance, boolean sync, ChunkProgressListener progress, ChunkStatusUpdateListener status, Supplier<DimensionDataStorage> supplier) {
        super((ServerLevel)level, storageAccess, dataFixer, structureTemplate, exe, generator, viewDistance, simulationDistance, sync, progress, status, supplier);
        this.mainThreadProcessor = new MainThreadExecutor((Level)level);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private ChunkResult<ChunkAccess> getChunkMainThread(int x, int z, boolean create) {
        LittleChunkHolder holder = this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (holder == null && create) {
            holder = ((LittleChunkMap)this.chunkMap).createHolder(new ChunkPos(x, z));
            this.chunks.put(ChunkPos.asLong((int)x, (int)z), holder);
        }
        return ChunkResult.of((Object)holder.chunk);
    }

    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus status, boolean create) {
        if (Thread.currentThread() != ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(x, z, status, create), (Executor)((Object)this.mainThreadProcessor)).join();
        }
        LittleChunkHolder holder = this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (holder == null && create) {
            holder = ((LittleChunkMap)this.chunkMap).createHolder(new ChunkPos(x, z));
            this.chunks.put(ChunkPos.asLong((int)x, (int)z), holder);
        }
        return holder == null ? null : holder.chunk;
    }

    @Nullable
    public LevelChunk getChunkNow(int x, int z) {
        if (Thread.currentThread() != ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            return null;
        }
        return this.getChunk(x, z, true);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int x, int z, ChunkStatus status, boolean create) {
        CompletableFuture<ChunkResult<ChunkAccess>> completablefuture;
        if (Thread.currentThread() == ((ServerChunkCacheAccessor)((Object)this)).getMainThread()) {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkMainThread(x, z, create));
            this.mainThreadProcessor.managedBlock(completablefuture::isDone);
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkMainThread(x, z, create), (Executor)((Object)this.mainThreadProcessor));
        }
        return completablefuture;
    }

    public boolean hasChunk(int x, int z) {
        return this.chunks.containsKey(ChunkPos.asLong((int)x, (int)z));
    }

    public LightChunk getChunkForLighting(int x, int z) {
        return this.getChunk(x, z, ChunkStatus.EMPTY, false);
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    public boolean isPositionTicking(long pos) {
        if (!this.level.shouldTickBlocksAt(pos)) {
            return false;
        }
        return this.chunks.containsKey(pos);
    }

    public void save(boolean all) {
    }

    public void close() throws IOException {
    }

    public void tick(BooleanSupplier running, boolean chunks) {
        this.level.getProfiler().push("purge");
        ((LittleDistanceManager)this.chunkMap.getDistanceManager()).purgeStaleTickets();
        this.runDistanceManagerUpdates2();
        this.level.getProfiler().popPush("chunks");
        if (chunks) {
            this.tickChunks();
        }
        this.level.getProfiler().pop();
    }

    private void tickChunks() {
        if (this.level.isDebug()) {
            ((LittleChunkMap)this.chunkMap).tick();
            return;
        }
        ProfilerFiller profilerfiller = this.level.getProfiler();
        profilerfiller.push("pollingChunks");
        int k = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        profilerfiller.popPush("tick");
        for (Map.Entry<Long, LittleChunkHolder> entry : this.chunks.entrySet()) {
            if (!this.level.shouldTickBlocksAt(entry.getKey().longValue())) continue;
            this.level.tickChunk(entry.getValue().chunk, k);
        }
        for (LittleChunkHolder holder : this.chunks.values()) {
            holder.broadcastChanges();
        }
        profilerfiller.pop();
        ((LittleChunkMap)this.chunkMap).tick();
    }

    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return null;
    }

    public RandomState randomState() {
        return null;
    }

    public int getLoadedChunksCount() {
        return this.chunks.size();
    }

    public void blockChanged(BlockPos pos) {
        LittleChunkHolder chunkholder = this.chunks.get(ChunkPos.asLong((BlockPos)pos));
        if (chunkholder != null) {
            chunkholder.blockChanged(pos);
        }
    }

    public void onLightUpdate(LightLayer layer, SectionPos pos) {
        this.mainThreadProcessor.execute(() -> {
            LittleChunkHolder chunkholder = this.chunks.get(ChunkPos.asLong((int)pos.x(), (int)pos.z()));
            if (chunkholder != null) {
                chunkholder.sectionLightChanged(layer, pos.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key) {
        this.chunkMap.getDistanceManager().addRegionTicket(type, pos, level, key);
    }

    public <T> void addRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key, boolean forceTicks) {
        this.chunkMap.getDistanceManager().addRegionTicket(type, pos, level, key, forceTicks);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key) {
        this.chunkMap.getDistanceManager().removeRegionTicket(type, pos, level, key);
    }

    public <T> void removeRegionTicket(TicketType<T> type, ChunkPos pos, int level, T key, boolean forceTicks) {
        this.chunkMap.getDistanceManager().removeRegionTicket(type, pos, level, key, forceTicks);
    }

    public void updateChunkForced(ChunkPos pos, boolean added) {
        ((LittleDistanceManager)this.chunkMap.getDistanceManager()).updateChunkForced(pos, added);
    }

    public void move(ServerPlayer player) {
        ((LittleChunkMap)this.chunkMap).move(player);
    }

    public void removeEntity(Entity entity) {
        ((LittleChunkMap)this.chunkMap).removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        ((LittleChunkMap)this.chunkMap).addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        ((LittleChunkMap)this.chunkMap).broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        ((LittleChunkMap)this.chunkMap).broadcast(entity, packet);
    }

    public void setViewDistance(int distance) {
    }

    public void setSimulationDistance(int distance) {
    }

    public void setSpawnSettings(boolean spawnEnemies, boolean spawnFriendlies) {
    }

    public String getChunkDebugData(ChunkPos pos) {
        return "";
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return null;
    }

    public void removeTicketsOnClosing() {
        this.chunkMap.getDistanceManager().removeTicketsOnClosing();
    }

    public void loadLevelChunk(ChunkPos pos, CompoundTag tag) {
        this.chunks.put(pos.toLong(), ((LittleChunkMap)this.chunkMap).createHolder(pos, tag));
    }

    public Iterable<LevelChunk> all() {
        return this;
    }

    @Override
    public Iterator<LevelChunk> iterator() {
        return new FunctionIterator(this.chunks.values().iterator(), x -> x.chunk);
    }

    public boolean runDistanceManagerUpdates2() {
        this.chunkMap.getDistanceManager().runAllUpdates(this.chunkMap);
        return false;
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return null;
    }

    public final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        public MainThreadExecutor(Level level) {
            super("Chunk source main thread executor for " + String.valueOf(level.dimension().location()));
        }

        protected Runnable wrapRunnable(Runnable p_8506_) {
            return p_8506_;
        }

        protected boolean shouldRun(Runnable p_8504_) {
            return true;
        }

        protected boolean scheduleExecutables() {
            return true;
        }

        protected Thread getRunningThread() {
            return ((ServerChunkCacheAccessor)((Object)LittleServerChunkCache.this)).getMainThread();
        }

        protected void doRunTask(Runnable run) {
            LittleServerChunkCache.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(run);
        }

        public boolean pollTask() {
            if (LittleServerChunkCache.this.runDistanceManagerUpdates2()) {
                return true;
            }
            LittleServerChunkCache.this.getLightEngine().tryScheduleUpdate();
            return super.pollTask();
        }
    }
}

