package team.creative.littletiles.common.action;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadePreview;
import team.creative.littletiles.common.structure.registry.premade.LittlePremadeRegistry;

public class LittleActionPlace extends LittleAction<Boolean> {
    
    public PlacementPreview preview;
    public PlaceAction action;
    
    public transient PlacementResult result;
    @OnlyIn(Dist.CLIENT)
    public transient LittleGroupAbsolute destroyed;
    public transient boolean toVanilla = true;
    
    public LittleActionPlace() {}
    
    public LittleActionPlace(PlaceAction action, PlacementPreview preview) {
        this.action = action;
        this.preview = preview;
    }
    
    @Override
    public boolean canBeReverted() {
        return true;
    }
    
    @Override
    public LittleAction revert(Player player) throws LittleActionException {
        if (result == null)
            return null;
        result.placedBoxes.convertToSmallest();
        
        if (destroyed != null) {
            destroyed.convertToSmallest();
            return new LittleActions(new LittleActionDestroyBoxes(preview.levelUUID, result.placedBoxes.copy()), new LittleActionPlace(PlaceAction.ABSOLUTE, PlacementPreview.load(
                preview.levelUUID, PlacementMode.FILL, destroyed)));
        }
        return new LittleActionDestroyBoxes(preview.levelUUID, result.placedBoxes.copy());
    }
    
    @Override
    public boolean wasSuccessful(Boolean result) {
        return result;
    }
    
    @Override
    public Boolean failed() {
        return false;
    }
    
    @Override
    public Boolean action(Player player) throws LittleActionException {
        Level level = player.level();
        
        if (!isAllowedToInteract(level, player, preview.position.getPos(), true, preview.position.facing)) {
            sendBlockResetToClient(level, player, preview);
            return false;
        }
        
        if (action == PlaceAction.PLACER) {
            ItemStack stack = player.getMainHandItem();
            if (!(stack.getItem() instanceof ILittlePlacer))
                return false;
            PlacementResult tiles = placeTile(player, stack, preview);
            
            if (!level.isClientSide)
                player.inventoryMenu.broadcastChanges();
            return tiles != null;
        }
        
        LittleInventory inventory = new LittleInventory(player);
        if (canDrainIngredientsBeforePlacing(player, inventory)) {
            Placement placement = new Placement(player, preview);
            result = placement.place();
            
            if (result != null) {
                drainIngredientsAfterPlacing(player, inventory, result, preview.previews);
                
                if (!level.isClientSide) {
                    checkAndGive(player, inventory, getIngredients(player.registryAccess(), placement.unplaceableTiles));
                    checkAndGive(player, inventory, placement.overflow());
                }
                
                if (!placement.removedTiles.isEmpty() && player.level().isClientSide)
                    destroyed = placement.removedTiles.copy();
                
                if (toVanilla)
                    for (BETiles be : result.blocks)
                        be.convertBlockToVanilla();
                    
            }
            
            return result != null;
        }
        return false;
    }
    
    public PlacementResult placeTile(Player player, ItemStack stack, PlacementPreview preview) throws LittleActionException {
        ILittlePlacer iTile = (ILittlePlacer) stack.getItem();
        ItemStack toPlace = stack.copy();
        
        LittleInventory inventory = new LittleInventory(player);
        
        if (needIngredients(player))
            if (!iTile.containsIngredients(stack))
                canTake(player, inventory, preview.getBeforePlaceIngredients(player.registryAccess()));
            
        isAllowedToUse(player, preview.previews);
        isAllowedToUse(player, preview.position);
        
        Placement placement = new Placement(player, preview).setStack(toPlace);
        result = placement.place();
        
        if (result != null) {
            if (needIngredients(player)) {
                checkAndGive(player, inventory, placement.overflow());
                
                if (iTile.containsIngredients(stack)) {
                    stack.shrink(1);
                    checkAndGive(player, inventory, getIngredients(player.registryAccess(), placement.unplaceableTiles));
                } else {
                    LittleIngredients ingredients = LittleIngredient.extractStructureOnly(player.registryAccess(), preview.previews);
                    ingredients.add(result.ingredients.copy());
                    take(player, inventory, ingredients);
                }
            }
            
            if (!placement.removedTiles.isEmpty() && player.level().isClientSide)
                destroyed = placement.removedTiles.copy();
        }
        return result;
    }
    
    protected boolean canDrainIngredientsBeforePlacing(Player player, LittleInventory inventory) throws LittleActionException {
        if (action != PlaceAction.PREMADE)
            return canTake(player, inventory, preview.getBeforePlaceIngredients(player.registryAccess()));
        
        LittlePremadePreview entry = LittlePremadeRegistry.getPreview(preview.previews.getStructureId());
        
        try {
            inventory.startSimulation();
            return take(player, inventory, entry.stack) && entry.arePreviewsEqual(preview.previews);
        } finally {
            inventory.stopSimulation();
        }
    }
    
    protected void drainIngredientsAfterPlacing(Player player, LittleInventory inventory, PlacementResult placedTiles, LittleGroup previews) throws LittleActionException {
        if (action == PlaceAction.PREMADE) {
            take(player, inventory, LittlePremadeRegistry.getPreview(previews.getStructureId()).stack);
            return;
        }
        LittleIngredients ingredients = LittleIngredient.extractStructureOnly(player.registryAccess(), previews);
        ingredients.add(getIngredients(player.registryAccess(), placedTiles.placedPreviews));
        take(player, inventory, ingredients);
    }
    
    @Override
    public LittleActionPlace mirror(Axis axis, LittleBoxAbsolute box) {
        PlacementPreview preview = this.preview.copy();
        preview.mirror(axis, box);
        return new LittleActionPlace(action, preview);
    }
    
    public static enum PlaceAction {
        
        PLACER,
        ABSOLUTE,
        PREMADE;
        
    }
    
}
