package team.creative.littletiles.common.structure.type;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.map.ChunkLayerMapList;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.client.render.tile.LittleRenderBoxItem;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittleItemHolder extends LittleStructure {
    
    @StructureDirectional(color = ColorUtils.CYAN)
    public StructureRelative frame;
    
    @StructureDirectional
    public Facing facing;
    
    @StructureDirectional
    public Vec3f topRight;
    
    public ItemStack stack;
    
    public LittleItemHolder(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }
    
    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        stack = ItemStack.parseOptional(provider, nbt.getCompound("stack"));
    }
    
    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("stack", stack.saveOptional(provider));
    }
    
    @Override
    public boolean canInteract() {
        return true;
    }
    
    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide)
            return InteractionResult.SUCCESS;
        ItemStack mainStack = player.getMainHandItem();
        if (mainStack.isEmpty() && !stack.isEmpty()) {
            if (player.getInventory().add(player.getInventory().selected, stack))
                stack = ItemStack.EMPTY;
            updateInput();
            updateStructure(true);
        } else if (stack.isEmpty()) {
            stack = mainStack.copy();
            if (!player.getAbilities().instabuild)
                mainStack.shrink(1);
            updateInput();
            updateStructure(true);
        }
        return InteractionResult.SUCCESS;
    }
    
    public void updateInput() {
        getInput(0).updateState(SignalState.of(!stack.isEmpty()));
    }
    
    @Override
    public void getRenderingBoxes(BlockPos pos, ChunkLayerMapList<LittleRenderBox> cubes) {
        LittleBox littleBox = frame.getBox();
        AlignedBox box = littleBox.getBox(frame.getGrid());
        if (!stack.isEmpty())
            cubes.add(RenderType.cutout(), new LittleRenderBoxItem(this, box, littleBox));
    }
    
}
