/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.api.common.tool;

import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.item.component.MatrixDataComponent;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public interface ILittlePlacer
extends ILittleTool {
    public boolean hasTiles(ItemStack var1);

    public LittleGroup getTiles(ItemStack var1);

    public LittleGroup getLow(ItemStack var1);

    default public LittleGroup get(ItemStack stack, boolean low) {
        if (low) {
            return this.getLow(stack);
        }
        return this.getTiles(stack);
    }

    default public IntMatrix3c getMatrix(ItemStack stack) {
        if (stack.has(LittleTilesRegistry.MATRIX)) {
            return ((MatrixDataComponent)stack.get(LittleTilesRegistry.MATRIX)).getMatrix();
        }
        return IntMatrix3c.IDENTIY;
    }

    default public void transformMatrix(ItemStack stack, IntMatrix3c matrix) {
        IntMatrix3 m = new IntMatrix3(matrix, this.getMatrix(stack));
        if (m.isIdentity()) {
            stack.remove(LittleTilesRegistry.MATRIX);
        } else {
            stack.set(LittleTilesRegistry.MATRIX, (Object)MatrixDataComponent.of((IntMatrix3c)m));
        }
    }

    public boolean containsIngredients(ItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    default public PlacementMode getPlacementMode(ItemStack stack) {
        return LittleTilesClient.ACTION_HANDLER.setting.placementMode();
    }

    default public boolean canSnapToGrid(ItemStack stack) {
        return true;
    }

    default public boolean snapToGridByDefault(ItemStack stack) {
        return false;
    }

    default public LittleVecGrid getCachedSize(ItemStack stack) {
        return null;
    }

    default public LittleVecGrid getCachedMin(ItemStack stack) {
        return null;
    }
}

