/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.level.little;

import java.util.HashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import team.creative.littletiles.client.level.little.LittleClientLevel;
import team.creative.littletiles.mixin.client.level.ClientChunkCacheAccessor;

public class LittleClientChunkCache
extends ClientChunkCache {
    private HashMap<Long, LevelChunk> chunks;

    public LittleClientChunkCache(ClientLevel level, int distance) {
        super(level, distance);
    }

    public void init(LittleClientLevel level) {
        ((ClientChunkCacheAccessor)((Object)this)).setLevel(level);
        ((ClientChunkCacheAccessor)((Object)this)).setLightEngine(new LevelLightEngine((LightChunkGetter)this, true, level.dimensionType().hasSkyLight()));
        this.chunks = new HashMap();
    }

    public void addLoadedChunk(LevelChunk chunk) {
        this.chunks.put(chunk.getPos().toLong(), chunk);
        this.getLevel().onChunkLoaded(chunk);
    }

    public Iterable<LevelChunk> all() {
        return this.chunks.values();
    }

    public void drop(ChunkPos pos) {
    }

    @Nullable
    public LevelChunk getChunk(int x, int z, ChunkStatus status, boolean create) {
        LevelChunk chunk = this.chunks.get(ChunkPos.asLong((int)x, (int)z));
        if (chunk == null && create) {
            chunk = new LevelChunk((Level)this.getLevel(), new ChunkPos(x, z));
            this.chunks.put(ChunkPos.asLong((int)x, (int)z), chunk);
        }
        return chunk;
    }

    public LevelChunk replaceWithPacketData(int x, int z, FriendlyByteBuf buffer, CompoundTag tag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        LevelChunk chunk = this.getChunk(x, z, ChunkStatus.FULL, true);
        chunk.replaceWithPacketData(buffer, tag, consumer);
        this.getLevel().onChunkLoaded(chunk);
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
        return chunk;
    }

    public LittleClientLevel getLevel() {
        return (LittleClientLevel)super.getLevel();
    }

    public void tick(BooleanSupplier running, boolean chunks) {
    }

    public void updateViewCenter(int x, int z) {
    }

    public void updateViewRadius(int distance) {
    }

    public String gatherStats() {
        return "" + this.getLoadedChunksCount();
    }

    public int getLoadedChunksCount() {
        return this.chunks.size();
    }

    public void onLightUpdate(LightLayer layer, SectionPos pos) {
        this.getLevel().renderManager.setSectionDirty(pos.x(), pos.y(), pos.z());
    }

    public void addEntity(Entity entity) {
    }

    public void removeEntity(Entity entity) {
    }
}

