/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.system.MemoryUtil;
import team.creative.littletiles.client.mod.sodium.SodiumInteractor;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumBufferUploader;
import team.creative.littletiles.client.mod.sodium.data.LittleQuadView;

public class SodiumAppendChunkBufferUploader
implements SodiumBufferUploader {
    private ByteBuffer[] buffers = new ByteBuffer[ModelQuadFacing.COUNT];
    private NativeBuffer buffer;
    private int[] ranges = new int[ModelQuadFacing.COUNT];
    private List<TextureAtlasSprite> sprites;
    private TranslucentGeometryCollector collector;

    public void set(long data, GlVertexFormat format, long offset, ByteBuffer exisitingData, int extraLength, int[] extraLengthFacing, TextureAtlasSprite[] existing) {
        int i;
        this.buffer = new NativeBuffer((exisitingData != null ? exisitingData.limit() : 0) + extraLength);
        ByteBuffer buffer = this.buffer.getDirectBuffer();
        int currentOffset = 0;
        for (i = 0; i < this.buffers.length; ++i) {
            int originalStart = (int)((SectionRenderDataUnsafe.getVertexOffset((long)data, (int)i) - offset) * (long)format.getStride());
            int originalLength = (int)(SectionRenderDataUnsafe.getElementCount((long)data, (int)i) / 6L * 4L * (long)format.getStride());
            int newStart = originalStart + currentOffset;
            int newLength = originalLength + extraLengthFacing[i];
            this.buffers[i] = buffer.slice(newStart, newLength);
            this.buffers[i].put(0, exisitingData, originalStart, originalLength);
            this.buffers[i].position(originalLength);
            currentOffset += extraLengthFacing[i];
            this.ranges[i] = newLength / format.getStride();
        }
        if (existing != null) {
            this.sprites = new ArrayList<TextureAtlasSprite>();
            for (i = 0; i < existing.length; ++i) {
                this.sprites.add(existing[i]);
            }
        }
    }

    public void clear() {
        Arrays.fill(this.buffers, null);
        this.buffer.free();
        this.buffer = null;
    }

    @Override
    public void addTexture(TextureAtlasSprite texture) {
        if (this.sprites == null) {
            this.sprites = new ArrayList<TextureAtlasSprite>();
        }
        if (!this.sprites.contains(texture)) {
            this.sprites.add(texture);
        }
    }

    @Override
    public int uploadIndex() {
        return this.buffers[ModelQuadFacing.UNASSIGNED.ordinal()].position();
    }

    @Override
    public void upload(ByteBuffer buffer) {
        this.buffers[ModelQuadFacing.UNASSIGNED.ordinal()].put(buffer);
        buffer.rewind();
    }

    @Override
    public int uploadIndex(int facing) {
        return this.buffers[facing].position();
    }

    @Override
    public void upload(int facing, ByteBuffer buffer) {
        this.buffers[facing].put(buffer);
        buffer.rewind();
    }

    @Override
    public boolean hasFacingSupport() {
        return true;
    }

    public TextureAtlasSprite[] sprites() {
        if (this.sprites == null) {
            return null;
        }
        return this.sprites.toArray(new TextureAtlasSprite[this.sprites.size()]);
    }

    public int[] ranges() {
        return this.ranges;
    }

    public NativeBuffer buffer() {
        return this.buffer;
    }

    public void appendVanillaTranslucentData(ByteBuffer buffer) {
        long ptr;
        long end = ptr + (long)buffer.remaining();
        LittleQuadView quad = new LittleQuadView();
        ChunkVertexType type = SodiumInteractor.getVertexType();
        int stride = type.getVertexFormat().getStride();
        ModelQuadFacing facing = ModelQuadFacing.UNASSIGNED;
        for (ptr = MemoryUtil.memAddress((ByteBuffer)buffer); ptr < end; ptr += (long)(stride * 4)) {
            quad.readVertices(ptr, 0, stride, facing);
            this.collector.appendQuad(quad.getPackedNormal(), quad.getVertices(), quad.quadFacing());
        }
    }

    @Override
    public boolean isSorted() {
        return this.collector != null;
    }

    @Override
    public TranslucentGeometryCollector getTranslucentCollector() {
        return this.collector;
    }

    @Override
    public void setTranslucentCollector(TranslucentGeometryCollector collector) {
        this.collector = collector;
    }
}

