/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.buffer;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataUnsafe;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;

public class SodiumChunkBufferDownloader
implements ChunkBufferDownloader {
    private ByteBuffer[] buffers = new ByteBuffer[ModelQuadFacing.COUNT];

    public void set(long data, GlVertexFormat format, long offset, ByteBuffer buffer) {
        for (int i = 0; i < this.buffers.length; ++i) {
            long count = SectionRenderDataUnsafe.getElementCount((long)data, (int)i);
            this.buffers[i] = count > 0L ? buffer.slice((int)((SectionRenderDataUnsafe.getVertexOffset((long)data, (int)i) - offset) * (long)format.getStride()), (int)(count / 6L * 4L * (long)format.getStride())) : null;
        }
    }

    public void clear() {
        Arrays.fill(this.buffers, null);
    }

    @Override
    public ByteBuffer downloaded() {
        return this.downloaded(ModelQuadFacing.UNASSIGNED.ordinal());
    }

    @Override
    public boolean hasFacingSupport() {
        return true;
    }

    @Override
    public ByteBuffer downloaded(int facing) {
        return this.buffers[facing];
    }
}

