/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.data;

import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.NormalHelper;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;
import team.creative.littletiles.client.mod.sodium.SodiumInteractor;

public class LittleQuadView
implements QuadView {
    private final ChunkVertexEncoder.Vertex[] vertices;
    private Vector3f normal = new Vector3f();
    private Direction nominalFace;
    private int packedNormal;
    private ModelQuadFacing quadFacing;

    public LittleQuadView() {
        this(ChunkVertexEncoder.Vertex.uninitializedQuad());
    }

    public LittleQuadView(ChunkVertexEncoder.Vertex[] vertices) {
        this.vertices = vertices;
    }

    public void readVertices(long ptr, int posPtrOffset, int stride, ModelQuadFacing facing) {
        for (int j = 0; j < 4; ++j) {
            int hi = MemoryUtil.memGetInt((long)(ptr + (long)posPtrOffset));
            int lo = MemoryUtil.memGetInt((long)(ptr + (long)posPtrOffset + 4L));
            this.vertices[j].x = SodiumInteractor.unpackPositionX(hi, lo);
            this.vertices[j].y = SodiumInteractor.unpackPositionY(hi, lo);
            this.vertices[j].z = SodiumInteractor.unpackPositionZ(hi, lo);
            ptr += (long)stride;
        }
        this.nominalFace = SodiumInteractor.toDirection(facing);
        NormalHelper.computeFaceNormal((Vector3f)this.normal, (QuadView)this);
        this.quadFacing = ModelQuadFacing.fromNormal((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
        this.packedNormal = NormI8.pack((Vector3fc)this.normal);
    }

    public ChunkVertexEncoder.Vertex[] getVertices() {
        return this.vertices;
    }

    public int getPackedNormal() {
        return this.packedNormal;
    }

    public float x(int vertexIndex) {
        return this.vertices[vertexIndex].x;
    }

    public float y(int vertexIndex) {
        return this.vertices[vertexIndex].y;
    }

    public float z(int vertexIndex) {
        return this.vertices[vertexIndex].z;
    }

    public ModelQuadFacing quadFacing() {
        return this.quadFacing;
    }

    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return switch (coordinateIndex) {
            case 0 -> this.vertices[vertexIndex].x;
            case 1 -> this.vertices[vertexIndex].y;
            case 2 -> this.vertices[vertexIndex].z;
            default -> throw new UnsupportedOperationException();
        };
    }

    public Vector3f copyPos(int vertexIndex, @Nullable Vector3f target) {
        throw new UnsupportedOperationException();
    }

    public int color(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public float u(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public float v(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public Vector2f copyUv(int vertexIndex, @Nullable Vector2f target) {
        throw new UnsupportedOperationException();
    }

    public int lightmap(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean hasNormal(int vertexIndex) {
        return false;
    }

    public float normalX(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public float normalY(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    public float normalZ(int vertexIndex) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Vector3f copyNormal(int vertexIndex, @Nullable Vector3f target) {
        throw new UnsupportedOperationException();
    }

    public Vector3f faceNormal() {
        return this.normal;
    }

    public RenderMaterial material() {
        throw new UnsupportedOperationException();
    }

    public int colorIndex() {
        throw new UnsupportedOperationException();
    }

    public int tag() {
        throw new UnsupportedOperationException();
    }

    public void toVanilla(int[] target, int targetIndex) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Direction cullFace() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Direction lightFace() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Direction nominalFace() {
        return this.nominalFace;
    }
}

