/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.entity;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import team.creative.littletiles.client.mod.sodium.entity.CompiledSodiumSection;
import team.creative.littletiles.client.mod.sodium.entity.LittleSodiumSection;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationRenderManagerSodium
extends LittleEntityRenderManager<LittleAnimationEntity> {
    private Long2ObjectMap<LittleSodiumSection> sections = new Long2ObjectArrayMap();
    protected List<BlockEntity> renderableBlockEntities = new ArrayList<BlockEntity>();
    protected final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.CHUNK_BUFFER_LAYERS.size());
    protected boolean needsUpdate = false;
    private GlVertexAttributeBinding[] vertexAttributeBindings;
    private GlVertexFormat format;

    public LittleAnimationRenderManagerSodium(LittleAnimationEntity entity) {
        super(entity);
    }

    public void prepare(GlVertexAttributeBinding[] vertexAttributeBindings, GlVertexFormat format) {
        this.vertexAttributeBindings = vertexAttributeBindings;
        this.format = format;
    }

    public GlVertexAttributeBinding[] getBindings() {
        return this.vertexAttributeBindings;
    }

    public GlVertexFormat getFormat() {
        return this.format;
    }

    @Override
    public RenderChunkExtender getRenderChunk(long pos) {
        return this.getOrCreateSection(pos);
    }

    private LittleSodiumSection getOrCreateSection(long pos) {
        LittleSodiumSection section = (LittleSodiumSection)this.sections.get(pos);
        if (section == null) {
            section = new LittleSodiumSection(this, pos);
            this.sections.put(pos, (Object)section);
        }
        return section;
    }

    @Override
    public void compileSections(Camera camera) {
        if (!this.needsUpdate || this.vertexAttributeBindings == null) {
            return;
        }
        this.needsUpdate = false;
        this.hasBlocks.clear();
        this.renderableBlockEntities.clear();
        RebuildTask rebuild = new RebuildTask();
        Vec3 cam = camera.getPosition();
        rebuild.compile((float)cam.x, (float)cam.y, (float)cam.z);
        this.globalBlockEntities.clear();
        this.globalBlockEntities.addAll(rebuild.globalBlockEntities);
        this.renderableBlockEntities = rebuild.blockEntities;
        LongArraySet original = new LongArraySet(this.sections.keySet());
        if (!rebuild.isEmpty()) {
            for (Long2ObjectMap.Entry entry : rebuild.compiledSections.long2ObjectEntrySet()) {
                original.remove(entry.getLongKey());
                ((CompiledSodiumSection)entry.getValue()).upload(this.hasBlocks);
            }
            VertexBuffer.unbind();
        }
        if (!original.isEmpty()) {
            LongIterator iterator = original.longIterator();
            while (iterator.hasNext()) {
                long pos = iterator.nextLong();
                LittleSodiumSection s = (LittleSodiumSection)this.sections.remove(pos);
                if (s == null) continue;
                s.unload();
            }
        }
    }

    @Override
    public boolean isSmall() {
        return true;
    }

    @Override
    protected void renderAllBlockEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        if (this.renderableBlockEntities != null) {
            for (BlockEntity blockEntity : this.renderableBlockEntities) {
                this.renderBlockEntity(blockEntity, pose, frustum, cam, frameTime, bufferSource);
            }
        }
    }

    @Override
    public void renderChunkLayer(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, Uniform offset) {
        throw new UnsupportedOperationException();
    }

    public void renderChunkLayerSodium(RenderType layer, PoseStack pose, double camx, double camy, double camz, Matrix4fc projectionMatrix, ChunkShaderInterface shader, CameraTransform camera) {
        if (this.hasBlocks.contains(layer)) {
            for (LittleSodiumSection s : this.sections.values()) {
                s.renderChunkLayerSodium(layer, shader, camera);
            }
        }
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LittleAnimationLevel getLevel() {
        return (LittleAnimationLevel)super.getLevel();
    }

    public void setHasBlock(RenderType layer) {
        this.hasBlocks.add(layer);
    }

    @Override
    protected void setBlockDirty(BlockPos pos, boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void setBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.needsUpdate = true;
    }

    @Override
    public void setBlockDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        this.needsUpdate = true;
    }

    @Override
    protected void setSectionDirty(int x, int y, int z, boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void unload() {
        super.unload();
        for (LittleSodiumSection s : this.sections.values()) {
            s.unload();
        }
    }

    @Override
    public void allChanged() {
        super.allChanged();
        for (LittleSodiumSection s : this.sections.values()) {
            s.unload();
        }
        this.sections.clear();
        for (BETiles block : this.getLevel()) {
            block.render.sectionUpdate(SectionPos.asLong((BlockPos)block.getBlockPos()));
        }
        this.needsUpdate = true;
        this.vertexAttributeBindings = null;
        this.format = null;
    }

    private class RebuildTask {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Long2ObjectMap<CompiledSodiumSection> compiledSections = new Long2ObjectArrayMap();
        private boolean hasRenderData = false;

        private RebuildTask() {
        }

        private void compile(float x, float y, float z) {
            for (BETiles block : LittleAnimationRenderManagerSodium.this.getLevel()) {
                this.handleBlockEntity(block);
            }
            for (CompiledSodiumSection s : this.compiledSections.values()) {
                if (!s.finish()) continue;
                this.hasRenderData = true;
            }
        }

        private void handleBlockEntity(BETiles entity) {
            long pos = SectionPos.asLong((BlockPos)entity.getBlockPos());
            CompiledSodiumSection c = this.getCompiled(pos);
            LittleRenderPipelineType.compileUploaded(pos, entity, x -> c.getOrCreateBuffers((RenderType)x));
            BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entity);
            if (blockentityrenderer != null) {
                if (blockentityrenderer.shouldRenderOffScreen((BlockEntity)entity)) {
                    this.globalBlockEntities.add((BlockEntity)entity);
                } else {
                    this.blockEntities.add((BlockEntity)entity);
                }
            }
        }

        public boolean isEmpty() {
            return !this.hasRenderData && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
        }

        private CompiledSodiumSection getCompiled(long pos) {
            CompiledSodiumSection c = (CompiledSodiumSection)this.compiledSections.get(pos);
            if (c == null) {
                c = new CompiledSodiumSection(LittleAnimationRenderManagerSodium.this.getOrCreateSection(pos));
                this.compiledSections.put(pos, (Object)c);
            }
            return c;
        }
    }
}

