/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.mod.sodium.entity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexAttributeBinding;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.sodium.SodiumInteractor;
import team.creative.littletiles.client.mod.sodium.buffer.RenderedBufferSodium;
import team.creative.littletiles.client.mod.sodium.entity.CompiledSodiumSection;
import team.creative.littletiles.client.mod.sodium.entity.LittleAnimationRenderManagerSodium;
import team.creative.littletiles.client.mod.sodium.renderer.DefaultChunkRendererExtender;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.level.RenderAdditional;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;

public class LittleSodiumSection
implements RenderChunkExtender {
    private final LittleAnimationRenderManagerSodium parent;
    private final SectionPos pos;
    private final BlockPos origin;
    protected final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap();
    private RenderAdditional.SectionAdditional additional;
    public ChunkLayerMap<BufferCollection> lastUploaded;
    private volatile int queued;

    public LittleSodiumSection(LittleAnimationRenderManagerSodium parent, long pos) {
        this.parent = parent;
        this.pos = SectionPos.of((long)pos);
        this.origin = this.pos.origin();
    }

    @Override
    public RenderAdditional.SectionAdditional getAdditional() {
        return this.additional;
    }

    @Override
    public void setAdditional(RenderAdditional.SectionAdditional uploader) {
        this.additional = uploader;
    }

    @Override
    public ChunkLayerMap<BufferCollection> getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public void setLastUploaded(ChunkLayerMap<BufferCollection> uploaded) {
        this.lastUploaded = uploaded;
    }

    @Override
    public int getQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(int queued) {
        this.queued = queued;
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        VertexBuffer buffer = (VertexBuffer)this.buffers.get(layer);
        if (buffer == null) {
            buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            this.buffers.put(layer, (Object)buffer);
        }
        return buffer;
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        this.parent.needsUpdate = true;
    }

    public void upload(CompiledSodiumSection compiled, Set<RenderType> hasBlocks) {
        this.prepareUpload();
        for (Tuple entry : compiled.buffers.tuples()) {
            VertexBuffer buffer = this.getVertexBuffer((RenderType)entry.key);
            if (!buffer.isInvalid() && buffer instanceof VertexBufferExtender) {
                VertexBufferExtender ex = (VertexBufferExtender)buffer;
                buffer.bind();
                ex.setFormat(null);
                int length = ((RenderedBufferSodium)entry.value).byteBuffer().limit();
                this.uploadVertexBuffer(ex, ((RenderedBufferSodium)entry.value).byteBuffer());
                ex.setMode(VertexFormat.Mode.QUADS);
                ex.setIndexCount(ex.getMode().indexCount(length / this.parent.getFormat().getStride()));
                ex.setSequentialIndices(this.uploadIndexBuffer(ex));
                ex.setIndexType(VertexFormat.IndexType.INT);
                ex.setLastUploadedLength(length);
                BufferCollection buffers = compiled.getBuffers((RenderType)entry.key);
                if (buffers != null) {
                    this.uploaded((RenderType)entry.key, buffers);
                }
                try {
                    ((RenderedBufferSodium)entry.value).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                hasBlocks.add((RenderType)entry.key);
                continue;
            }
            LittleTiles.LOGGER.error("Could not upload chunk render data due to invalid buffer");
        }
        VertexBuffer.unbind();
    }

    @Nullable
    private RenderSystem.AutoStorageIndexBuffer uploadIndexBuffer(VertexBufferExtender ex) {
        RenderSystem.AutoStorageIndexBuffer buffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)ex.getMode());
        if (buffer != ex.getSequentialIndices() || !buffer.hasStorage(ex.getIndexCount())) {
            buffer.bind(ex.getIndexCount());
        }
        return buffer;
    }

    private void uploadVertexBuffer(VertexBufferExtender buffer, ByteBuffer byteBuffer) {
        GlStateManager._glBindBuffer((int)34962, (int)buffer.getVertexBufferId());
        for (GlVertexAttributeBinding attrib : this.parent.getBindings()) {
            if (attrib.isIntType()) {
                GL30C.glVertexAttribIPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (int)attrib.getStride(), (long)attrib.getPointer());
            } else {
                GL20C.glVertexAttribPointer((int)attrib.getIndex(), (int)attrib.getCount(), (int)attrib.getFormat(), (boolean)attrib.isNormalized(), (int)attrib.getStride(), (long)attrib.getPointer());
            }
            GL20C.glEnableVertexAttribArray((int)attrib.getIndex());
        }
        RenderSystem.glBufferData((int)34962, (ByteBuffer)byteBuffer, (int)35044);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean appendRenderData(Iterable<? extends LayeredBufferCache> blocks) {
        GlVertexFormat format = SodiumInteractor.getVertexType().getVertexFormat();
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            void var7_11;
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            VertexBuffer uploadBuffer = this.getVertexBuffer(layer);
            if (uploadBuffer == null) {
                return false;
            }
            Object var7_9 = null;
            if (!this.isEmpty(layer)) {
                ByteBuffer byteBuffer = this.downloadUploadedData((VertexBufferExtender)uploadBuffer, 0L, ((VertexBufferExtender)uploadBuffer).getLastUploadedLength());
            }
            ByteBufferBuilder buffer = new ByteBufferBuilder(((var7_11 != null ? var7_11.limit() : 0) + size + DefaultVertexFormat.BLOCK.getVertexSize()) / 6);
            BufferBuilder builder = new BufferBuilder(buffer, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
            if (var7_11 != null) {
                ((ChunkBufferUploader)builder).upload((ByteBuffer)var7_11);
            }
            for (LayeredBufferCache layeredBufferCache : blocks) {
                BufferCache layerData = (BufferCache)layeredBufferCache.get(layer);
                if (layerData == null) continue;
                layerData.upload((ChunkBufferUploader)builder);
            }
            MeshData mesh = builder.build();
            if (!uploadBuffer.isInvalid() && uploadBuffer instanceof VertexBufferExtender) {
                VertexBufferExtender vertexBufferExtender = (VertexBufferExtender)uploadBuffer;
                if (mesh != null) {
                    uploadBuffer.bind();
                    vertexBufferExtender.setFormat(null);
                    ByteBuffer byteBuffer = mesh.vertexBuffer();
                    int length = byteBuffer.limit();
                    this.uploadVertexBuffer(vertexBufferExtender, byteBuffer);
                    vertexBufferExtender.setMode(VertexFormat.Mode.QUADS);
                    vertexBufferExtender.setIndexCount(vertexBufferExtender.getMode().indexCount(length / format.getStride()));
                    vertexBufferExtender.setSequentialIndices(this.uploadIndexBuffer(vertexBufferExtender));
                    vertexBufferExtender.setIndexType(VertexFormat.IndexType.INT);
                    vertexBufferExtender.setLastUploadedLength(length);
                    continue;
                }
            }
            LittleTiles.LOGGER.error("Could not upload chunk render data due to invalid buffer");
        }
        VertexBuffer.unbind();
        return true;
    }

    public void renderChunkLayerSodium(RenderType layer, ChunkShaderInterface shader, CameraTransform camera) {
        VertexBuffer vertexbuffer = (VertexBuffer)this.buffers.get(layer);
        if (vertexbuffer == null) {
            return;
        }
        DefaultChunkRendererExtender.setRenderRegionOffset(shader, this.origin, camera);
        vertexbuffer.bind();
        vertexbuffer.draw();
    }

    @Override
    public void setTransparencyState(MeshData.SortState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return !this.buffers.containsKey(layer);
    }

    @Override
    public void setHasBlock(RenderType layer) {
        this.parent.setHasBlock(layer);
    }

    @Override
    public MeshData.SortState getTransparencyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VertexSorting createVertexSorting(double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    public void unload() {
        this.buffers.forEach(VertexBuffer::close);
    }
}

