/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.client.render.cache.AdditionalBufferReceiver;
import team.creative.littletiles.client.render.cache.IBlockBufferCache;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.AdditionalBuffers;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;

public class BlockBufferCache
implements IBlockBufferCache {
    private ChunkLayerMap<BufferCache> queue = new ChunkLayerMap();
    private ChunkLayerMap<BufferCache> uploaded = new ChunkLayerMap();
    private transient AdditionalBuffers additional = null;

    private BufferCache getUploaded(RenderType layer) {
        BufferCache holder = (BufferCache)this.uploaded.get(layer);
        if (holder != null && holder.isInvalid()) {
            this.uploaded.remove(layer);
            return null;
        }
        return holder;
    }

    private BufferCache getOriginal(RenderType layer) {
        BufferCache queued = (BufferCache)this.queue.get(layer);
        if (queued == null) {
            return this.getUploaded(layer);
        }
        return queued;
    }

    private BufferCache getAndRemoveOriginal(RenderType layer) {
        BufferCache queued = (BufferCache)this.queue.remove(layer);
        if (queued == null) {
            return this.getUploaded(layer);
        }
        return queued;
    }

    @Override
    public BufferCache getIncludingAdditional(RenderType layer) {
        BufferCache original = this.getOriginal(layer);
        if (this.hasAdditional()) {
            return this.additional.getAdditional(original, layer);
        }
        return original;
    }

    @Override
    public void upload(Function<RenderType, ChunkBufferUploader> builderSupplier, Function<RenderType, BufferCollection> bufferSupplier) {
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            if (!this.has(layer)) continue;
            ChunkBufferUploader uploader = builderSupplier.apply(layer);
            BufferCollection collection = bufferSupplier.apply(layer);
            BufferCache uploadable = this.getAndRemoveOriginal(layer);
            if (uploadable == null) {
                this.uploaded.remove(layer);
            } else {
                this.uploaded.put(layer, (Object)LittleRenderPipelineType.upload(uploader, collection, uploadable));
            }
            if (this.additional == null || !this.additional.has(layer)) continue;
            this.additional.uploadAdditional(layer, uploader, collection);
        }
    }

    @Override
    public void markUploaded(Function<RenderType, BufferCollection> bufferSupplier) {
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            if (!this.has(layer)) continue;
            BufferCollection collection = bufferSupplier.apply(layer);
            BufferCache uploadable = this.getAndRemoveOriginal(layer);
            if (uploadable == null) {
                this.uploaded.remove(layer);
            } else {
                this.uploaded.put(layer, (Object)LittleRenderPipelineType.markUploaded(collection, uploadable));
            }
            if (this.additional == null || !this.additional.has(layer)) continue;
            this.additional.markUploadedAdditional(layer, collection);
        }
    }

    @Override
    public synchronized BufferCache extract(RenderType layer, int toExtract) {
        BufferCache holder;
        ArrayList<BufferCache> buffers = null;
        if (this.additional != null) {
            for (LayeredBufferCache layeredCache : this.additional.additionals()) {
                BufferCache holder2 = (BufferCache)layeredCache.get(layer);
                if (holder2 == null) continue;
                BufferCache extracted = holder2.extract(toExtract);
                if (holder2.isEmpty()) {
                    layeredCache.remove(layer);
                }
                if (extracted == null) continue;
                if (buffers == null) {
                    buffers = new ArrayList<BufferCache>();
                }
                buffers.add(extracted);
            }
        }
        if ((holder = this.getOriginal(layer)) == null) {
            if (buffers != null) {
                return BufferCache.combineOrCopy(null, buffers);
            }
            return null;
        }
        boolean holderUploaded = this.uploaded.get(layer) != null;
        BufferCache extracted = holder.extract(toExtract);
        if (holder.isEmpty()) {
            if (holderUploaded) {
                this.uploaded.remove(layer);
            } else {
                this.queue.remove(layer);
            }
        }
        if (buffers != null) {
            return BufferCache.combineOrCopy(extracted, buffers);
        }
        return extracted;
    }

    @Override
    public boolean has(RenderType layer) {
        return this.queue.containsKey(layer) || this.getUploaded(layer) != null || this.additional != null && this.additional.has(layer);
    }

    public synchronized void setEmpty() {
        this.queue.clear();
        this.uploaded.clear();
        this.clearAdditional();
    }

    public boolean hasAdditional() {
        return this.additional != null;
    }

    public synchronized void setBuffers(ChunkLayerMap<BufferCache> buffers) {
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            BufferCache buffer = (BufferCache)buffers.get(layer);
            if (buffer == null) {
                this.uploaded.remove(layer);
            }
            if (buffer == null) {
                this.queue.remove(layer);
                continue;
            }
            this.queue.put(layer, (Object)buffer);
        }
        this.clearAdditional();
    }

    public synchronized void executeAdditional(Consumer<AdditionalBufferReceiver> consumer) {
        if (this.additional == null) {
            this.additional = new AdditionalBuffers();
        }
        consumer.accept(this.additional);
    }

    public void clearAdditional() {
        if (this.additional != null) {
            this.additional.removed();
        }
        this.additional = null;
    }

    public boolean hasInvalidBuffers() {
        for (Map.Entry entry : this.uploaded.tuples()) {
            if (entry.getValue() == null || !((BufferCache)entry.getValue()).isInvalid() && ((BufferCache)entry.getValue()).isAvailable() || this.queue.containsKey((RenderType)entry.getKey())) continue;
            return true;
        }
        return false;
    }
}

