/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.cache.buffer;

import java.util.ArrayList;
import java.util.List;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferDownloader;

public class BufferCollection {
    private List<BufferCache> buffers = new ArrayList<BufferCache>();
    private int length = 0;

    public void queueForUpload(BufferCache cache) {
        this.buffers.add(cache);
        this.length += cache.lengthToUpload();
    }

    public int length() {
        return this.length;
    }

    public void discard() {
        for (BufferCache holder : this.buffers) {
            holder.invalidate();
        }
    }

    public void download(ChunkBufferDownloader downloader) {
        for (BufferCache holder : this.buffers) {
            holder.download(downloader);
        }
    }

    public void eraseBuffers() {
        for (BufferCache holder : this.buffers) {
            holder.eraseBuffer();
        }
    }

    public boolean isEmpty() {
        return this.buffers.isEmpty();
    }

    public String toString() {
        return this.buffers.toString();
    }

    public Iterable<BufferCache> buffers() {
        return this.buffers;
    }
}

