/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.render.entity;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.level.little.FakeClientLevel;
import team.creative.littletiles.client.mod.sodium.SodiumManager;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.client.render.cache.pipeline.LittleRenderPipelineType;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.client.render.level.RenderAdditional;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;

@OnlyIn(value=Dist.CLIENT)
public class LittleAnimationRenderManager
extends LittleEntityRenderManager<LittleAnimationEntity>
implements RenderChunkExtender {
    protected final ChunkLayerMap<VertexBuffer> buffers = new ChunkLayerMap();
    protected final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.CHUNK_BUFFER_LAYERS.size());
    protected List<BlockEntity> renderableBlockEntities = new ArrayList<BlockEntity>();
    protected MeshData.SortState transparencyState;
    protected boolean needsUpdate = false;
    private RenderAdditional.SectionAdditional additional;
    public ChunkLayerMap<BufferCollection> lastUploaded;
    private volatile int queued;

    public static LittleEntityRenderManager of(LittleAnimationEntity entity) {
        if (SodiumManager.installed() && !(entity.level() instanceof FakeClientLevel)) {
            return SodiumManager.createRenderManager(entity);
        }
        return new LittleAnimationRenderManager(entity);
    }

    public LittleAnimationRenderManager(LittleAnimationEntity entity) {
        super(entity);
    }

    @Override
    public boolean isSmall() {
        return true;
    }

    @Override
    public RenderChunkExtender getRenderChunk(long pos) {
        return this;
    }

    @Override
    public RenderAdditional.SectionAdditional getAdditional() {
        return this.additional;
    }

    @Override
    public void setAdditional(RenderAdditional.SectionAdditional uploader) {
        this.additional = uploader;
    }

    @Override
    public ChunkLayerMap<BufferCollection> getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public void setLastUploaded(ChunkLayerMap<BufferCollection> uploaded) {
        this.lastUploaded = uploaded;
    }

    @Override
    public int getQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(int queued) {
        this.queued = queued;
    }

    @Override
    public LittleAnimationLevel getLevel() {
        return (LittleAnimationLevel)super.getLevel();
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        VertexBuffer buffer = (VertexBuffer)this.buffers.get(layer);
        if (buffer == null) {
            buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            this.buffers.put(layer, (Object)buffer);
        }
        return buffer;
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void compileSections(Camera camera) {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            this.hasBlocks.clear();
            this.renderableBlockEntities.clear();
            RebuildTask rebuild = new RebuildTask();
            Vec3 cam = camera.getPosition();
            CompileResults results = rebuild.compile((float)cam.x, (float)cam.y, (float)cam.z, LittleTilesClient.ANIMATION_HANDLER.fixedBuffers);
            this.globalBlockEntities.clear();
            this.globalBlockEntities.addAll(results.globalBlockEntities);
            this.renderableBlockEntities = results.blockEntities;
            this.transparencyState = results.transparencyState;
            this.prepareUpload();
            for (Map.Entry<RenderType, MeshData> entry : results.renderedLayers.entrySet()) {
                VertexBuffer buffer = this.getVertexBuffer(entry.getKey());
                if (!buffer.isInvalid()) {
                    buffer.bind();
                    buffer.upload(entry.getValue());
                    VertexBuffer.unbind();
                    BufferCollection buffers = rebuild.getBuffers(entry.getKey());
                    if (buffers != null) {
                        this.uploaded(entry.getKey(), buffers);
                    }
                    this.hasBlocks.add(entry.getKey());
                    continue;
                }
                buffer.close();
                LittleTiles.LOGGER.error("Could not upload chunk render data due to invalid buffer");
            }
        }
    }

    @Override
    protected void renderAllBlockEntities(PoseStack pose, Frustum frustum, Vec3 cam, float frameTime, MultiBufferSource bufferSource) {
        if (this.renderableBlockEntities != null) {
            for (BlockEntity blockEntity : this.renderableBlockEntities) {
                this.renderBlockEntity(blockEntity, pose, frustum, cam, frameTime, bufferSource);
            }
        }
    }

    @Override
    public MeshData.SortState getTransparencyState() {
        return this.transparencyState;
    }

    @Override
    public void setTransparencyState(MeshData.SortState state) {
        this.transparencyState = state;
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return !this.hasBlocks.contains(layer);
    }

    @Override
    public void setHasBlock(RenderType layer) {
        this.hasBlocks.add(layer);
    }

    @Override
    public VertexSorting createVertexSorting(double x, double y, double z) {
        BlockPos chunkOffset = ((LittleAnimationEntity)this.entity).getCenter().chunkOrigin;
        return VertexSorting.byDistance((float)((float)x - (float)chunkOffset.getX()), (float)((float)y - (float)chunkOffset.getY()), (float)((float)z - (float)chunkOffset.getZ()));
    }

    @Override
    public void resortTransparency(RenderType layer, double x, double y, double z) {
        ByteBufferBuilder.Result result;
        if (this.transparencyState != null && this.hasBlocks.contains(RenderType.translucent()) && (result = this.transparencyState.buildSortedIndexBuffer(LittleTilesClient.ANIMATION_HANDLER.fixedBuffers.buffer(RenderType.translucent()), this.createVertexSorting(x, y, z))) != null) {
            VertexBuffer buffer = this.getVertexBuffer(layer);
            if (buffer.isInvalid()) {
                result.close();
            } else {
                buffer.bind();
                buffer.uploadIndexBuffer(result);
                VertexBuffer.unbind();
            }
        }
    }

    @Override
    public void renderChunkLayer(RenderType layer, PoseStack pose, double x, double y, double z, Matrix4f projectionMatrix, Uniform offset) {
        if (this.hasBlocks.contains(layer)) {
            VertexBuffer vertexbuffer = (VertexBuffer)this.buffers.get(layer);
            if (vertexbuffer == null) {
                return;
            }
            if (offset != null) {
                BlockPos chunkOffset = ((LittleAnimationEntity)this.entity).getCenter().chunkOrigin;
                offset.set((float)chunkOffset.getX() - (float)x, (float)chunkOffset.getY() - (float)y, (float)chunkOffset.getZ() - (float)z);
                offset.upload();
            }
            vertexbuffer.bind();
            vertexbuffer.draw();
        }
    }

    @Override
    protected void setBlockDirty(BlockPos pos, boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void setBlocksDirty(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.needsUpdate = true;
    }

    @Override
    public void setBlockDirty(BlockPos pos, BlockState actualState, BlockState setState) {
        this.needsUpdate = true;
    }

    @Override
    protected void setSectionDirty(int x, int y, int z, boolean playerChanged) {
        this.needsUpdate = true;
    }

    @Override
    public void unload() {
        super.unload();
        this.buffers.forEach(VertexBuffer::close);
    }

    @Override
    public void allChanged() {
        super.allChanged();
        this.needsUpdate = true;
    }

    protected class RebuildTask {
        private ChunkLayerMap<BufferCollection> caches;
        private SectionBufferBuilderPack pack;
        private ChunkLayerMap<BufferBuilder> builders;

        protected RebuildTask() {
        }

        private CompileResults compile(float x, float y, float z, SectionBufferBuilderPack pack) {
            this.pack = pack;
            CompileResults results = new CompileResults();
            LittleRenderPipelineType.startCompile(LittleAnimationRenderManager.this);
            this.builders = new ChunkLayerMap();
            for (BETiles block : LittleAnimationRenderManager.this.getLevel()) {
                this.handleBlockEntity(results, block);
            }
            for (Tuple entry : this.builders.tuples()) {
                RenderType layer = (RenderType)entry.key;
                MeshData data = ((BufferBuilder)entry.value).build();
                if (data == null) continue;
                if (layer == RenderType.translucent()) {
                    results.transparencyState = data.sortQuads(pack.buffer(RenderType.translucent()), LittleAnimationRenderManager.this.createVertexSorting(x, y, z));
                }
                results.renderedLayers.put(layer, data);
            }
            LittleRenderPipelineType.endCompile(LittleAnimationRenderManager.this);
            this.pack = null;
            this.builders = null;
            return results;
        }

        private void handleBlockEntity(CompileResults results, BETiles entity) {
            LittleRenderPipelineType.compile(((LittleAnimationEntity)LittleAnimationRenderManager.this.entity).getCenter().chunkOffset.asLong(), entity, x -> (ChunkBufferUploader)this.builder((RenderType)x), x -> this.getOrCreateBuffers((RenderType)x));
            BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)entity);
            if (blockentityrenderer != null) {
                if (blockentityrenderer.shouldRenderOffScreen((BlockEntity)entity)) {
                    results.globalBlockEntities.add((BlockEntity)entity);
                } else {
                    results.blockEntities.add((BlockEntity)entity);
                }
            }
        }

        public BufferBuilder builder(RenderType layer) {
            BufferBuilder builder = (BufferBuilder)this.builders.get(layer);
            if (builder == null) {
                builder = new BufferBuilder(this.pack.buffer(layer), VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                this.builders.put(layer, (Object)builder);
            }
            return builder;
        }

        public BufferCollection getBuffers(RenderType layer) {
            if (this.caches == null) {
                return null;
            }
            return (BufferCollection)this.caches.get(layer);
        }

        public BufferCollection getOrCreateBuffers(RenderType layer) {
            BufferCollection cache;
            if (this.caches == null) {
                this.caches = new ChunkLayerMap();
            }
            if ((cache = (BufferCollection)this.caches.get(layer)) == null) {
                cache = new BufferCollection();
                this.caches.put(layer, (Object)cache);
            }
            return cache;
        }
    }

    static final class CompileResults {
        public final List<BlockEntity> globalBlockEntities = new ArrayList<BlockEntity>();
        public final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>();
        public final Map<RenderType, MeshData> renderedLayers = new Reference2ObjectArrayMap();
        @Nullable
        public MeshData.SortState transparencyState;

        CompileResults() {
        }

        public boolean isEmpty() {
            return this.renderedLayers.isEmpty() && this.globalBlockEntities.isEmpty() && this.blockEntities.isEmpty();
        }
    }
}

