/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool;

import com.google.common.base.Objects;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.render.mc.MeshDataExtender;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionPlace;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.packet.item.PlacerMatrixPacket;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PreviewMode;
import team.creative.littletiles.common.placement.mark.IMarkMode;
import team.creative.littletiles.common.placement.mark.MarkMode;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.second.InsideFixedHandler;
import team.creative.littletiles.common.structure.LittleStructureType;

public class LittleToolPlacer
extends LittleTool {
    private static final PoseStack EMPTY = new PoseStack();
    private final ILittlePlacer placer;
    private IMarkMode marked;
    private boolean markedFixed;
    private PlacementPosition placedPosition;
    private PlacementPosition aimedPosition;
    private LittleGrid lastGrid;
    private boolean built = false;
    private boolean builtLines;
    private IntMatrix3c builtMatrix;
    private int builtHash;
    private LittleBoxGrid builtBox;
    private PlacementMode builtMode;
    private LittleVecGrid builtInternalOffset;
    private LittleVecGrid builtSize;
    private LittleGroup builtLowGroup;
    private boolean builtEmpty;
    private LittleGroupResult builtResult;
    private CompletableFuture<LittleGroupResult> worker;

    public LittleToolPlacer(ItemStack stack) {
        super(stack);
        this.placer = (ILittlePlacer)stack.getItem();
    }

    public boolean isCentered() {
        if (!this.placer.canSnapToGrid(this.stack)) {
            return this.marked == null;
        }
        if (this.placer.snapToGridByDefault(this.stack)) {
            return LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid == LittleActionHandlerClient.isUsingSecondMode() || this.marked != null;
    }

    public boolean isFixed() {
        if (!this.placer.canSnapToGrid(this.stack)) {
            return this.marked != null;
        }
        if (this.placer.snapToGridByDefault(this.stack)) {
            return !LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
        }
        return LittleTiles.CONFIG.building.invertStickToGrid != LittleActionHandlerClient.isUsingSecondMode() && this.marked == null;
    }

    public PlacementPreview getPlacement(Level level) {
        return PlacementPreview.relative(level, this.builtResult.group, this.builtMode, this.placedPosition);
    }

    protected void buildCache(Level level, IntMatrix3c matrix, PlacementMode mode) {
        this.built = true;
        this.builtMode = mode;
        this.builtMatrix = matrix;
        this.builtInternalOffset = this.placer.getCachedMin(this.stack);
        this.builtSize = this.placer.getCachedSize(this.stack);
        this.builtEmpty = false;
        if (this.builtInternalOffset != null && this.builtSize != null) {
            this.builtInternalOffset.sameGrid((IGridBased)this.builtSize, () -> {
                LittleVec max = this.builtSize.getVec().copy();
                max.add(this.builtInternalOffset.getVec());
                this.builtBox = new LittleBoxGrid(new LittleBox(this.builtInternalOffset.getVec(), max), this.builtInternalOffset.getGrid());
                this.builtBox.getBox().transform(matrix, this.builtBox.getGrid().rotationCenter);
                this.builtInternalOffset = this.builtBox.getMin();
                this.builtSize = this.builtBox.getSize();
            });
        }
        this.builtLines = mode.getPreviewMode() == PreviewMode.LINES;
        CustomData stackData = (CustomData)this.stack.get(LittleTilesRegistry.DATA);
        this.builtHash = stackData != null ? stackData.hashCode() : 0;
        this.worker = CompletableFuture.supplyAsync(() -> {
            ByteBufferBuilder buffer = this.createBuffer();
            LittleGroup group = this.placer.get(this.stack, false);
            group.transform(matrix, group.getGrid().rotationCenter);
            BufferBuilder builder = this.createBuilder(buffer, this.builtLines);
            int colorAlpha = 255;
            for (RenderBox box : group.getPlaceBoxes(LittleVec.ZERO)) {
                this.buildBox(EMPTY, box, builder, colorAlpha, this.builtLines);
            }
            MeshData data = builder.build();
            ((MeshDataExtender)data).keepAlive(true);
            return new LittleGroupResult(group, buffer, data);
        }, Util.backgroundExecutor());
    }

    protected void removeCache() {
        this.built = false;
        if (this.worker != null) {
            this.worker.whenComplete((x, y) -> {
                if (x != null) {
                    x.close();
                }
            });
        }
        this.worker = null;
        if (this.builtResult != null) {
            this.builtResult.close();
        }
        this.builtLowGroup = null;
        this.builtResult = null;
        this.builtMode = null;
        this.builtBox = null;
    }

    @Override
    public void tick(Level level, Player player, @Nullable BlockHitResult blockHit) {
        if (blockHit == null) {
            return;
        }
        LittleGrid grid = this.placer.getPositionGrid(player, this.stack);
        PlacementPosition pos = this.marked != null ? this.marked.getPosition() : PlacementHelper.getPosition(level, blockHit, grid, this.placer, this.stack);
        PlacementMode mode = this.placer.getPlacementMode(this.stack);
        IntMatrix3c matrix = this.placer.getMatrix(this.stack);
        boolean hasTiles = this.placer.hasTiles(this.stack);
        Integer hash = Optional.ofNullable((CustomData)this.stack.get(LittleTilesRegistry.DATA)).map(CustomData::hashCode).orElse(0);
        if (!(!this.built || this.builtMode == mode && this.builtLines == (mode.getPreviewMode() == PreviewMode.LINES) && Objects.equal((Object)this.builtMatrix, (Object)matrix) && hasTiles && this.builtHash == hash)) {
            this.removeCache();
        }
        if (!this.built) {
            if (hasTiles) {
                this.buildCache(level, matrix, mode);
            } else {
                this.builtEmpty = true;
                if (this.builtResult != null || this.worker != null) {
                    this.removeCache();
                }
            }
            this.built = true;
        }
        this.aimedPosition = pos;
        this.lastGrid = grid;
        if (this.checkForWorker()) {
            this.placedPosition = this.calculatePlacementPosition(level, this.builtResult.group);
        } else if (this.checkForGroupLow()) {
            this.placedPosition = this.calculatePlacementPosition(level, null);
        }
    }

    @Override
    public boolean keyPressed(Level level, Player player, KeyMapping key) {
        if (key == LittleTilesClient.KEY_MARK) {
            if (this.marked == null) {
                this.markedFixed = LittleActionHandlerClient.isUsingSecondMode();
                PlacementPosition pos = this.aimedPosition.copy();
                if (this.markedFixed) {
                    pos.setVecContext(new LittleVecGrid(new LittleVec(0, 0, 0), this.lastGrid));
                }
                this.marked = this.onMark(player, pos);
            } else {
                this.markedFixed = false;
                this.marked.done();
                this.marked = null;
            }
            return true;
        }
        if (key == LittleTilesClient.KEY_UP) {
            if (this.marked != null) {
                this.marked.move(this.lastGrid, LittleActionHandlerClient.isUsingSecondMode() ? Facing.UP : Facing.EAST);
            } else {
                this.processTransform(player, key, this.stack);
            }
            return true;
        }
        if (key == LittleTilesClient.KEY_DOWN) {
            if (this.marked != null) {
                this.marked.move(this.lastGrid, LittleActionHandlerClient.isUsingSecondMode() ? Facing.DOWN : Facing.WEST);
            } else {
                this.processTransform(player, key, this.stack);
            }
            return true;
        }
        if (key == LittleTilesClient.KEY_RIGHT) {
            if (this.marked != null) {
                this.marked.move(this.lastGrid, Facing.SOUTH);
            } else {
                this.processTransform(player, key, this.stack);
            }
            return true;
        }
        if (key == LittleTilesClient.KEY_LEFT) {
            if (this.marked != null) {
                this.marked.move(this.lastGrid, Facing.NORTH);
            } else {
                this.processTransform(player, key, this.stack);
            }
            return true;
        }
        if (key == LittleTilesClient.KEY_MIRROR) {
            this.processTransform(player, key, this.stack);
        }
        return false;
    }

    protected void processTransform(Player player, KeyMapping key, ItemStack stack) {
        PlacerMatrixPacket packet = new PlacerMatrixPacket(LittleTilesClient.fromKeybind(player, key));
        packet.executeClient(player);
        LittleTiles.NETWORK.sendToServer((CreativePacket)packet);
        this.removeCache();
    }

    public boolean checkForWorker() {
        if (this.worker != null) {
            try {
                MeshData meshData;
                LittleGroupResult temp = this.worker.get(10L, TimeUnit.MILLISECONDS);
                if (this.builtResult != null && (meshData = this.builtResult.data) instanceof MeshDataExtender) {
                    MeshDataExtender m = (MeshDataExtender)meshData;
                    m.keepAlive(false);
                    this.builtResult.data.close();
                }
                if (this.builtInternalOffset == null) {
                    this.builtInternalOffset = new LittleVecGrid(temp.group.getMinVec(), temp.group.getGrid());
                }
                if (this.builtSize == null) {
                    this.builtSize = new LittleVecGrid(temp.group.getSize(), temp.group.getGrid());
                }
                this.builtResult = temp;
                this.worker = null;
            }
            catch (InterruptedException | ExecutionException e) {
                this.worker = null;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return this.builtResult != null;
    }

    public boolean checkForGroupLow() {
        if (this.builtBox == null || this.builtEmpty) {
            return false;
        }
        if (this.builtLowGroup == null) {
            this.builtLowGroup = new LittleGroup();
            this.builtLowGroup.add(this.builtBox, new LittleElement(Blocks.STONE.defaultBlockState(), -1));
        }
        return this.builtLowGroup != null;
    }

    public MeshData getMeshData(boolean lines) {
        if (this.checkForWorker()) {
            return this.builtResult.data;
        }
        if (!this.checkForGroupLow()) {
            return null;
        }
        BufferBuilder builder = this.createTesselatorBuilder(lines);
        for (RenderBox box : this.builtLowGroup.getPlaceBoxes(LittleVec.ZERO)) {
            this.buildBox(EMPTY, box, builder, 255, lines);
        }
        return builder.build();
    }

    @Override
    public void render(Level level, Player player, PoseStack pose, Vec3 cam, boolean lines) {
        if (this.builtLines != lines) {
            return;
        }
        MeshData mesh = this.getMeshData(lines);
        if (mesh == null || this.placedPosition == null) {
            return;
        }
        Matrix4fStack matrix = RenderSystem.getModelViewStack();
        matrix.pushMatrix();
        matrix.translate((float)(-cam.x), (float)(-cam.y), (float)(-cam.z));
        RenderSystem.applyModelViewMatrix();
        if (this.marked != null) {
            this.marked.render(this.placer.getPositionGrid(player, this.stack), pose);
        }
        matrix.translate((float)this.placedPosition.getPos().getX(), (float)this.placedPosition.getPos().getY(), (float)this.placedPosition.getPos().getZ());
        this.setupPreviewRenderer(lines);
        float internalX = (float)this.placedPosition.getVecGrid().getPosX();
        float internalY = (float)this.placedPosition.getVecGrid().getPosY();
        float internalZ = (float)this.placedPosition.getVecGrid().getPosZ();
        matrix.translate(internalX, internalY, internalZ);
        RenderSystem.applyModelViewMatrix();
        BufferUploader.drawWithShader((MeshData)mesh);
        matrix.translate(-internalX, -internalY, -internalZ);
        RenderSystem.applyModelViewMatrix();
        if (this.builtResult != null) {
            int colorAlpha = 255;
            if (LittleActionHandlerClient.isUsingSecondMode() != this.placer.snapToGridByDefault(this.stack)) {
                List<RenderBox> cubes = this.getPositingCubes(level, this.aimedPosition.getPos());
                BufferBuilder builder = this.createTesselatorBuilder(lines);
                if (cubes != null) {
                    for (RenderBox cube : cubes) {
                        this.buildBox(pose, cube, builder, colorAlpha, lines);
                    }
                }
            }
        }
        matrix.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private List<RenderBox> getPositingCubes(Level level, BlockPos pos) {
        LittleStructureType type;
        if (this.builtResult.group.hasStructure() && (type = this.builtResult.group.getStructureType()) != null) {
            return type.getPositingCubes(level, pos, this.stack);
        }
        return null;
    }

    @Override
    public void removed() {
        this.removeCache();
    }

    public PlacementPosition calculatePlacementPosition(Level level, @Nullable LittleGroup group) {
        PlacementPosition pos;
        if (group != null && group.isEmptyIncludeChildren()) {
            return null;
        }
        if (group != null) {
            group.convertToSmallest();
        }
        boolean centered = this.isCentered();
        boolean fixed = this.isFixed();
        boolean isMarked = this.marked != null;
        LittleVecGrid size = this.builtSize.copy();
        PlacementPosition placementPosition = pos = isMarked ? this.marked.getPosition() : this.aimedPosition.copy();
        if (group != null) {
            group.forceSameGrid(new IGridBased[]{pos, size});
        } else {
            pos.forceSameGrid((IGridBased)size);
        }
        LittleGrid grid = pos.getGrid();
        boolean singleMode = group != null && group.totalBoxes() == 1;
        LittleBox box = PlacementHelper.getTilesBox(pos, size.getVec(), centered || singleMode, this.builtMode.placeInside);
        if ((fixed || isMarked && this.markedFixed) && LittleAction.canPlaceInside(level, pos.getPos(), this.builtMode.placeInside)) {
            return new PlacementPosition(pos.getPos(), grid, isMarked ? pos.getVec() : new LittleVec(0, 0, 0), pos.facing);
        }
        PlacementPosition offset = new PlacementPosition(pos.getPos(), grid, box.getMinVec(), pos.facing);
        LittleVecGrid internalOffset = this.builtInternalOffset.copy();
        internalOffset.invert();
        offset.add(internalOffset);
        return offset;
    }

    protected PlacementPosition singleModePosition(Level level, LittleBox box, PlacementPosition pos, LittleGrid grid) {
        InsideFixedHandler fixedHandler = new InsideFixedHandler();
        box = fixedHandler.getBox(level, pos.getPos(), grid, box);
        PlacementPosition offset = new PlacementPosition(pos.getPos(), grid, box.getMinVec(), pos.facing);
        LittleVecGrid internalOffset = this.builtInternalOffset.copy();
        internalOffset.invert();
        offset.add(internalOffset);
        offset.convertTo(grid);
        return offset;
    }

    protected PlacementPosition groupModePosition(Level level, LittleBox box, PlacementPosition pos, LittleGrid grid) {
        PlacementPosition offset = new PlacementPosition(pos.getPos(), grid, box.getMinVec(), pos.facing);
        LittleVecGrid internalOffset = this.builtInternalOffset.copy();
        internalOffset.invert();
        offset.add(internalOffset);
        offset.convertTo(grid);
        return offset;
    }

    public IMarkMode onMark(Player player, PlacementPosition position) {
        return new MarkMode(player, position);
    }

    @Override
    public boolean onRightClick(Level level, Player player, BlockHitResult result) {
        this.markedFixed = false;
        if (!this.built) {
            return false;
        }
        if (!this.checkForWorker()) {
            if (this.builtEmpty || this.worker == null) {
                return false;
            }
            this.builtResult = this.worker.join();
        }
        if (LittleTilesClient.INTERACTION.start(true)) {
            PlacementPreview preview = this.getPlacement(level);
            if (preview == null) {
                return true;
            }
            LittleTilesClient.ACTION_HANDLER.execute(new LittleActionPlace(LittleActionPlace.PlaceAction.PLACER, preview));
            this.marked = null;
        }
        this.removeCache();
        return true;
    }

    public record LittleGroupResult(LittleGroup group, ByteBufferBuilder buffer, MeshData data) {
        public void close() {
            MeshData meshData = this.data;
            if (meshData instanceof MeshDataExtender) {
                MeshDataExtender m = (MeshDataExtender)meshData;
                m.keepAlive(false);
                this.data.close();
            }
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
    }
}

