/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool.shaper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleShaper;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.render.mc.MeshDataExtender;
import team.creative.littletiles.client.render.tile.LittleRenderBox;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.shaper.ShapePosition;
import team.creative.littletiles.client.tool.shaper.ShapeSelection;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.packet.item.ShapeConfigPacket;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PreviewMode;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.LittleShapeInstance;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.config.LittleShapeConfig;

public class LittleToolShaper
extends LittleTool {
    public final ILittleShaper shaper;
    private final List<ShapePosition> positions = new ArrayList<ShapePosition>();
    private ShapePosition last;
    private LittleGrid lastGrid;
    private boolean marked;
    private int markedPosition;
    private boolean built = false;
    private boolean builtLines;
    private ShapeSelection builtSelection;
    private LittleShape builtShape;
    private LittleShapeConfig builtShapeConfig;
    private CompletableFuture<ShapeResult> worker;
    private ShapeResult builtResult;

    public LittleToolShaper(ItemStack stack) {
        super(stack);
        this.shaper = (ILittleShaper)stack.getItem();
    }

    protected void removeCache() {
        this.built = false;
        if (this.worker != null) {
            this.worker.whenComplete((x, y) -> {
                if (x != null) {
                    x.close();
                }
            });
        }
        this.worker = null;
        if (this.builtResult != null) {
            this.builtResult.close();
        }
        this.builtResult = null;
        this.builtShape = null;
    }

    public void clearPositions() {
        this.marked = false;
        this.positions.clear();
        this.removeCache();
    }

    protected boolean hasPositionChanged() {
        if ((this.marked ? 0 : 1) + this.positions.size() != this.builtSelection.size()) {
            return true;
        }
        for (int i = 0; i < this.positions.size(); ++i) {
            if (this.positions.get(i).equals(this.builtSelection.get(i))) continue;
            return true;
        }
        return !this.marked && !this.builtSelection.getLast().equals(this.last);
    }

    protected List<ShapePosition> buildPositions() {
        ArrayList<ShapePosition> list = new ArrayList<ShapePosition>(this.positions.size() + (this.marked ? 0 : 1));
        for (ShapePosition p : this.positions) {
            list.add(p.copy());
        }
        if (!this.marked) {
            list.add(this.last.copy());
        }
        return list;
    }

    public void buildCache(Level level, LittleShape shape, LittleGrid grid, LittleShapeConfig config, boolean lines, boolean inside) {
        ShapeSelection sel;
        this.builtSelection = sel = ShapeSelection.of(level, grid, this.buildPositions(), inside);
        this.builtLines = lines;
        this.worker = CompletableFuture.supplyAsync(() -> {
            PoseStack pose = new PoseStack();
            LittleBoxes boxes = shape.build(sel, config);
            ByteBufferBuilder buffer = null;
            MeshData mesh = null;
            if (!boxes.isEmpty()) {
                buffer = this.createBuffer();
                BufferBuilder builder = this.createBuilder(buffer, lines);
                for (LittleBox box : boxes.all()) {
                    LittleRenderBox cube = box.getRenderingBox(boxes.getGrid());
                    if (cube == null) continue;
                    this.buildBox(pose, cube, builder, 255, lines);
                }
                mesh = builder.build();
                if (mesh instanceof MeshDataExtender) {
                    MeshDataExtender m = (MeshDataExtender)mesh;
                    m.keepAlive(true);
                }
            }
            return new ShapeResult(boxes, boxes.pos, buffer, mesh);
        }, Util.backgroundExecutor());
    }

    @Override
    public void tick(Level level, Player player, @Nullable BlockHitResult blockHit) {
        if (blockHit == null) {
            return;
        }
        LittleGrid grid = this.shaper.getPositionGrid(player, this.stack);
        boolean lines = this.shaper.previewMode(player, this.stack) == PreviewMode.LINES;
        LittleShapeInstance in = this.shaper.getShape(this.stack);
        LittleShapeConfig shapeConfig = in.getConfig((HolderLookup.Provider)player.registryAccess(), Side.CLIENT);
        LittleShape shape = in.shape;
        if (blockHit != null) {
            this.last = new ShapePosition(player, PlacementHelper.getPosition(level, blockHit, grid, this.shaper, this.stack), blockHit, false, this.shaper.previewInside(player, this.stack));
        }
        if (this.built && (this.builtShape != shape || !ShapeRegistry.SHAPE_CONFIG_REGISTRY.equals((Object)this.builtShapeConfig, (Object)shapeConfig, Side.CLIENT) || this.builtLines != lines || this.lastGrid != grid || this.hasPositionChanged())) {
            this.removeCache();
        }
        if (!this.built) {
            this.builtShape = shape;
            this.builtShapeConfig = shapeConfig;
            if (this.shaper.hasShape(player, this.stack) && (this.last != null || this.marked)) {
                this.buildCache(level, shape, grid, shapeConfig, lines, this.shaper.previewInside(player, this.stack));
            } else {
                if (this.builtResult != null) {
                    this.builtResult.close();
                }
                this.builtResult = null;
                this.builtShape = null;
                this.builtShapeConfig = null;
            }
            this.built = true;
        }
        this.lastGrid = grid;
    }

    public void toggleMark() {
        if (this.marked) {
            while (this.builtShape.maxAllowed() != -1 && this.positions.size() >= this.builtShape.maxAllowed()) {
                this.positions.remove(this.positions.size() - 1);
            }
            this.markedPosition = this.positions.size() - 1;
            this.marked = false;
        } else {
            this.markedPosition = this.positions.size();
            this.positions.add(this.last);
            this.marked = true;
        }
    }

    private boolean interact(Level level, Player player, ItemStack stack, BlockHitResult hit, boolean left) {
        boolean main;
        boolean bl = main = left == this.shaper.selectLeftClick(player, stack);
        if (!main && this.marked) {
            int index = -1;
            double distance = Double.MAX_VALUE;
            float partialTickTime = TickUtils.getFrameTime((LevelAccessor)player.level());
            Vec3 pos = player.getEyePosition(partialTickTime);
            double reach = PlayerUtils.getReach((Player)player);
            Vec3 view = player.getViewVector(partialTickTime);
            Vec3 look = pos.add(view.x * reach, view.y * reach, view.z * reach);
            for (int i = 0; i < this.positions.size(); ++i) {
                double tempDistance;
                Optional result = this.positions.get(i).getBox().clip(pos, look);
                if (!result.isPresent() || !((tempDistance = pos.distanceToSqr((Vec3)result.get())) < distance)) continue;
                index = i;
                distance = tempDistance;
            }
            if (index != -1) {
                this.markedPosition = index;
            }
            return true;
        }
        if (main) {
            boolean addPoint;
            if (LittleActionHandlerClient.isUsingSecondMode()) {
                this.clearPositions();
                return true;
            }
            if (this.builtShape == null) {
                return false;
            }
            boolean bl2 = addPoint = !(this.builtShape.pointsBeforePlacing <= this.positions.size() + 1 && !Screen.hasControlDown() || this.builtShape.maxAllowed() != -1 && this.builtShape.maxAllowed() <= this.positions.size() + 1);
            if (this.marked || !addPoint) {
                ShapeResult result = this.getShapeResult();
                LittleBoxes boxes = result != null ? result.boxes : this.builtShape.build(ShapeSelection.of(level, this.shaper.getPositionGrid(player, stack), this.buildPositions(), this.shaper.previewInside(player, stack)), this.builtShapeConfig);
                this.shaper.shapeFinished(level, player, stack, this.builtSelection, boxes);
                this.clearPositions();
                return true;
            }
            if (hit != null) {
                this.positions.add(this.last.copy());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onLeftClick(Level level, Player player, BlockHitResult hit) {
        return this.interact(level, player, this.stack, hit, true);
    }

    @Override
    public boolean onRightClick(Level level, Player player, BlockHitResult hit) {
        return this.interact(level, player, this.stack, hit, false);
    }

    public ShapeResult getShapeResult() {
        if (this.worker != null) {
            try {
                ShapeResult temp = this.worker.get(10L, TimeUnit.MILLISECONDS);
                if (this.builtResult != null) {
                    this.builtResult.close();
                }
                this.builtResult = temp;
                this.worker = null;
            }
            catch (InterruptedException | ExecutionException e) {
                this.worker = null;
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        return this.builtResult;
    }

    @Override
    public void render(Level level, Player player, PoseStack pose, Vec3 cam, boolean lines) {
        BlockPos pos;
        MeshData mesh;
        if (this.marked) {
            for (int i = 0; i < this.positions.size(); ++i) {
                this.positions.get(i).render(pose, this.markedPosition == i);
            }
        }
        if (this.builtLines != lines || !this.built) {
            return;
        }
        ShapeResult result = this.getShapeResult();
        if (result != null && result.data != null) {
            mesh = result.data;
            pos = result.pos;
        } else {
            ShapeSelection selection = this.builtSelection;
            BufferBuilder builder = this.createTesselatorBuilder(lines);
            this.buildBox(pose, selection.overallBox.getRenderingBox(selection.grid), builder, 255, lines);
            mesh = builder.build();
            pos = selection.pos;
        }
        if (mesh != null) {
            Matrix4fStack matrix = RenderSystem.getModelViewStack();
            matrix.pushMatrix();
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            matrix.translate((float)(-cam.x), (float)(-cam.y), (float)(-cam.z));
            RenderSystem.applyModelViewMatrix();
            this.setupPreviewRenderer(lines);
            BufferUploader.drawWithShader((MeshData)mesh);
            matrix.popMatrix();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }

    @Override
    public boolean keyPressed(Level level, Player player, KeyMapping key) {
        Facing facing;
        if (key == LittleTilesClient.KEY_MARK) {
            this.toggleMark();
            return true;
        }
        if (this.positions.size() > 1 && this.marked && (facing = LittleTilesClient.facingFromKeybind(player, key)) != null) {
            this.positions.get(this.markedPosition).move(this.lastGrid, facing);
            return true;
        }
        if (this.built && this.builtShapeConfig != null && this.builtShapeConfig.react(player, key)) {
            LittleShapeInstance in = ((LittleShapeInstance)player.getMainHandItem().get(LittleTilesRegistry.SHAPE)).configure((HolderLookup.Provider)player.registryAccess(), this.builtShapeConfig, Side.CLIENT);
            LittleTiles.NETWORK.sendToServer((CreativePacket)new ShapeConfigPacket(in));
            player.getMainHandItem().set(LittleTilesRegistry.SHAPE, (Object)in);
            this.removeCache();
            return true;
        }
        return false;
    }

    @Override
    public void removed() {
        this.clearPositions();
    }

    public record ShapeResult(LittleBoxes boxes, BlockPos pos, ByteBufferBuilder buffer, MeshData data) {
        public void close() {
            MeshData meshData = this.data;
            if (meshData instanceof MeshDataExtender) {
                MeshDataExtender m = (MeshDataExtender)meshData;
                m.keepAlive(false);
                this.data.close();
            }
            if (this.buffer != null) {
                this.buffer.close();
            }
        }
    }
}

