/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.action;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.config.LittleTilesConfig;
import team.creative.littletiles.common.entity.LittleEntity;

public abstract class LittleActionInteract<T>
extends LittleAction<T> {
    public BlockPos blockPos;
    public Vec3 pos;
    public Vec3 look;
    public Vec3 transformedPos;
    public Vec3 transformedLook;
    public boolean secondMode;
    @CanBeNull
    public UUID uuid;
    public boolean transformedCoordinates = false;

    @OnlyIn(value=Dist.CLIENT)
    public LittleActionInteract(Level level, BlockPos blockPos, Player player) {
        this.blockPos = blockPos;
        this.pos = player.getEyePosition(TickUtils.getFrameTime((LevelAccessor)level));
        double reach = PlayerUtils.getReach((Player)player);
        Vec3 look = player.getViewVector(TickUtils.getFrameTime((LevelAccessor)level));
        this.look = this.pos.add(look.x * reach, look.y * reach, look.z * reach);
        this.secondMode = LittleActionHandlerClient.isUsingSecondMode();
        if (level instanceof ISubLevel) {
            this.uuid = ((ISubLevel)level).getHolder().getUUID();
        }
    }

    public LittleActionInteract(Level level, BlockPos blockPos, Vec3 pos, Vec3 look, boolean secondMode) {
        this.blockPos = blockPos;
        this.pos = pos;
        this.look = look;
        this.secondMode = secondMode;
        if (level instanceof ISubLevel) {
            this.uuid = ((ISubLevel)level).getHolder().getUUID();
        }
    }

    public LittleActionInteract() {
    }

    protected abstract boolean requiresBreakEvent();

    protected abstract boolean isRightClick();

    protected abstract T action(Level var1, BETiles var2, LittleTileContext var3, ItemStack var4, Player var5, BlockHitResult var6, BlockPos var7, boolean var8) throws LittleActionException;

    protected abstract T ignored();

    @Override
    public T action(Player player) throws LittleActionException {
        Level level = player.level();
        if (!this.transformedCoordinates) {
            this.transformedPos = this.pos;
            this.transformedLook = this.look;
        }
        if (this.uuid != null) {
            LittleEntity animation = LittleTiles.ANIMATION_HANDLERS.find(level.isClientSide, this.uuid);
            if (animation == null) {
                this.onEntityNotFound();
            }
            if (!LittleActionInteract.isAllowedToInteract(player, animation, this.isRightClick())) {
                return this.failed();
            }
            level = (Level)animation.getSubLevel();
            if (!this.transformedCoordinates) {
                this.transformedPos = animation.getOrigin().transformPointToFakeWorld(this.transformedPos);
                this.transformedLook = animation.getOrigin().transformPointToFakeWorld(this.transformedLook);
                this.transformedCoordinates = true;
            }
        }
        if (this.requiresBreakEvent() && !LittleActionInteract.fireBlockBreakEvent(level, this.blockPos, player)) {
            throw new LittleTilesConfig.AreaProtected();
        }
        BlockEntity blockEntity = level.getBlockEntity(this.blockPos);
        if (blockEntity instanceof BETiles) {
            BETiles be = (BETiles)blockEntity;
            LittleTileContext context = be.getFocusedTile(this.transformedPos, this.transformedLook);
            if (!LittleActionInteract.isAllowedToInteract((LevelAccessor)level, player, this.blockPos, this.isRightClick(), Facing.EAST)) {
                LittleActionInteract.sendBlockResetToClient((LevelAccessor)level, player, (BlockEntity)be);
                return this.failed();
            }
            if (context.isComplete()) {
                ItemStack stack = player.getMainHandItem();
                BlockHitResult moving = this.rayTrace(be, context, this.transformedPos, this.transformedLook);
                if (moving != null) {
                    return this.action(level, be, context, stack, player, moving, this.blockPos, this.secondMode);
                }
            } else {
                this.onTileNotFound();
            }
        } else {
            this.onBlockEntityNotFound();
        }
        return this.ignored();
    }

    public BlockHitResult rayTrace(BETiles be, LittleTileContext tile, Vec3 pos, Vec3 look) {
        return be.rayTrace(pos, look);
    }

    protected void onEntityNotFound() throws LittleActionException {
        throw new LittleActionException.EntityNotFoundException();
    }

    protected void onTileNotFound() throws LittleActionException {
        throw new LittleActionException.TileNotFoundException();
    }

    protected void onBlockEntityNotFound() throws LittleActionException {
        throw new LittleActionException.BlockEntityNotFoundException();
    }
}

