/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.mc.BlockSignalConverter;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureBase;
import team.creative.littletiles.common.structure.signal.component.ISignalStructureComponent;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;
import team.creative.littletiles.common.structure.signal.network.SignalNetwork;

public class BESignalConverter
extends BlockEntity
implements ISignalStructureComponent {
    private SignalNetwork network;
    private SignalState inputSignalState = SignalState.create(4);
    private SignalState inputRedstoneState = SignalState.create(4);
    private List<SignalConnection> connections = new ArrayList<SignalConnection>();

    public BESignalConverter(BlockPos pos, BlockState state) {
        super((BlockEntityType)LittleTilesRegistry.BE_SIGNALCONVERTER_TYPE.get(), pos, state);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Facing side) {
        return state.isSignalSource() && side != null;
    }

    @Override
    public Level getStructureLevel() {
        return this.level;
    }

    @Override
    public int getBandwidth() {
        return 4;
    }

    @Override
    public SignalNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(SignalNetwork network) {
        this.network = network;
    }

    @Override
    public Iterator<ISignalStructureBase> connections() {
        return new Iterator<ISignalStructureBase>(){
            Iterator<SignalConnection> iterator;
            {
                this.iterator = BESignalConverter.this.connections.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ISignalStructureBase next() {
                return this.iterator.next().base;
            }
        };
    }

    @Override
    public boolean canConnect(Facing facing) {
        return true;
    }

    public int indexOf(ISignalStructureBase base) {
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get((int)i).base != base) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean connect(Facing facing, ISignalStructureBase base, LittleGrid context, int distance, boolean oneSidedRenderer) {
        int index = this.indexOf(base);
        if (index == -1) {
            this.connections.add(new SignalConnection(this, facing, base));
        }
        return true;
    }

    @Override
    public void disconnect(Facing facing, ISignalStructureBase base) {
        int index = this.indexOf(base);
        if (index != -1) {
            this.connections.remove(index);
        }
    }

    @Override
    public SignalComponentType getComponentType() {
        return SignalComponentType.IOSPECIAL;
    }

    @Override
    public void updateState(SignalState state) {
        if (!state.equals(this.inputSignalState)) {
            this.inputSignalState = this.inputSignalState.overwrite(state);
            this.changed();
        }
    }

    @Override
    public void changed() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        Direction facing = (Direction)state.getValue((Property)BlockSignalConverter.HORIZONTAL_FACING);
        this.level.neighborChanged(this.worldPosition.relative(facing), state.getBlock(), this.worldPosition);
    }

    public int getPower() {
        SignalState toReturn = SignalState.create(4);
        toReturn = toReturn.or(this.inputRedstoneState);
        toReturn = toReturn.or(this.inputSignalState);
        return toReturn.number();
    }

    @Override
    public SignalState getState() {
        return this.inputRedstoneState;
    }

    @Override
    public void overwriteState(SignalState state) throws CorruptedConnectionException, NotYetConnectedException {
        this.inputRedstoneState = this.inputRedstoneState.overwrite(state);
        this.inputRedstoneState.shrinkTo(4);
    }

    @Override
    public LittleStructure getStructure() {
        return null;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getColor() {
        return -1;
    }

    public void setPower(int level) {
        SignalState newLevel = SignalState.of(level);
        if (!this.inputRedstoneState.equals(newLevel)) {
            this.inputRedstoneState = this.inputRedstoneState.overwrite(newLevel);
            this.changed();
            this.findNetwork().update();
        }
    }

    @Override
    public void unload(Facing facing, ISignalStructureBase base) {
        int index = this.indexOf(base);
        if (index != -1) {
            this.connections.remove(index);
        }
    }

    public class SignalConnection {
        public final Facing facing;
        public final ISignalStructureBase base;

        public SignalConnection(BESignalConverter this$0, Facing facing, ISignalStructureBase base) {
            this.facing = facing;
            this.base = base;
        }
    }
}

