/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import team.creative.creativecore.common.be.BlockEntityCreative;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.block.ILittleBlockEntity;
import team.creative.littletiles.client.render.block.BERenderManager;
import team.creative.littletiles.client.render.level.RenderUploader;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.BlockParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.face.LittleFace;
import team.creative.littletiles.common.math.face.LittleServerFace;
import team.creative.littletiles.common.math.transformation.LittleBlockTransformer;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class BETiles
extends BlockEntityCreative
implements IGridBased,
ILittleBlockEntity {
    private boolean preventUnload = false;
    protected final BlockEntityInteractor interactor = new BlockEntityInteractor();
    private LittleGrid grid = LittleGrid.MIN;
    private BlockParentCollection tiles;
    private boolean unloaded = false;
    public final SideSolidCache sideCache = new SideSolidCache();
    @OnlyIn(value=Dist.CLIENT)
    public BERenderManager render;

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof BETiles) {
            BETiles be = (BETiles)blockEntity;
            if (!be.tiles.hasTicking() && !be.level.isClientSide) {
                be.customTilesUpdate();
                LittleTiles.LOGGER.warn("Ticking tileentity which shouldn't " + String.valueOf(be.getBlockPos()));
                return;
            }
            be.tick();
        }
    }

    public BETiles(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends BETiles>)((BlockEntityType)LittleTilesRegistry.BE_TILES_TYPE.get()), pos, state);
    }

    public BETiles(BlockEntityType<? extends BETiles> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void assign(BETiles te) {
        try {
            for (Field field : BETiles.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                field.set(this, field.get(te));
            }
            this.setLevel(this.getLevel());
            this.tiles.be = this;
            if (this.isClient()) {
                this.render.setBe(this);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (this.tiles == null) {
            this.init();
        }
    }

    private void init() {
        this.tiles = new BlockParentCollection(this, this.isClient());
        if (this.isClient()) {
            this.initClient();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void initClient() {
        this.render = new BERenderManager(this);
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public synchronized void convertTo(LittleGrid to) {
        boolean rendering = false;
        if (this.level != null && this.level.isClientSide) {
            rendering = this.render.getAndSetBlocked();
        }
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).convertTo(this.grid, to);
        }
        this.grid = to;
        if (this.level != null && this.level.isClientSide) {
            this.render.unsetBlocked();
            if (rendering) {
                this.render.queue(true, false, 0L);
            }
        }
    }

    @Override
    public int getSmallest() {
        int size = LittleGrid.MIN.count;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            size = Math.max(size, ((LittleTile)pair.value).getSmallest(this.grid));
        }
        return size;
    }

    public Iterable<LittleStructure> ticking() {
        return this.tiles.loadedStructures(1024);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleStructure> rendering() {
        return this.tiles.loadedStructures(2048);
    }

    public int tilesCount() {
        return this.tiles.totalSize();
    }

    public int boxesCount() {
        return this.tiles.totalBoxesCount();
    }

    public boolean hasLoaded() {
        return this.level != null && this.tiles != null;
    }

    public boolean shouldCheckForCollision() {
        return this.tiles.hasCollisionListener();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateQuadCache(long pos) {
        if (this.tiles == null) {
            return;
        }
        this.render.sectionUpdate(pos);
    }

    public void updateLighting() {
        AuxiliaryLightManager aux = this.level.getAuxLightManager(this.worldPosition);
        if (aux == null) {
            return;
        }
        aux.setLightAt(this.worldPosition, this.calculateLightEmission());
    }

    public int calculateLightEmission() {
        int light = 0;
        for (IParentCollection list : this.groups()) {
            if (list.isStructure() && LittleStructureAttribute.lightEmitter(list.getAttribute())) {
                try {
                    light = Math.max(light, list.getStructure().getLightValue(this.worldPosition));
                    continue;
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            for (LittleTile tile : list) {
                light = Math.max(light, (int)Math.ceil((double)tile.getLightValue() * tile.getPercentVolume(this.grid)));
            }
        }
        return light;
    }

    public BETiles forceSupportAttribute(int attribute) {
        return this.changeState(this.tiles.hasTicking() || LittleStructureAttribute.ticking(attribute), this.tiles.hasRendered() || LittleStructureAttribute.tickRendering(attribute));
    }

    protected BETiles changeState(boolean ticking, boolean rendered) {
        if (ticking == this.isTicking() && rendered == this.isRendered()) {
            return this;
        }
        BlockState state = BlockTile.getState(this.getBlockState(), ticking, rendered);
        this.preventUnload = true;
        this.level.setBlock(this.worldPosition, state, 20);
        BETiles newBE = (BETiles)this.level.getBlockEntity(this.worldPosition);
        newBE.assign(this);
        newBE.tiles.be = newBE;
        this.setRemoved();
        this.preventUnload = false;
        return newBE;
    }

    protected void customTilesUpdate() {
        if (this.level.isClientSide) {
            return;
        }
        if (this.tiles.isCompletelyEmpty()) {
            BlockState state = this.getBlockState();
            if (((Boolean)state.getValue((Property)BlockTile.WATERLOGGED)).booleanValue()) {
                this.level.setBlockAndUpdate(this.getBlockPos(), this.level.getFluidState(this.worldPosition).createLegacyBlock());
            } else {
                this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            }
            return;
        }
        this.changeState(this.tiles.hasTicking(), this.tiles.hasRendered());
    }

    private void updateNeighbour(Facing facing) {
        LittleServerFace face = new LittleServerFace(this);
        for (Pair<IParentCollection, LittleTile> pair : this.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                if (!box.hasOrCreateFaceState((IParentCollection)pair.key, (LittleTile)pair.value, face) || !box.getFaceState(facing).outside()) continue;
                box.setFaceState(facing, face.set((IParentCollection)pair.key, (LittleTile)pair.value, box, facing).calculate());
            }
        }
    }

    public void onNeighbourChanged(@Nullable Facing facing) {
        if (facing == null) {
            for (int i = 0; i < Facing.VALUES.length; ++i) {
                this.updateNeighbour(Facing.VALUES[i]);
            }
        } else {
            this.updateNeighbour(facing);
        }
        if (this.isClient()) {
            this.render.onNeighbourChanged();
        }
        this.notifyStructure();
    }

    public void notifyStructure() {
        for (LittleStructure structure : this.tiles.loadedStructures(65536)) {
            structure.neighbourChanged();
        }
    }

    public void updateTiles() {
        this.updateTiles(true, true);
    }

    public void updateTiles(boolean updateNeighbour, boolean rebuildFaces) {
        this.tiles.removeEmptyLists();
        this.notifyStructure();
        this.sideCache.reset();
        if (rebuildFaces) {
            this.rebuildFaces();
        }
        if (this.level != null) {
            this.markDirty();
            if (updateNeighbour) {
                this.updateNeighbour();
            }
            this.updateLighting();
        }
        if (this.isClient()) {
            this.render.tilesChanged();
        }
        this.customTilesUpdate();
    }

    public void updateTiles(Consumer<BlockEntityInteractor> action) {
        action.accept(this.interactor);
        this.updateTiles();
    }

    public void updateTilesSecretly(Consumer<BlockEntityInteractor> action) {
        action.accept(this.interactor);
    }

    public boolean convertBlockToVanilla() {
        LittleTile firstTile = null;
        if (this.tiles.isCompletelyEmpty()) {
            this.level.setBlock(this.getBlockPos(), Blocks.AIR.defaultBlockState(), 35);
            return true;
        }
        if (this.level instanceof IOrientatedLevel || this.tiles.countStructures() > 0) {
            return false;
        }
        if (this.tiles.size() == 1) {
            LittleTile first = this.tiles.first();
            if (!first.canBeConvertedToVanilla() || !first.doesFillEntireBlock(this.grid)) {
                return false;
            }
            firstTile = this.tiles.first();
            this.level.setBlockAndUpdate(this.getBlockPos(), firstTile.getBlock().getState());
            return true;
        }
        return false;
    }

    public boolean isBoxFilled(LittleBox box) {
        LittleVec size = box.getSize();
        boolean[][][] filled = new boolean[size.x][size.y][size.z];
        for (LittleTile tile : this.tiles) {
            tile.fillInSpace(box, filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbour() {
        this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
    }

    private LittleBox getLittleBlockBox() {
        int minX = this.grid.count;
        int minY = this.grid.count;
        int minZ = this.grid.count;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                minX = Math.min(box.minX, minX);
                minY = Math.min(box.minY, minY);
                minZ = Math.min(box.minZ, minZ);
                maxX = Math.max(box.maxX, maxX);
                maxY = Math.max(box.maxY, maxY);
                maxZ = Math.max(box.maxZ, maxZ);
            }
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AABB getBlockBB() {
        return this.getLittleBlockBox().getBB(this.grid);
    }

    public AABB getBlockBBWithOffset() {
        return this.getLittleBlockBox().getBB(this.grid, this.worldPosition);
    }

    public VoxelShape getBlockShape() {
        return this.getLittleBlockBox().getShape(this.grid);
    }

    public synchronized void rebuildFaces() {
        LittleServerFace face = new LittleServerFace(this);
        for (Pair<IParentCollection, LittleTile> entry : this.allTiles()) {
            for (LittleBox box : (LittleTile)entry.value) {
                for (int i = 0; i < Facing.VALUES.length; ++i) {
                    Facing facing = Facing.VALUES[i];
                    box.setFaceState(facing, face.set((IParentCollection)entry.getKey(), (LittleTile)entry.getValue(), box, facing).calculate());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldFaceBeRendered(LittleFace face, LittleTile rendered) {
        LittleGrid previous = this.getGrid();
        if (face.getGrid() != previous) {
            if (previous.count < face.getGrid().count) {
                this.convertTo(face.getGrid());
            } else {
                face.convertTo(previous);
            }
        }
        try {
            for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
                if (((IParentCollection)pair.key).isStructure() && LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) || !((LittleTile)pair.value).doesProvideSolidFace() && !((LittleTile)pair.value).canBeRenderCombined(rendered)) continue;
                ((LittleTile)pair.value).fillFace((IParentCollection)pair.key, face, this.grid);
            }
            boolean bl = !face.isFilled(rendered.isTranslucent());
            return bl;
        }
        finally {
            if (this.getGrid() != previous) {
                this.convertTo(previous);
            }
        }
    }

    public List<LittleBox> cutOut(LittleGrid grid, LittleBox box, List<LittleBox> cutout, @Nullable LittleBoxReturnedVolume volume) {
        ArrayList<LittleBox> cutting = new ArrayList<LittleBox>();
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            ((LittleTile)pair.value).getIntersectingBoxes(box, cutting);
        }
        return box.cutOut(grid, cutting, cutout, volume);
    }

    public Pair<IParentCollection, LittleTile> intersectingTile(LittleBox box) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (!((LittleTile)pair.value).intersectsWith(box)) continue;
            return pair;
        }
        return null;
    }

    public boolean isSpaceFor(LittleBox box, BiPredicate<IParentCollection, LittleTile> predicate) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((IParentCollection)pair.key, (LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceFor(LittleBox box, Predicate<LittleTile> predicate) {
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (predicate != null && !predicate.test((LittleTile)pair.value) || !((LittleTile)pair.value).intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceFor(LittleBox box) {
        return this.isSpaceFor(box, (Predicate<LittleTile>)null);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        if (this.tiles == null) {
            this.init();
        }
        boolean rendering = false;
        if (this.level != null && this.level.isClientSide) {
            rendering = this.render.getAndSetBlocked();
        }
        this.grid = LittleGrid.getOrThrow(nbt);
        this.tiles.load(nbt.getCompound("content"), provider);
        this.sideCache.load(nbt);
        if (this.level != null && !this.level.isClientSide) {
            this.level.setBlocksDirty(this.worldPosition, this.getBlockState(), this.getBlockState());
            this.customTilesUpdate();
        }
        if (this.level != null && this.level.isClientSide) {
            this.render.unsetBlocked();
            if (rendering) {
                this.render.queue(true, false, 0L);
            }
        }
    }

    protected int[] getIdentifier(LittleBox box) {
        return new int[]{box.minX, box.minY, box.minZ};
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        this.grid.set(nbt);
        nbt.put("content", (Tag)this.tiles.save(new LittleServerFace(this), provider));
        this.sideCache.write(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleUpdate(CompoundTag nbt, boolean chunkUpdate) {
        RenderUploader.notifyReceiveClientUpdate(this);
        this.loadAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        if (!chunkUpdate) {
            this.updateTiles(false, false);
        }
    }

    public BlockHitResult rayTrace(Player player) {
        Level level;
        Vec3 pos = player.getPosition(TickUtils.getFrameTime((LevelAccessor)this.level));
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.getViewVector(TickUtils.getFrameTime((LevelAccessor)this.level));
        Vec3 look = pos.add(view.x * distance, view.y * distance, view.z * distance);
        if (this.level != player.level() && (level = this.level) instanceof IOrientatedLevel) {
            IOrientatedLevel or = (IOrientatedLevel)level;
            pos = or.getOrigin().transformPointToFakeWorld(pos);
            look = or.getOrigin().transformPointToFakeWorld(look);
        }
        return this.rayTrace(pos, look);
    }

    public BlockHitResult rayTrace(Vec3 pos, Vec3 look) {
        BlockHitResult result = null;
        double distance = 0.0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                BlockHitResult temphit = box.rayTrace(this.grid, this.getBlockPos(), pos, look);
                if (temphit == null) continue;
                double tempDistance = temphit.getLocation().distanceToSqr(pos);
                if (result != null && !(distance > tempDistance)) continue;
                distance = tempDistance;
                result = temphit;
            }
        }
        return result;
    }

    public LittleTileContext getFocusedTile(Player player, float partialTickTime) {
        Level level;
        if (!this.isClient()) {
            return null;
        }
        Vec3 pos = player.getEyePosition(partialTickTime);
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.getViewVector(partialTickTime);
        Vec3 look = pos.add(view.x * distance, view.y * distance, view.z * distance);
        if (this.level != player.level() && (level = this.level) instanceof IOrientatedLevel) {
            IOrientatedLevel or = (IOrientatedLevel)level;
            pos = or.getOrigin().transformPointToFakeWorld(pos);
            look = or.getOrigin().transformPointToFakeWorld(look);
        }
        return this.getFocusedTile(pos, look);
    }

    public LittleTileContext getFocusedTile(Vec3 pos, Vec3 look) {
        IParentCollection parent = null;
        LittleTile tileFocus = null;
        LittleBox boxFocus = null;
        double distance = 0.0;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            for (LittleBox box : (LittleTile)pair.value) {
                BlockHitResult Temphit = box.rayTrace(this.grid, this.getBlockPos(), pos, look);
                if (Temphit == null) continue;
                double tempDistance = Temphit.getLocation().distanceToSqr(pos);
                if (tileFocus != null && !(distance > tempDistance)) continue;
                distance = tempDistance;
                parent = (IParentCollection)pair.key;
                tileFocus = (LittleTile)pair.value;
                boxFocus = box;
            }
        }
        if (tileFocus == null) {
            return LittleTileContext.FAILED;
        }
        return new LittleTileContext(parent, tileFocus, boxFocus);
    }

    public boolean isTicking() {
        return BlockTile.isTicking(this.getBlockState());
    }

    public boolean isRendered() {
        return false;
    }

    public boolean combineStructureTiles(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = ((StructureParentCollection)this.getStructure(structureIndex)).combine(this.getGrid(), false);
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineStructureTilesSecretly(int structureIndex) {
        if (this.getStructure(structureIndex) == null) {
            return false;
        }
        boolean changed = ((StructureParentCollection)this.getStructure(structureIndex)).combine(this.getGrid(), false);
        this.convertToSmallest();
        return changed;
    }

    public boolean combineAllTiles(boolean optimized) {
        boolean changed = this.tiles.combineAllTiles(optimized);
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean optimizeTiles() {
        boolean changed = this.tiles.optimizeTiles();
        this.convertToSmallest();
        if (changed) {
            this.updateTiles();
        }
        return changed;
    }

    public boolean combineNoneTilesSecretly(boolean optimized) {
        boolean changed = this.tiles.combineNoneTiles(optimized);
        this.convertToSmallest();
        return changed;
    }

    @Override
    @Nullable
    public BlockState getState(AABB box, boolean realistic) {
        if (this.tiles == null) {
            return null;
        }
        if (realistic) {
            box = box.expandTowards(0.0, -this.grid.pixelLength, 0.0);
            for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
                if (((LittleTile)pair.value).noCollision()) continue;
                for (LittleBox tileBox : (LittleTile)pair.value) {
                    if (!tileBox.getBB(this.grid, this.getBlockPos()).intersects(box)) continue;
                    return ((LittleTile)pair.value).getBlock().getState();
                }
            }
            return null;
        }
        box = box.expandTowards(0.0, -1.0, 0.0);
        LittleElement highest = null;
        LittleBox highestBox = null;
        for (Pair<IParentCollection, LittleTile> pair : this.tiles.allTiles()) {
            if (((LittleTile)pair.value).noCollision()) continue;
            Iterator<LittleBox> iterator = ((LittleTile)highest).iterator();
            while (iterator.hasNext()) {
                LittleBox tileBox = iterator.next();
                if (highest != null && (tileBox.maxY <= highestBox.maxY || !tileBox.getBB(this.grid, this.getBlockPos()).intersects(box))) continue;
                highest = (LittleTile)pair.value;
                highestBox = tileBox;
            }
        }
        return highest != null ? highest.getBlock().getState() : null;
    }

    public boolean isEmpty() {
        return this.tiles.isCompletelyEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isRenderingEmpty() {
        return this.tiles.isCompletelyEmpty() && !this.render.hasAdditionalBuffers();
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.preventUnload && this.tiles != null) {
            this.tiles.unload();
        }
    }

    public boolean unloaded() {
        return this.unloaded;
    }

    public void onChunkUnloaded() {
        this.unloaded = true;
        super.onChunkUnloaded();
        this.tiles.unload();
        if (this.level.isClientSide) {
            this.tiles = null;
            this.render.chunkUnload();
        }
    }

    public void rotate(net.minecraft.world.level.block.Rotation rotation) {
        LittleBlockTransformer.rotate(this, Rotation.getRotation((net.minecraft.world.level.block.Rotation)rotation), Rotation.getRotationCount((net.minecraft.world.level.block.Rotation)rotation));
        this.updateTiles();
    }

    public void mirror(Mirror mirror) {
        LittleBlockTransformer.mirror(this, Axis.getMirrorAxis((Mirror)mirror));
        this.updateTiles();
    }

    public String toString() {
        return this.getBlockPos().toString();
    }

    public void tick() {
        for (LittleStructure structure : this.ticking()) {
            structure.tick();
        }
    }

    public Iterable<IParentCollection> groups() {
        return this.tiles.groups();
    }

    public IParentCollection noneStructureTiles() {
        return this.tiles;
    }

    public Iterable<Pair<IParentCollection, LittleTile>> allTiles() {
        return this.tiles.allTiles();
    }

    public Iterable<Pair<IParentCollection, LittleTile>> allBoxes() {
        return this.tiles.allTiles();
    }

    public IStructureParentCollection getStructure(int index) {
        return this.tiles.getStructure(index);
    }

    public Iterable<LittleStructure> loadedStructures() {
        if (this.tiles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.tiles.loadedStructures();
    }

    public Iterable<LittleStructure> loadedStructures(int attribute) {
        if (this.tiles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.tiles.loadedStructures(attribute);
    }

    public Iterable<IStructureParentCollection> structures() {
        return this.tiles.structures();
    }

    public void fillUsedIds(BitSet usedIds) {
        this.tiles.fillUsedIds(usedIds);
    }

    public class BlockEntityInteractor {
        public Iterable<ParentCollection> groups() {
            return new IterableIterator<ParentCollection>(){
                ParentCollection current;
                Iterator<StructureParentCollection> children;
                {
                    this.current = BETiles.this.tiles;
                    this.children = BlockEntityInteractor.this.structures().iterator();
                }

                public boolean hasNext() {
                    if (this.current != null) {
                        return true;
                    }
                    if (!this.children.hasNext()) {
                        return false;
                    }
                    this.current = this.children.next();
                    return true;
                }

                public ParentCollection next() {
                    ParentCollection result = this.current;
                    this.current = null;
                    return result;
                }
            };
        }

        public ParentCollection get(IParentCollection list) {
            return (ParentCollection)list;
        }

        public StructureParentCollection get(IStructureParentCollection list) {
            return (StructureParentCollection)list;
        }

        public ParentCollection noneStructureTiles() {
            return BETiles.this.tiles;
        }

        public Iterable<StructureParentCollection> structures() {
            return BETiles.this.tiles.structuresReal();
        }

        public StructureParentCollection getStructure(int index) {
            return BETiles.this.tiles.getStructure(index);
        }

        public boolean removeStructure(int index) {
            return BETiles.this.tiles.removeStructure(index);
        }

        public StructureParentCollection addStructure(int index, int attribute) {
            return BETiles.this.tiles.addStructure(index, attribute);
        }
    }

    public class SideSolidCache {
        SideState EAST;
        SideState WEST;
        SideState UP;
        SideState DOWN;
        SideState SOUTH;
        SideState NORTH;
        SideState YAXIS;

        public void load(CompoundTag nbt) {
            this.EAST = nbt.contains("east") ? SideState.values()[nbt.getInt("east")] : null;
            this.WEST = nbt.contains("west") ? SideState.values()[nbt.getInt("west")] : null;
            this.UP = nbt.contains("up") ? SideState.values()[nbt.getInt("up")] : null;
            this.DOWN = nbt.contains("down") ? SideState.values()[nbt.getInt("down")] : null;
            this.SOUTH = nbt.contains("south") ? SideState.values()[nbt.getInt("south")] : null;
            this.NORTH = nbt.contains("north") ? SideState.values()[nbt.getInt("north")] : null;
            this.YAXIS = nbt.contains("y_axis") ? SideState.values()[nbt.getInt("y_axis")] : null;
        }

        public void write(CompoundTag nbt) {
            if (this.EAST != null) {
                nbt.putInt("east", this.EAST.ordinal());
            }
            if (this.WEST != null) {
                nbt.putInt("west", this.WEST.ordinal());
            }
            if (this.UP != null) {
                nbt.putInt("up", this.UP.ordinal());
            }
            if (this.DOWN != null) {
                nbt.putInt("down", this.DOWN.ordinal());
            }
            if (this.SOUTH != null) {
                nbt.putInt("south", this.SOUTH.ordinal());
            }
            if (this.NORTH != null) {
                nbt.putInt("north", this.NORTH.ordinal());
            }
            if (this.YAXIS != null) {
                nbt.putInt("y_axis", this.YAXIS.ordinal());
            }
        }

        public void reset() {
            this.DOWN = null;
            this.UP = null;
            this.NORTH = null;
            this.SOUTH = null;
            this.WEST = null;
            this.EAST = null;
            this.YAXIS = null;
        }

        public SideState getYAxis() {
            if (this.YAXIS != null) {
                return this.YAXIS;
            }
            LittleBox box = new LittleBox(0, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
            boolean[][] filled = new boolean[BETiles.this.grid.count][BETiles.this.grid.count];
            boolean translucent = false;
            boolean noclip = false;
            for (Pair<IParentCollection, LittleTile> pair : BETiles.this.tiles.allTiles()) {
                if (!((LittleTile)pair.value).fillInSpaceInaccurate(box, Axis.X, Axis.Z, Axis.Y, filled)) continue;
                if (!((LittleTile)pair.value).doesProvideSolidFace()) {
                    translucent = true;
                }
                if (!LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) && !((LittleTile)pair.value).getBlock().noCollision()) continue;
                noclip = true;
            }
            for (int one = 0; one < filled.length; ++one) {
                for (int two = 0; two < filled[one].length; ++two) {
                    if (filled[one][two]) continue;
                    return SideState.EMPTY;
                }
            }
            this.YAXIS = SideState.getState(false, noclip, translucent);
            return this.YAXIS;
        }

        protected SideState calculate(Facing facing) {
            LittleBox box = switch (facing) {
                case Facing.EAST -> new LittleBox(BETiles.this.grid.count - 1, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.WEST -> new LittleBox(0, 0, 0, 1, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.UP -> new LittleBox(0, BETiles.this.grid.count - 1, 0, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.DOWN -> new LittleBox(0, 0, 0, BETiles.this.grid.count, 1, BETiles.this.grid.count);
                case Facing.SOUTH -> new LittleBox(0, 0, BETiles.this.grid.count - 1, BETiles.this.grid.count, BETiles.this.grid.count, BETiles.this.grid.count);
                case Facing.NORTH -> new LittleBox(0, 0, 0, BETiles.this.grid.count, BETiles.this.grid.count, 1);
                default -> null;
            };
            return this.calculateState(facing, box);
        }

        public SideState calculateState(Facing facing, LittleBox box) {
            LittleVec size = box.getSize();
            boolean[][][] filled = new boolean[size.x][size.y][size.z];
            boolean translucent = false;
            boolean noclip = false;
            for (Pair<IParentCollection, LittleTile> pair : BETiles.this.tiles.allTiles()) {
                if (!((LittleTile)pair.value).fillInSpaceInaccurate(box, filled)) continue;
                if (!((LittleTile)pair.value).doesProvideSolidFace()) {
                    translucent = true;
                }
                if (!LittleStructureAttribute.noCollision(((IParentCollection)pair.key).getAttribute()) && !((LittleTile)pair.value).getBlock().noCollision()) continue;
                noclip = true;
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return SideState.EMPTY;
                    }
                }
            }
            return SideState.getState(false, noclip, translucent);
        }

        public SideState get(Facing facing) {
            SideState result;
            switch (facing) {
                case DOWN: {
                    SideState sideState = this.DOWN;
                    break;
                }
                case UP: {
                    SideState sideState = this.UP;
                    break;
                }
                case NORTH: {
                    SideState sideState = this.NORTH;
                    break;
                }
                case SOUTH: {
                    SideState sideState = this.SOUTH;
                    break;
                }
                case WEST: {
                    SideState sideState = this.WEST;
                    break;
                }
                case EAST: {
                    SideState sideState = this.EAST;
                    break;
                }
                default: {
                    SideState sideState = result = SideState.EMPTY;
                }
            }
            if (result == null) {
                result = this.calculate(facing);
                this.set(facing, result);
            }
            return result;
        }

        public void set(Facing facing, SideState value) {
            switch (facing) {
                case DOWN: {
                    this.DOWN = value;
                    break;
                }
                case UP: {
                    this.UP = value;
                    break;
                }
                case NORTH: {
                    this.NORTH = value;
                    break;
                }
                case SOUTH: {
                    this.SOUTH = value;
                    break;
                }
                case WEST: {
                    this.WEST = value;
                    break;
                }
                case EAST: {
                    this.EAST = value;
                }
            }
        }

        public boolean isCollisionFullBlock() {
            for (int i = 0; i < Facing.VALUES.length; ++i) {
                if (this.get(Facing.VALUES[i]).isFilled()) continue;
                return false;
            }
            return true;
        }
    }

    public static enum SideState {
        EMPTY{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return false;
            }
        }
        ,
        SEETHROUGH{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SEETHROUGH_NOCLIP{

            @Override
            public boolean doesBlockCollision() {
                return false;
            }

            @Override
            public boolean doesBlockLight() {
                return false;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        }
        ,
        SOLID{

            @Override
            public boolean doesBlockCollision() {
                return true;
            }

            @Override
            public boolean doesBlockLight() {
                return true;
            }

            @Override
            public boolean isFilled() {
                return true;
            }
        };


        public abstract boolean isFilled();

        public abstract boolean doesBlockCollision();

        public abstract boolean doesBlockLight();

        public static SideState getState(boolean empty, boolean noclip, boolean translucent) {
            if (empty) {
                return EMPTY;
            }
            if (noclip && translucent) {
                return SEETHROUGH_NOCLIP;
            }
            if (noclip) {
                return NOCLIP;
            }
            if (translucent) {
                return SEETHROUGH;
            }
            return SOLID;
        }
    }
}

